/*
 * Decompiled with CFR 0.152.
 */
package learn;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import learn.BotToStudy;
import learn.GunHandler;
import learn.Net;
import learn.SurfHandler;
import learn.Utilities;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class ISmart
extends AdvancedRobot {
    static final boolean isMC = false;
    static final boolean isTC = false;
    static List<Integer> topology = new ArrayList<Integer>();
    static List<Integer> moveTopology = new ArrayList<Integer>();
    static BotToStudy enemy;
    static Utilities utils;
    GunHandler gWaver;
    SurfHandler sWaver;
    static HashMap<double[], Double> gunOffsetMap;
    static Net net;
    static Net moveNet;
    double heading;
    double velocity;
    double radarOffset;
    double greatestDist;
    Point2D.Double position;
    long wins = 0L;
    static double[] gunWeights;
    RoundRectangle2D.Double playField;

    static {
        gunOffsetMap = new HashMap();
    }

    public void run() {
        topology.clear();
        topology.add(13);
        topology.add(15);
        topology.add(1);
        topology.add(5);
        topology.add(1);
        if (net == null) {
            net = new Net(topology);
        }
        moveTopology.add(13);
        moveTopology.add(15);
        moveTopology.add(1);
        moveTopology.add(5);
        moveTopology.add(1);
        if (moveNet == null) {
            moveNet = new Net(moveTopology);
        }
        this.setColors(new Color(123, 0, 26), Color.white, new Color(123, 0, 26));
        this.greatestDist = Math.sqrt(this.getBattleFieldWidth() * this.getBattleFieldWidth() + this.getBattleFieldHeight() * this.getBattleFieldHeight());
        this.playField = new RoundRectangle2D.Double(20.0, 20.0, this.getBattleFieldWidth() - 40.0, this.getBattleFieldHeight() - 40.0, 18.0, 18.0);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustGunForRobotTurn(true);
        if (enemy == null) {
            enemy = new BotToStudy();
        }
        if (utils == null) {
            utils = new Utilities(this);
        }
        if (this.gWaver == null) {
            this.gWaver = new GunHandler(this, utils, enemy);
            System.out.println("newGun");
        }
        if (this.sWaver == null) {
            this.sWaver = new SurfHandler(this, utils, enemy);
        }
        if (gunWeights == null) {
            gunWeights = new double[6];
        } else {
            this.gWaver.weights = gunWeights;
        }
        while (true) {
            this.turnRadarRight(Double.POSITIVE_INFINITY);
        }
    }

    void updateStats() {
        this.velocity = this.getVelocity();
        this.heading = this.getHeadingRadians();
        this.position = new Point2D.Double(this.getX(), this.getY());
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.updateStats();
        ISmart.enemy.velocity = e.getVelocity();
        ISmart.enemy.heading = e.getHeadingRadians();
        ISmart.enemy.bearing = e.getBearingRadians();
        ISmart.enemy.absBearing = Utils.normalRelativeAngle((double)(this.heading + ISmart.enemy.bearing));
        ISmart.enemy.distance = e.getDistance();
        ISmart.enemy.position = utils.project(this.position, ISmart.enemy.distance, ISmart.enemy.absBearing);
        ISmart.enemy.absBearingFrom = utils.getAbsBearing(ISmart.enemy.position, this.position);
        ISmart.enemy.lateralHeading = Utils.normalRelativeAngle((double)(ISmart.enemy.heading - ISmart.enemy.absBearing));
        ISmart.enemy.lateralVelocity = ISmart.enemy.velocity * Math.sin(ISmart.enemy.heading - ISmart.enemy.absBearing);
        ISmart.enemy.angularVelocity = ISmart.enemy.lateralVelocity / ISmart.enemy.distance;
        ISmart.enemy.energy = e.getEnergy();
        ISmart.enemy.latDirection = ISmart.enemy.velocity != 0.0 ? utils.sign(ISmart.enemy.lateralVelocity) : ISmart.enemy.lastLatDirection;
        ISmart.enemy.lastLatDirection = ISmart.enemy.latDirection;
        this.radarOffset = Utils.normalRelativeAngle((double)(ISmart.enemy.absBearing - this.getRadarHeadingRadians()));
        this.setTurnRadarRightRadians(2.0 * this.radarOffset);
        this.gWaver.update();
        this.sWaver.update();
        ISmart.enemy.lastLateralVelocity = ISmart.enemy.lateralVelocity;
        ISmart.enemy.lastVelocity = ISmart.enemy.velocity;
        ISmart.enemy.lastEnergy = ISmart.enemy.energy;
        ISmart.enemy.lastBearing = ISmart.enemy.bearing;
        ISmart.enemy.lastLateralHeading = ISmart.enemy.lateralHeading;
        this.execute();
    }

    public void onHitByBullet(HitByBulletEvent e) {
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        this.sWaver.storeEvent(new Point2D.Double(e.getHitBullet().getX(), e.getHitBullet().getY()), true);
    }

    public void onHitWall(HitWallEvent e) {
    }

    public void onBulletHit(BulletHitEvent e) {
        this.gWaver.timeSinceHit = 0.0;
    }

    public void onDeath(DeathEvent e) {
        gunWeights = this.gWaver.weights;
        gunOffsetMap = this.gWaver.offsetMap;
        net = this.gWaver.myNet;
        moveNet = this.sWaver.myNet;
        System.out.println("I died, yay!");
    }

    public void onWin(WinEvent e) {
        gunWeights = this.gWaver.weights;
        gunOffsetMap = this.gWaver.offsetMap;
        net = this.gWaver.myNet;
        moveNet = this.sWaver.myNet;
        this.out.println("I'm alive, yay!");
    }

    public void onPaint(Graphics2D g) {
        double radius;
        g.setColor(Color.green);
        for (GunHandler gunHandler : this.gWaver.waveGroup) {
            radius = gunHandler.distTravelled + gunHandler.bSpeed;
            g.drawOval((int)(gunHandler.shotPosition.x - radius + 0.5), (int)(gunHandler.shotPosition.y - radius + 0.5), (int)(radius * 2.0 + 0.5), (int)(radius * 2.0 + 0.5));
        }
        g.setColor(Color.red);
        for (SurfHandler surfHandler : SurfHandler.surfGroup) {
            radius = surfHandler.distTravelled + surfHandler.bSpeed;
            g.drawOval((int)(surfHandler.shotPosition.x - radius + 0.5), (int)(surfHandler.shotPosition.y - radius + 0.5), (int)(radius * 2.0 + 0.5), (int)(radius * 2.0 + 0.5));
        }
    }
}

