/*
 * Decompiled with CFR 0.152.
 */
package fnc.bandit;

import fnc.bandit.Analyser;
import fnc.bandit.Path;
import fnc.bandit.Position;
import fnc.bandit.Util;
import java.io.PrintStream;

public class CircularAnalyser
extends Analyser {
    double velocity = 1.0;
    double angular_velocity = 1.0;

    public void dump(PrintStream printStream) {
        printStream.print("Circular [" + Util.round(this.abs_error) + "] (");
        printStream.print(Util.round(this.velocity) + ", ");
        printStream.print(Util.round(this.angular_velocity));
        printStream.println(")");
    }

    public double analyse(Path path) {
        int n = path.getCount();
        if (n < 3) {
            this.velocity = 0.0;
        } else if (n > 10) {
            this.computeVelocity(path, 10);
        } else {
            this.computeVelocity(path, n - 1);
        }
        this.absError(path);
        return this.abs_error;
    }

    public void computeVelocity(Path path, int n) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        Position position = path.getPosition(-n);
        int n2 = -n + 1;
        while (n2 <= 0) {
            Position position2 = path.getPosition(n2);
            d3 += Util.angular_diff(position.h, position2.h) / (position2.t - position.t);
            d = position2.t - position.t;
            d2 = position.distance(position2);
            d4 += d2 / d;
            ++n2;
        }
        this.angular_velocity = d3 / (double)n;
        this.velocity = d4 / (double)n;
    }

    public Position predictPosition(Path path, double d, double d2) {
        Position position = path.getPosition(0);
        double d3 = d + (d2 - position.t);
        Position position2 = new Position(0.0, 0.0, d2 + d);
        if (Math.abs(this.angular_velocity) < 0.001) {
            position2.x = position.x;
            position2.y = position.y;
        } else {
            double d4 = Util.normalize2(position.h - 1.5707963267948966);
            double d5 = d4 + this.angular_velocity * d3;
            double d6 = this.velocity / this.angular_velocity;
            position2.x = position.x + Math.sin(d5) * d6 - Math.sin(d4) * d6;
            position2.y = position.y + Math.cos(d5) * d6 - Math.cos(d4) * d6;
        }
        return this.keepInside(position2);
    }
}

