/*
 * Decompiled with CFR 0.152.
 */
package ags.muse.gun;

import ags.muse.base.Rules;
import ags.muse.base.StaticStorage;
import ags.muse.base.actors.GunActor;
import ags.muse.gun.BulletPowerSelector;
import ags.muse.gun.HitrateEstimator;
import ags.muse.gun.IStatTracker;
import ags.muse.gun.SWave;
import ags.muse.gun.SWaveManager;
import ags.muse.gun.crowd.MainCrowd;
import ags.muse.painting.GFPainter;
import ags.muse.recon.Enemy;
import ags.muse.recon.EnemyList;
import ags.muse.recon.SelfStatus;
import ags.util.points.AbsolutePoint;
import ags.util.points.RelativePoint;
import java.awt.Graphics2D;
import java.util.List;
import robocode.Bullet;
import robocode.Event;
import robocode.util.Utils;

public class MusingGun {
    private final Rules rules;
    private final SelfStatus status;
    private final EnemyList enemyList;
    private final SWaveManager waveManager;
    private SWave aimingWave;
    private double[] lastBins;
    private BulletPowerSelector bps = (BulletPowerSelector)StaticStorage.get("SelfBPS");
    private IStatTracker stats;
    Double bulletPower;
    double targetDist;

    public MusingGun(Rules rules, SelfStatus status, EnemyList enemyList, HitrateEstimator enemyEstimator) {
        if (this.bps == null) {
            this.bps = new BulletPowerSelector();
            StaticStorage.put("SelfBPS", this.bps);
        }
        this.stats = (IStatTracker)StaticStorage.get("GunStats");
        if (this.stats == null) {
            this.stats = new MainCrowd();
            StaticStorage.put("GunStats", this.stats);
        }
        this.bulletPower = null;
        this.rules = rules;
        this.status = status;
        this.enemyList = enemyList;
        this.waveManager = new SWaveManager(rules, status, enemyList);
        this.bps.setEnemyEstimator(enemyEstimator);
    }

    public void runTick(List<Event> events, GunActor actor) {
        Enemy target;
        if (this.aimingWave != null && this.aimingWave.target != null) {
            boolean aimed;
            double bwidth = Math.atan2(36.0, this.aimingWave.target.getLocation().distance(this.status.getLocation()));
            boolean bl = aimed = Math.abs(this.status.status.getGunTurnRemainingRadians()) < bwidth / 2.0;
            if (aimed) {
                Bullet bullet = actor.setFire(this.aimingWave.getPower());
                this.aimingWave.setBullet(bullet);
            }
        }
        if ((target = this.getTarget()) != null) {
            if (this.bulletPower == null || this.status.status.getGunHeat() / this.rules.GUN_COOLING_RATE <= 3.0) {
                this.bulletPower = this.calculateBulletpower(target);
            }
            this.waveManager.runWaves(events, this.bulletPower);
            this.handleWaveStates();
            this.aimingWave = this.waveManager.getAimingWave(target);
            if (this.aimingWave != null) {
                this.targetEnemy(target, actor);
            }
        } else {
            this.waveManager.runWaves(events, 0.0);
            this.handleWaveStates();
            this.aimingWave = null;
        }
    }

    private void handleWaveStates() {
        for (SWave w : this.waveManager.getNewWaves()) {
            this.stats.waveStarted(this.status, this.enemyList, w);
        }
        for (SWave w : this.waveManager.getDyingWaves()) {
            this.stats.waveEnded(w);
            if (w.getBullet() == null) continue;
            this.bps.waveEnd(w);
        }
        for (SWave w : this.waveManager.getHitWaves()) {
            this.stats.bulletHit(w);
        }
        for (SWave w : this.waveManager.getHitBulletWaves()) {
            this.stats.bulletHitBullet(w);
        }
    }

    private double calculateBulletpower(Enemy target) {
        int enemyCoolticks = (int)Math.max(target.ext.getCoolticks(), target.ext.getLastCoolticks());
        double enemyFirepower = target.ext.getLastEnemyPower();
        double bulletpower = this.bps.getBestPower(this.targetDist, this.status.status.getEnergy(), this.status.getDamageTaken(), target.getEnergy(), target.ext.getDamageTaken(), enemyFirepower, enemyCoolticks);
        bulletpower = Math.min(this.status.status.getEnergy() - 0.05, bulletpower);
        return bulletpower;
    }

    private void targetEnemy(Enemy target, GunActor actor) {
        double gf;
        if (this.status.status.getEnergy() == 0.0) {
            double angle = RelativePoint.fromPP((AbsolutePoint)this.status.getLocation(), (AbsolutePoint)target.getLocation()).direction;
            double gunHeading = this.status.status.getGunHeadingRadians();
            double turn = Utils.normalRelativeAngle((double)(angle - gunHeading));
            actor.setTurnGun(turn);
            return;
        }
        if (this.status.status.getGunHeat() / this.rules.GUN_COOLING_RATE > 3.0) {
            gf = 0.0;
        } else if (target.getEnergy() == 0.0) {
            this.lastBins = null;
            gf = 0.0;
        } else if (this.aimingWave == null) {
            System.out.println("Error: Target without aiming wave!");
            gf = 0.0;
        } else {
            double[] bins = this.stats.getBins(this.aimingWave);
            this.lastBins = bins;
            gf = MusingGun.getBestGF(bins, this.aimingWave);
        }
        if (this.waveManager.getCollideCount() != 0) {
            gf += (double)this.waveManager.getCollideCount() * Math.random() * 0.01;
        }
        double angle = this.aimingWave.getAngle(gf);
        double gunHeading = this.status.status.getGunHeadingRadians();
        double turn = Utils.normalRelativeAngle((double)(angle - gunHeading));
        actor.setTurnGun(turn);
    }

    private static double getBestGF(double[] bins, SWave wave) {
        int middleIndex = (bins.length - 1) / 2;
        int lowindex = 0;
        int highindex = bins.length - 1;
        int bestIndex = lowindex;
        int i = lowindex + 1;
        while (i <= highindex) {
            if (bins[i] > bins[bestIndex] || bins[i] == bins[bestIndex] && Math.abs(middleIndex - i) < Math.abs(middleIndex - bestIndex)) {
                bestIndex = i;
            }
            ++i;
        }
        return (double)(bestIndex - middleIndex) / (double)middleIndex;
    }

    private Enemy getTarget() {
        Enemy target = null;
        this.targetDist = Double.POSITIVE_INFINITY;
        for (Enemy e : this.enemyList.getBots()) {
            double d;
            if (e.getScanAge() > 0 || !((d = e.getLocation().distance(this.status.getNextLocation())) < this.targetDist)) continue;
            this.targetDist = d;
            target = e;
        }
        return target;
    }

    public void debugPaint(Graphics2D g, int x, int y) {
        GFPainter.paintTargetingProfile(g, x, y, this.lastBins);
    }
}

