package vuen.cfCake;
import vuen.Cake;
import robocode.*;
import java.awt.Color;
import java.io.*;

public class cJaiControl {
	private Cake oRobot = null;
	private cComControl oComControl = null;
	public cJaiThreat mJaiThreat = null;
	public cJaiScore mJaiScore = null;
	public static int mWinCount = 0;
	public int mSkippedTurns = 0;
	public static boolean mIsTeam = false;
	public static boolean mIsDuel = false;
	
	public cJaiControl(Cake pRobot, cComControl pComControl) {
		oRobot = pRobot;
		oComControl = pComControl;
		if (oRobot.getRoundNum() == 0) {
			if (oRobot.getOthers() == 1) mIsDuel = true;
			String[] pTeammates = oRobot.getTeammates();
			if (pTeammates == null) //oRobot.setColors(new Color(255,191,63), new Color(255,255,255), new Color(255,255,255));
				oRobot.setColors(new Color(132,58,20), new Color(255,255,255), new Color(255,255,255));
			else {
				oRobot.setColors(new Color(132,58,20), new Color(255,255,255), new Color(255,255,255));
				mIsTeam = true;
			}
		}
		if (mIsTeam)
			oRobot.out.println("[" + oRobot.getTime() + "] JAI: Initializing JAI Team Control");
		else
			oRobot.out.println("[" + oRobot.getTime() + "] JAI: Initializing JAI Solo Control");
		oRobot.setAdjustGunForRobotTurn(true);
		oRobot.setAdjustRadarForGunTurn(true);
		
		mJaiThreat = new cJaiThreat(oRobot, this, oComControl);
		mJaiScore = new cJaiScore(oRobot, this, oComControl);
	}
	
	public void doPrintStats() {
		oRobot.out.println("  JAI: Wins/Rounds: " + mWinCount + "/" + (int)(oRobot.getRoundNum() + 1) + "   Skipped Turns: " + mSkippedTurns);
	}
	
	public void doPrintEnemyStats(int i) {
		//oRobot.out.println("    JAI: Weight/Threat: " + Math.round((double)oComControl.mComEnemy.mEnemyWeight[i] * (double)1000) / (double)1000);
	}
	
	public void onSkippedTurn(SkippedTurnEvent e) {
		//oRobot.out.println("[" + oRobot.getTime() + "] JAI: Skipped Turn!");
		mSkippedTurns++;
	}
	
	public void doTurn() {
	}
	
	public void onBulletHit(BulletHitEvent e) {
		mJaiScore.onBulletHit(e);
	}
	
	public void onHitByBullet(HitByBulletEvent e) {
		mJaiScore.onHitByBullet(e);
	}
	
	public void onDeath(DeathEvent e) {
		oRobot.out.println("[" + oRobot.getTime() + "] JAI: I have died!");
		mJaiScore.onDeath(e);
	}
	
	public void onWin(WinEvent e) {
		oRobot.out.println("[" + oRobot.getTime() + "] JAI: I have won! Victory!");
		mWinCount++;
		mJaiScore.onWin(e);
	}
	
	public void onRobotDeath(RobotDeathEvent e) {
		mJaiScore.onRobotDeath(e);	
	}
	
	public void doVictoryDance() {
		oRobot.setMaxVelocity(8);
		oRobot.setMaxTurnRate(10);
		oRobot.setAdjustGunForRobotTurn(false);
		oRobot.setAdjustRadarForGunTurn(false);
		//oRobot.setTurnRadarLeft(oRobot.normalRelativeAngle(oRobot.getRadarHeading() - oRobot.getHeading()));
		oRobot.setTurnRadarRight(60000);
		oRobot.setTurnGunLeft(oRobot.normalRelativeAngle(oRobot.getGunHeading() - oRobot.getHeading() + 90));
		double pCenterX = oRobot.getBattleFieldWidth() / 2;
		double pCenterY = oRobot.getBattleFieldHeight() / 2;
		double pTheta = 0;
		double pDistance = 0;
		double pAngleFix = 0;
		pTheta = Math.toDegrees(Math.atan2(pCenterX - oRobot.getX(), pCenterY - oRobot.getY()));
		pDistance = Math.sqrt((pCenterX - oRobot.getX()) * (pCenterX - oRobot.getX()) + (pCenterY - oRobot.getY()) * (pCenterY - oRobot.getY()));
		pAngleFix = -(pDistance - 100);
		if (pAngleFix > 90) pAngleFix = 90; else if (pAngleFix < -90) pAngleFix = -90;
		oRobot.turnRight(oRobot.normalRelativeAngle(pTheta - oRobot.getHeading() + 90 + pAngleFix));
		while(true) {
			pTheta = Math.toDegrees(Math.atan2(pCenterX - oRobot.getX(), pCenterY - oRobot.getY()));
			pDistance = Math.sqrt((pCenterX - oRobot.getX()) * (pCenterX - oRobot.getX()) + (pCenterY - oRobot.getY()) * (pCenterY - oRobot.getY()));
			pAngleFix = -(pDistance - 100);
			if (pAngleFix > 90) pAngleFix = 90; else if (pAngleFix < -90) pAngleFix = -90;
			oRobot.setTurnRight(oRobot.normalRelativeAngle(pTheta - oRobot.getHeading() + 90 + pAngleFix));
			oRobot.setAhead(50);
			oRobot.execute();
		}
	}
}
