package davidalves.net.util;

import davidalves.PhoenixOS;

public class Wave {
	public RobotState targetAtFireTime;
	public double power, speed;
	public double bearingAtFireTime, orbitDirectionAtFireTime;
	public long timeFired;
	public RobotState shooterAtFireTime;
	public boolean solved;
	
	public Wave(RobotState shooterAtFireTime, RobotState targetAtFireTime, long timeFired, double power){
		this.shooterAtFireTime = shooterAtFireTime;
		this.targetAtFireTime = targetAtFireTime;
		this.timeFired = timeFired;
		this.power = power;
		this.speed = Utils.bulletSpeed(power);
		this.bearingAtFireTime = shooterAtFireTime.absoluteAngleTo(targetAtFireTime);
		this.orbitDirectionAtFireTime = targetAtFireTime.directionOrbitingAround(shooterAtFireTime);
	}
	
	public double distanceTraveled(long time){
		return speed * (time - timeFired);
	}
	
	public double timeToImpact(Point p, long now){
		double distanceTraveled =  speed * (now - timeFired);
		double distanceToTravel = shooterAtFireTime.distanceTo(p);
		return (distanceToTravel - distanceTraveled) / speed;
	}
	
	public boolean isSolvable(Point p, long now){
		double timeToImpact = timeToImpact(p, now);
		return (timeToImpact <= 1.0 && timeToImpact >= -1.0);
	}
	
	public double getSolutionAngle(Point p){
		return orbitDirectionAtFireTime * Utils.angularDifferenceBetween(bearingAtFireTime, shooterAtFireTime.absoluteAngleTo(p));
	}
	
	public double getSolutionGFDouble(Point p, int GF0){
		double solutionAngle = getSolutionAngle(p);
		double solutionFactor = solutionAngle / Utils.maxEscapeAngle(power);
		double solutionGF = GF0 + solutionFactor * GF0;
		return solutionGF;
	}
	
	public int getSolutionGF(Point p, int GF0){
		double solutionAngle = getSolutionAngle(p);
		double solutionFactor = solutionAngle / Utils.maxEscapeAngle(power);
		int solutionGF = GF0 + (int) Math.round(solutionFactor * GF0);
		return solutionGF;
	}
}
