package gadsky;

final class Prediction implements Comparable {
	public final double error;
	public final Vector2D shot;
	public final Vector2D position;

	public Prediction(double error, Vector2D shot, Vector2D position) {
		this.error = error;
		this.shot = shot;
		this.position = position;
	}

	public final int compareTo(Object o) {
		double leftError = error;
		double rightError = ((Prediction)o).error;

		if (leftError < rightError) return -1;
		else if (leftError > rightError) return 1;
		else if (hashCode() < o.hashCode()) return -1;
		else if (hashCode() > o.hashCode()) return 1;
		else return 0;
	}
}
