package suh.micro;

import java.awt.Color;
import robocode.*;
import robocode.util.Utils;

public class WallPM extends AdvancedRobot {
    public static final int MAX_SEARCH_PATTERN_LENGTH = 50;
    
    private static double energy;
    private static int dir = 1;
    private static String history = "" + 
	    (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 +
	    (char)1 + (char)2 + (char)3 + (char)4 + (char)5 + (char)6 + (char)7 + (char)8 +
	    (char)8 + (char)8 + (char)8 + (char)8 + (char)8 + (char)8 + (char)8 + (char)8 +
	    (char)8 + (char)7 + (char)6 + (char)5 + (char)4 + (char)3 + (char)2 + (char)1 +
	    (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 +
	    (char)-1 + (char)-2 + (char)-3 + (char)-4 + (char)-5 + (char)-6 + (char)-7 + (char)-8 +
	    (char)-8 + (char)-8 + (char)-8 + (char)-8 + (char)-8 + (char)-8 + (char)-8 + (char)-8 +
	    (char)-8 + (char)-7 + (char)-6 + (char)-5 + (char)-4 + (char)-3 + (char)-2 + (char)-1 +
	    (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0;
    
    @Override
    public void run() {
	double moveDistance = 0;
	
	//setColors(Color.BLACK, Color.BLACK, Color.BLACK);
	setAdjustGunForRobotTurn(true);
	setAdjustRadarForGunTurn(true);
	setAdjustRadarForRobotTurn(true);
	setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
	turnLeft(getHeading() % 90);
	while(true) {
	    if(Utils.isNear(getHeading(), 0.0)) {
		moveDistance = (dir == 1) ? getBattleFieldHeight()-getY() : getY();
	    }
	    else if(Utils.isNear(getHeading(), 90.0)) {
		moveDistance = (dir == 1) ? getWidth()-getX() : getX();
	    }
	    else if(Utils.isNear(getHeading(), 180.0)) {
		moveDistance = (dir == 1) ? getY() : getBattleFieldHeight()-getY();
	    }
	    else {
		moveDistance = (dir == 1) ? getX() : getBattleFieldWidth()-getX();
	    }
	    moveDistance -= 50;
	    ahead(dir * moveDistance);
	    turnRight(dir * 90);
	}
    }
    
    @Override
    @SuppressWarnings("empty-statement")
    public void onScannedRobot(ScannedRobotEvent e) {
	double angle;
	
	// Radar
	setTurnRadarRightRadians(2.0 * Utils.normalRelativeAngle((angle = getHeadingRadians() + e.getBearingRadians()) - getRadarHeadingRadians()));
	
	// Movement
	if(energy > (energy = e.getEnergy()) && Math.random() < 0.5) {
	    dir = -dir;
	    double moveDistance;
	    if(Utils.isNear(getHeading(), 0.0)) {
		moveDistance = (dir == 1) ? getBattleFieldHeight()-getY() : getY();
	    }
	    else if(Utils.isNear(getHeading(), 90.0)) {
		moveDistance = (dir == 1) ? getBattleFieldWidth()-getX() : getX();
	    }
	    else if(Utils.isNear(getHeading(), 180.0)) {
		moveDistance = (dir == 1) ? getY() : getBattleFieldHeight()-getY();
	    }
	    else {
		moveDistance = (dir == 1) ? getX() : getBattleFieldWidth()-getX();
	    }
	    moveDistance -= 50;
	    setAhead(dir * moveDistance);
	}
	
	// Targeting
	double power = Math.min(15.0 * getEnergy() / e.getDistance(), e.getEnergy() / 4.0);
	double velocity = Rules.getBulletSpeed(power);
	int i = MAX_SEARCH_PATTERN_LENGTH;
	int matchIndex;
	
	history = String.valueOf((char)Math.round(e.getVelocity() * Math.sin(e.getHeadingRadians() - angle))).concat(history);
	
	while((matchIndex = history.indexOf(history.substring(0, i--), (int)(e.getDistance() / velocity + 1.0))) < 0);
	i = (int)(e.getDistance() / velocity + 1.0);
	do { angle += Math.asin(((short)history.charAt(--matchIndex)) / e.getDistance()); } while (--i > 0);
	
	setTurnGunRightRadians(Utils.normalRelativeAngle(angle - getGunHeadingRadians()));
	setFire(power);
    }
}

