package shinh;

import robocode.*;

import java.awt.geom.Point2D;

public class PredictLinear {
	public String name() {
		return "linear";
	}

	public void doMove(Being obj) {
		obj.x += Math.sin(obj.heading) * obj.velocity;
		obj.y += Math.cos(obj.heading) * obj.velocity;
	}

	public Point2D.Double getFuturePnt(Being obj, double pow) {
		Entangled ent = Entangled.me;

		double tx = obj.x;
		double ty = obj.y;
		double tvx = obj.velocity * Math.sin(obj.heading);
		double tvy = obj.velocity * Math.cos(obj.heading);
		double x = ent.getX();
		double y = ent.getY();
		double v = 20 - 3 * pow;
		double dx = tx - x;
		double dy = ty - y;

		double a = obj.velocity*obj.velocity - v*v;
		double b = tvx * dx + tvy * dy;
		double c = dx*dx + dy*dy;
		double hitTurn = (-b - Math.sqrt(b*b - a*c)) / a;

		Point2D.Double huture = new Point2D.Double();
		huture.x = obj.x + tvx * hitTurn;
		huture.y = obj.y + tvy * hitTurn;

		return huture;
	}

}
