package ags.rougedc.gun;

import java.util.Map;
import java.util.HashMap;

import ags.rougedc.gun.util.MovementProfile;
import ags.rougedc.gun.util.Predictor;
import ags.rougedc.robots.EnemyRobot;
import ags.rougedc.waves.SelfWave;
import ags.utils.Range;
import ags.utils.points.*;

public class CrowdPredictor2TMP implements Predictor {
    private final Predictor[] predictors;
    private final Map<SelfWave, MovementProfile[]> waves = new HashMap<SelfWave, MovementProfile[]>();
    private final MovementProfile[] profiles;
    private static double[] weights;
    
    public CrowdPredictor2TMP(Predictor... predictors) {
        this.predictors = predictors;
        this.profiles = new MovementProfile[predictors.length];
        if (weights == null || weights.length != predictors.length) {
            weights = new double[predictors.length];
            for (int i=0; i<predictors.length; i++) {
                weights[i] = 0.5;
            }
        }
    }
    
    public MovementProfile getPredictedProfile() {
        boolean anyProfiles = false;
        final MovementProfile profile = new MovementProfile();
        for (int i=0; i<predictors.length; i++) {
            profiles[i] = predictors[i].getPredictedProfile();
            if (profiles[i] != null) {
                profiles[i].normalize();
                //profile.add(profiles[i], Math.max(weights[i]-0.10 , 0.001)); // TC22
                profile.add(profiles[i], weights[i]);   // TC20
                anyProfiles = true;
            }
        }
        if (anyProfiles == false)
            return null;
        profile.normalize();
        return profile;
    }
    
    public void remember(EnemyRobot target) {
        for (Predictor predictor : predictors) {
            predictor.remember(target);
        }
    }

    public void run(AbsolutePoint nextLocation, EnemyRobot target, double bulletpower) {
        for (Predictor predictor : predictors) {
            predictor.run(nextLocation, target, bulletpower);
        }
    }

    public void waveFired(SelfWave wave) {
        for (Predictor predictor : predictors) {
            predictor.waveFired(wave);
        }
        
        final MovementProfile[] waveProfiles = new MovementProfile[profiles.length];
        System.arraycopy(profiles, 0, waveProfiles, 0, profiles.length);
        waves.put(wave, waveProfiles);
    }

    public void waveHit(SelfWave wave) {
        for (Predictor predictor : predictors) {
            predictor.waveHit(wave);
        }
        
        if (!waves.containsKey(wave))
            return; // Shouldn't happen, but just in case
        
        final Range range = wave.getHitRange();
        final MovementProfile[] waveProfiles = waves.get(wave);
        
        for (int i=0; i<predictors.length; i++) {
            if (waveProfiles[i] != null) {
                waveProfiles[i].normalize();
                double bonus = waveProfiles[i].getPeakInRange(range);
                /*double bonus = 0;
                if (range.intersects(waveProfiles[i].getBestGF()))
                    bonus = 1;*/
                weights[i] = weights[i]*0.95 + bonus*0.05;
            }
        }
        
        System.out.print("Crowd weights: ");
        for (int i=0; i<predictors.length; i++) {
            System.out.print(predictors[i].getClass().getSimpleName()+":"+weights[i]+"  ");
        }
        System.out.println();
        
        waves.remove(wave);
    }
}
