/*
 * Created on May 28, 2003
 *
 * My first robot entered into the Eternal Rumble.  Not necessarily a
 * competitive bot.
 * 
 * v 0.4
 * Fixed some major problems in the a/g movement system, including
 * the DodgingPoints.  I think that this can be a competitive melee
 * robot.
 * 
 * v 0.3
 * Ok, so i didn't finish the radar changes for 0.2.  It's there now.
 * Changing movement to what might be called "guess factor a/g
 * bullet dodging".  Eliminate the random a/g points.  When fired upon,
 * place an a/g point at a random distance on a line through my bot
 * perpendicular to the line between my bot and the enemy.  Maintain
 * this a/g point until the bullet has passed.  There may be some issues
 * with walls and corners doing this, but I had that with 0.2.
 * 
 * This version moved up to 175/1282.57, 92/1502.56.
 *
 * v 0.2
 * Running against StatistRobot shows that Terrible doesn't appear to
 * move much when in the 251-490 range.  Attempting to add random a/g
 * points when distance > 250.
 * Also changing radar to not do full sweeps unless it loses the enemy
 * when 1 v 1.
 * 
 * This version was my first in the Eternal Rumble.  Terrible came away
 * @183(185?)/1229.47 for 1 v 1 (rank, rating) and @93(92?)/1502.21 for melee.
 * v 0.3's movement should be an improvement, and wait until I start
 * adding some useful targeting.
 * 
 * v 0.1
 * Movement is a basic, crude anti-grav
 * Radar focuses on closest enemy, but gives a full sweep every 16 turns
 * Aiming is head-on targeting
 * Firepower is 3 (energy > 20), 2 (energy > 10) or 1
 */

package jep;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.HashSet;
//import java.util.Hashtable;
import java.util.Iterator;

import jep.intelligence.Enemy;
import jep.intelligence.EnemyMap;
import jep.movement.DodgingGravityPoint;
import jep.movement.GoTo;
import jep.movement.GravityPoint;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.CustomEvent;
//import robocode.DeathEvent;
import robocode.RadarTurnCompleteCondition;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
//import robocode.robocodeGL.LabelGL;
//import robocode.robocodeGL.LineGL;
//import robocode.robocodeGL.PointGL;
//import robocode.robocodeGL.system.GLRenderer;

/**
 *
 * @author johnp
 * 
 */

public class Terrible extends AdvancedRobot {
	private EnemyMap myEnemyMap = new EnemyMap();
	private long lastFullScan;
	private static HashSet wallAntiGravPoints = new HashSet(50);
	private HashSet robotAntiGravPoints = new HashSet(50);
	private HashSet dodgingAntiGravPoints = new HashSet(10);
	private double battleFieldWidth;
	private double battleFieldHeight;
	private boolean oneOnOne;
	private int scannedRobots;
	private String currEnemyName;
	private double wallAntiGravMass = 100.0;
	private double robotAntiGravMass = 500.0;
	private double dodgingAntiGravMass = 1000.0;
	private boolean firedThisTurn = false;
	private double gravityPower = 3.0;
	//	// GL code
	//	private Hashtable RenderElements = new Hashtable();
	//	private GLRenderer renderer;
	//	// End GL code

	public void run() {
		//		// GL code
		//		renderer = GLRenderer.getInstance();
		//		// End GL code
		// Setup
		setColors(Color.black, Color.green, Color.white);
		battleFieldWidth = getBattleFieldWidth();
		battleFieldHeight = getBattleFieldHeight();
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setTurnRadarRight(360);
		scannedRobots = 0;
		lastFullScan = -100;
		// so we don't accidentally interrupt first full scan
		addCustomEvent(new RadarTurnCompleteCondition(this));
		// build A/G for walls
		GravityPoint.setGravityMultiplier(50000.0);
		buildWallAntiGravPoints();
		Utils.initVars(this);
		while (true) {
			firedThisTurn = false;
			Utils.updateVars(this);
			// eventVector = getAllEvents();
			// out("Event vector size is " + eventVector.size());
			oneOnOne = true;
			if (getOthers() > 1) {
				oneOnOne = false;
			}

			// fire gun if ready
			fireGun();

			// do radar
			doRadar();

			// do movement
			moveRobot();

			// aim gun
			aimGun();

			// now make it all go
			execute();
		}
	}

	public void fireGun() {
		double bulletPower;
		double myEnergy;
		if (getGunHeat() == 0.0
			&& getOthers() > 0
			&& getGunTurnRemaining() == 0.0) {
			bulletPower = 3.0;
			if ((myEnergy = getEnergy()) < 0.5) {
				return;
			}
			if (myEnergy < 1.5) {
				bulletPower = 0.1;
			}
			if (myEnergy < 10.0) {
				bulletPower = 1.0;
			}
			if (myEnergy < 20.0) {
				bulletPower = 2.0;
				;
			}
			setFire(bulletPower);
			firedThisTurn = true;
		}
	}

	public void aimGun() {
		Enemy myEnemy;

		if (myEnemyMap.size() > 0
			&& (firedThisTurn || getGunTurnRemaining() == 0.0)) {
			myEnemy = myEnemyMap.closestEnemy();
			currEnemyName = myEnemy.getName();
			setTurnGunRightRadians(
				Utils.normalRelativeAngleRadians(
					myEnemy.getBearingRadians()
						+ getHeadingRadians()
						- getGunHeadingRadians()));
		}
	}

	public void doRadar() {
		long currTime = getTime();
		if ((currTime >= lastFullScan + 16) && !oneOnOne) {
			setTurnRadarRight(360);
			lastFullScan = currTime;
		}
	}

	public void moveRobot() {
		Enemy closestEnemy = myEnemyMap.closestEnemy();

		if (closestEnemy != null && closestEnemy.getEnergy() == 0.0) {
			return;
		}

		buildRobotAntiGravPoints();

		// age all dodging a/g points
		Iterator dodgingIterator = dodgingAntiGravPoints.iterator();
		while (dodgingIterator.hasNext()) {
			DodgingGravityPoint thisGravPoint =
				(DodgingGravityPoint) dodgingIterator.next();
			if (thisGravPoint.getDuration() == 0) {
				dodgingIterator.remove();
				//				// GL code
				//				PointGL p = (PointGL) RenderElements.get(thisGravPoint);
				//				if (p != null) {
				//					p.remove();
				//				}
				//				RenderElements.remove(thisGravPoint);
				//				// End GL code
			} else {
				thisGravPoint.setDuration(thisGravPoint.getDuration() - 1);
			}
		}

		Point2D.Double wallGravity = calcGravity(wallAntiGravPoints);
		Point2D.Double botGravity = calcGravity(robotAntiGravPoints);
		Point2D.Double dodgingGravity = calcGravity(dodgingAntiGravPoints);
		Point2D.Double netGravity =
			Utils.pointAdd(
				dodgingGravity,
				Utils.pointAdd(wallGravity, botGravity));

		//		// GL code
		//		LineGL p = new LineGL();
		//		p.addLabel(new LabelGL("G"));
		//		p.setLine(Utils.x, Utils.y, Utils.x + netGravity.x, Utils.y + netGravity.y);
		//		p.setColor(Color.cyan);
		//		p.setWidth(3.0f);
		//		RenderElements.put(netGravity, p);
		//		renderer.addRenderElement(p);
		//		// End GL code
		GoTo.setMyLocation(Utils.x, Utils.y);
		GoTo.goTo(this, Utils.x + netGravity.x, Utils.y + netGravity.y);
	}

	public void buildWallAntiGravPoints() {
		if (wallAntiGravPoints.size() > 0) {
			return;
		}

		double spread = 40.0;
		GravityPoint newGravPoint;

		for (double x = 0; x <= battleFieldWidth; x += spread) {
			newGravPoint = new GravityPoint(wallAntiGravMass, x, 0);
			wallAntiGravPoints.add(newGravPoint);
			newGravPoint =
				new GravityPoint(wallAntiGravMass, x, battleFieldHeight);
			wallAntiGravPoints.add(newGravPoint);
		}
		for (double y = spread; y < battleFieldHeight; y += spread) {
			newGravPoint = new GravityPoint(wallAntiGravMass, 0, y);
			wallAntiGravPoints.add(newGravPoint);
			newGravPoint =
				new GravityPoint(wallAntiGravMass, battleFieldWidth, y);
			wallAntiGravPoints.add(newGravPoint);
		}
		if (getOthers() > 1) {
			newGravPoint =
				new GravityPoint(
					wallAntiGravMass * 25.0,
					battleFieldWidth / 2,
					battleFieldHeight / 2);
			wallAntiGravPoints.add(newGravPoint);
		} else {
			newGravPoint =
				new GravityPoint(
					wallAntiGravMass * 5.0,
					battleFieldWidth / 2,
					battleFieldHeight / 2);
			wallAntiGravPoints.add(newGravPoint);
		}
	}

	public void onRobotDeath(RobotDeathEvent e) {
		String deadRobotName;

		deadRobotName = e.getName();
		if (myEnemyMap.containsKey(deadRobotName)) {
			myEnemyMap.remove(deadRobotName);
		}
	}

	public void onCustomEvent(CustomEvent e) {
		if (e.getCondition() instanceof RadarTurnCompleteCondition
			&& myEnemyMap.size() > 0) {
			if (scannedRobots == 0) {
				setTurnRadarRight(22.5);
				return;
			}
			Enemy myEnemy = myEnemyMap.closestEnemy();
			double enemyBearing = myEnemy.getBearing();
			double turn =
				Utils.normalRelativeAngle(
					getHeading() + enemyBearing - getRadarHeading());
			turn += 22.5;
			if (turn < 22.5) {
				turn -= 45.0;
			}
			setTurnRadarRight(turn);
			scannedRobots = 0;
		}
	}

	public void buildRobotAntiGravPoints() {
		double enemyMass;
		//		// GL code
		//		Iterator rAGPIterator = robotAntiGravPoints.iterator();
		//		while (rAGPIterator.hasNext()) {
		//			GravityPoint rgp = (GravityPoint) rAGPIterator.next();
		//			PointGL p = (PointGL) RenderElements.get(rgp);
		//			if (p != null) {
		//				p.remove();
		//			}
		//			RenderElements.remove(rgp);
		//		}
		//		// End GL code
		robotAntiGravPoints.clear();
		Iterator enemyIterator = (myEnemyMap.values()).iterator();
		while (enemyIterator.hasNext()) {
			Enemy currEnemy = (Enemy) enemyIterator.next();
			GravityPoint newGravPoint =
				new GravityPoint(
					robotAntiGravMass,
					currEnemy.getX(),
					currEnemy.getY());
			robotAntiGravPoints.add(newGravPoint);
			//			// GL code
			//			PointGL p = new PointGL();
			//			p.setPosition(newGravPoint.getX(), newGravPoint.getY());
			//			p.setSize(3.0f);
			//			p.setColor(Color.RED);
			//			p.addLabel(new LabelGL("A/G " + currEnemy.getName()));
			//			RenderElements.put(newGravPoint, p);
			//			renderer.addRenderElement(p);
			//			// End GL code
		}

	}

	public Point2D.Double calcGravity(HashSet gravSet) {
		Iterator gravityIterator = gravSet.iterator();
		GravityPoint thisGravPoint;
		Point2D.Double forceVector = new Point2D.Double(0, 0);
		double xForces = 0.0;
		double yForces = 0.0;
		double myX = getX();
		double myY = getY();

		while (gravityIterator.hasNext()) {
			thisGravPoint = (GravityPoint) gravityIterator.next();
			double distance =
				Point2D.distance(
					myX,
					myY,
					thisGravPoint.getX(),
					thisGravPoint.getY());
			double angle =
				Math.atan2(
					myY - thisGravPoint.getY(),
					myX - thisGravPoint.getX());
			double force =
				thisGravPoint.getMass() / Math.pow(distance, gravityPower);
			xForces += force * Math.cos(angle);
			yForces += force * Math.sin(angle);
		}
		forceVector.setLocation(xForces, yForces);

		return forceVector;
	}

	//	public int botCorner(double tolerance) {
	//		double x = getX(), y = getY();
	//		if (x < tolerance) {
	//			if (y < tolerance) {
	//				return 1;
	//			}
	//			if (battleFieldHeight - y < tolerance) {
	//				return 4;
	//			}
	//		}
	//		if (battleFieldHeight - x < tolerance) {
	//			if (y < tolerance) {
	//				return 2;
	//			}
	//			if (battleFieldHeight - y < tolerance) {
	//				return 3;
	//			}
	//		}
	//		return 0;
	//	}

	public void onScannedRobot(ScannedRobotEvent e) {
		Enemy scannedEnemy;
		double energyDifference;
		String enemyName = e.getName();
		if (myEnemyMap.containsKey(enemyName)) {
			scannedEnemy = (Enemy) myEnemyMap.get(enemyName);
			energyDifference = scannedEnemy.getEnergy() - e.getEnergy();
			scannedEnemy.updateEnemy(e);
		} else {
			scannedEnemy = new Enemy(e);
			energyDifference = 0.0;
			myEnemyMap.put(enemyName, scannedEnemy);
		}
		scannedRobots++;
		if (/* oneOnOne && */
			energyDifference > 0.0 && energyDifference <= 3.0) {
			double bulletVelocity = 20.0 - 3.0 * energyDifference;
			double escapeBearing =
				Utils.absoluteBearing(
					Utils.myLocation,
					new Point2D.Double(
						scannedEnemy.getX(),
						scannedEnemy.getY()));
			if (Math.random() < 0.5) {
				escapeBearing += 90.0;
			} else {
				escapeBearing -= 90.0;
			}
			// add 0.5 here so that this becomes trunc of duration + 1
			long duration =
				Math.round(
					scannedEnemy.getDistance()
						* Math.sqrt(
							1.0 / (bulletVelocity * bulletVelocity - 64.0))
						+ 0.5);
			double escapeDistance =
				0.5 * Math.random() * 8.0 * duration + getWidth();
			double escapeMass = dodgingAntiGravMass;
			double distance = e.getDistance();
			if (distance < 490.0) {
				escapeMass *= 2.0;
			}
			if (distance < 250.0) {
				escapeMass *= 2.0;
			}
			if (distance < 100.0) {
				escapeMass *= 2.0;
			}
			Point2D.Double gravPointLoc =
				new Point2D.Double(
					Utils.x
						+ Math.sin(Math.toRadians(escapeBearing))
							* escapeDistance,
					Utils.y
						+ Math.cos(Math.toRadians(escapeBearing))
							* escapeDistance);
			DodgingGravityPoint dgp =
				new DodgingGravityPoint(
					scannedEnemy.getName(),
					duration,
					escapeMass,
					gravPointLoc.getX(),
					gravPointLoc.getY());
			dodgingAntiGravPoints.add(dgp);
			//			// GL code
			//			PointGL p = new PointGL();
			//			p.setPosition(dgp.getX(), dgp.getY());
			//			p.setSize(3.0f);
			//			p.setColor(Color.RED);
			//			p.addLabel(new LabelGL("Dodging " + scannedEnemy.getName()));
			//			RenderElements.put(dgp, p);
			//			renderer.addRenderElement(p);
			//			// End GL code
		}
	}

	public void onBulletHit(BulletHitEvent e) {
		// Try to adjust so that we can still detect if enemy fires on a
		// turn on which he is hit
		Enemy myEnemy = (Enemy) myEnemyMap.get(e.getName());
		if (myEnemy != null) {
			myEnemy.setEnergy(e.getEnergy());
		}
	}

	//	public void onDeath(DeathEvent e) {
	//		// GL code
	//		Iterator rendererElementIterator = (RenderElements.values()).iterator();
	//		while (rendererElementIterator.hasNext()) {
	//			Object o = rendererElementIterator.next();
	//			if (o instanceof PointGL) {
	//				PointGL p = (PointGL) o;
	//				p.remove();
	//			} else {
	//				LineGL l = (LineGL) o;
	//				l.remove();
	//			}
	//			rendererElementIterator.remove();
	//		}
	//		// End GL code
	//	}
}
