/*
 * Created on Jun 6, 2003
 *
 */
package jep.movement;

/**
 * @author johnp
 *
 * Used to support anti-gravity movement.
 * gravityMultiplier is included to scale results so that the
 * numbers that "gravity" produces will be usable.
 */
public class GravityPoint {
	private double mass;
	private double x;
	private double y;
	private static double gravityMultiplier = 1;
	
	public GravityPoint(double m, double xpos, double ypos) {
		mass = m*gravityMultiplier;
		x = xpos;
		y = ypos;
	}
	/**
	 * @return double
	 */
	public double getMass() {
		return mass;
	}

	/**
	 * @return double
	 */
	public double getX() {
		return x;
	}

	/**
	 * @return double
	 */
	public double getY() {
		return y;
	}

	/**
	 * Sets the mass.
	 * @param mass The mass to set
	 */
	public void setMass(double mass) {
		this.mass = mass;
	}

	/**
	 * Sets the x.
	 * @param x The x to set
	 */
	public void setX(double x) {
		this.x = x;
	}

	/**
	 * Sets the y.
	 * @param y The y to set
	 */
	public void setY(double y) {
		this.y = y;
	}

	/**
	 * @return double
	 */
	public static double getGravityMultiplier() {
		return gravityMultiplier;
	}

	/**
	 * Sets the gravityMultiplier.
	 * @param gravityMultiplier The gravityMultiplier to set
	 */
	public static void setGravityMultiplier(double gravityMultiplier) {
		GravityPoint.gravityMultiplier = gravityMultiplier;
	}
	
	public String toString() {
		return "Mass = " + mass + ", x = " + x + ", y = " + y;
	}

}
