//@ts-check
(
	/**
	 * @param { inonit.robocode.javascript.Host } $host 
	 * @param { inonit.robocode.javascript.Context } $context 
	 */
	function($host,$context) {
		//var $rhino = $host.getRhinoLoader();
		$context._peer.out.println("Entered script.");

		var print = function(message) {
			$context._peer.out.println(message);
		};

		//	TODO	find way to disable this by default and configure it
		var debug = function(message) {
			if (false) $context._peer.out.println(message);
		}

		print("$host: " + $host);
		print("$host.getEngine: " + $host.getEngine());
		print("$host.getLoader: " + $host.getLoader());
		print("$host.getSource: " + $host.getSource());

		var $rhino = $host.getEngine().script(
			"jrunscript/rhino.js", 
			$host.getLoader().getLoaderCode("jrunscript/rhino.js"), 
			{ $loader: $host.getLoader(), $rhino: $host.getEngine() }, 
			null
		);

		var $api = $rhino.$api;
		var $loader = new $rhino.Loader({
			_source: $host.getSource()
		});
		debug("$rhino.Loader = " + $rhino.Loader);
		debug("$loader = " + $loader);
		debug("$loader keys = " + Object.keys($loader));

		//	TODO	document and tighten
		var scope = {};

		var api = $loader.value("api.js").reduce(function(rv,item) {
			print("map " + item.name + " " + item.as);
			rv[item.name] = item;
			return rv;
		},{});

		for (x in $context._peer) {
			(function(x) {
				/**
				 * @param { string } x 
				 */
				var defineProperty = function(x) {
					Object.defineProperty($context.robot, x, {
						get: function() {
							return $context._peer[x]
						},
						set: function(v) {
							$context._peer[x] = v;
						}
					});
				};

				/**
				 * @param { string } x 
				 */
				var defineMethod = function(x) {
					Object.defineProperty($context.robot, x, {
						value: function() {
							return $context._peer[x].apply($context._peer, arguments);
						}
					});
				};

				var assignToHost = function(x) {
					//	We make no alterations to the underlying JavaScript object and allow this named property to be assigned.

					//	A previous attempt at improvement is below, but led to problems with Rhino context assignment.

					// var value;

					// Object.defineProperty($context.robot, x, {
					// 	get: function() {
					// 		return value;
					// 	},
					// 	set: function(v) {
					// 		value = v;
					// 	}
					// })
				}

				var as = api[x].as;
				if (as == "event" || as == "awtEvent" || as == "awtDebug") {
					assignToHost(x);
				} else if (as == "implement") {
					assignToHost(x);
				} else if (as == "is") {
					defineProperty(x);
				} else if (as == "getter" || as == "query") {
					defineMethod(x);
				} else if (as == "property") {
					defineProperty(x);
				} else if (as == "command" || as == "set") {
					defineMethod(x);
				} else if (as == "omit" || as == "java") {
					//	do nothing
				} else {
					throw new Error("Nothing for " + x + "; as = " + x + " in " + JSON.stringify(api[x]));
				}	
			})(x);
		}

		//	TODO	think through how to give access to loader
		scope.$loader = $loader;
		scope.$loader.java = new function() {
			this.getClass = function(name) {
				var liveconnect = Packages[name];
				if (/^\[JavaClass/.test(String(liveconnect))) return liveconnect;
				return null;
				//	TODO	below would work better but we have disabled the classpath because class loading is disabled, so would need to
				//			refactor
				// return $rhino.classpath.getClass(name);
			}
		}

		var name = String($context._peer.getClass().getName()) + ".js";
		$loader.run(name, scope, $context.robot);
	}
//@ts-ignore
)($host, $context)
