package hamilton;

import robocode.*;

public class EnemyBullet extends VirtualBullet implements Charge
{
	double firepower;
	double radius;
	double originalBearing;
	
	public EnemyBullet(AdvancedRobot someR, Target someT, String someAlgorithm, double someTime, double someHeading, double someFirepower, Coordinate someOrigin)
	{
		super(someR, someT, someAlgorithm, someTime, someHeading, someFirepower, someOrigin);
		
		firepower = someFirepower;
		
		originalBearing = origin.absoluteBearingTo(new Coordinate(r.getX(), r.getY()));
		
		r.addCustomEvent(this);
	}

	public boolean test()
	{
		double elapsedTime = r.getTime() - firingTime;
	
		radius = velocity * elapsedTime;
		
		double hamiltonDistanceFromTarget = origin.distanceFrom(new Coordinate(r.getX(), r.getY()));
		
		double difference = Math.abs(radius - hamiltonDistanceFromTarget);
		
		if ( difference <= r.getWidth() )
		{
			double correctBearing = origin.absoluteBearingTo(new Coordinate(r.getX(), r.getY()));
			
			double delta = correctBearing - originalBearing;
			
			// System.out.println(r.getRoundNum() + ", " + r.getTime() + ", " + delta + ", " + elapsedTime);
			
			r.removeCustomEvent(this);
		}
		
		else if (radius >= (hamiltonDistanceFromTarget + r.getWidth()))
		{
			r.removeCustomEvent(this);
		}
					
		return false;
	}


	public ForceVector getForceOn(Coordinate someCoordinates)
	{
		double currentTime = r.getTime();
		
		Coordinate position = origin.getCoordinates(heading, ((currentTime - firingTime) * velocity) );
		double distance = position.distanceFrom(someCoordinates);

		double charge = 500 * firepower;
		double exponent = 2;
		
		double force = charge / Math.pow(distance, exponent);
		double theta = origin.absoluteBearingTo(someCoordinates);
		
		return new ForceVector( (Math.sin(theta) * force) , (Math.cos(theta) * force) );
	}

}
