/**
 * Copyright (c) 2009 Nat Pavasant; All right reserved.
 * Source code is released under the term of Nat Public Robot License 2.1
 */
package nat.utils;

import java.awt.geom.Point2D;

public class Point extends Point2D implements java.io.Serializable, Cloneable {
	private static final long serialVersionUID = 7439030037908914610L;
	public double x, y;
	
	public Point(double x, double y) {
		this.x = x;
		this.y = y;
	}
	
	public Point(Point2D pt) {
		this(pt.getX(), pt.getY());
	}
	
	public void project(Vector vector) {
		this.x += vector.x;
		this.y += vector.y;
	}

	public double getX() {
		return x;
	}

	public double getY() {
		return y;
	}

	public void setLocation(double x, double y) {
		this.x = x;
		this.y = y;
	}
	
	public double angle(Point point) {
		return M.atan2(point.getX() - x, point.getY() - y);
	}
	
	public double angle(double x, double y) {
		return M.atan2(x - this.x, y - this.y);
	}
	
	public Point clone() {
		return new Point(x,y);
	}
	
	public String toString() {
		return "[" + x + "," + y + "]";
	}
}
