package ph.intelligence;
import ph.*;
import robocode.*;
import java.util.*;
import java.awt.geom.*;

public class robotInfo {
    
    protected String name;
    protected double x;
    protected double y;
    
    protected double prevX;
    protected double prevY;
    
    protected double time;
    protected double distance;
    protected double heading;
    protected double velocity;
    protected double acceleration;
    protected long accelerationTimer;
    protected double energy;
    protected double energyDrop=0;
    
    protected double calculatedHeading;
    protected double calculatedDistance;
    protected double calculatedHeadingChange;
    
    protected double prevHeading;
    protected double headingChange;
    protected double avHeadingChange=Double.POSITIVE_INFINITY;
    protected double timeAvHeadingChange=Double.POSITIVE_INFINITY;
    
    protected double timeAvDistance=Double.POSITIVE_INFINITY;
    
    protected double avVelocity;
    
    protected boolean staticBot=false;
    
    protected Vector movementHistory=new Vector();
    protected static long movementHistorySize=1000;
    
    protected boolean approx=false;
    public boolean focusOn=false;
    
    public Vector movementHistory(){return movementHistory;}
    public double calculatedHeading(){return calculatedHeading;}
    public double calculatedDistance(){return calculatedDistance;}
    public double calculatedHeadingChange(){return calculatedHeadingChange;}
    
    public robotInfo(robotInfo ri) {
        name=ri.name;
        x=ri.x;
        y=ri.y;
        prevX=ri.prevX;
        prevY=ri.prevY;
        calculatedHeading=ri.calculatedHeading;
        calculatedDistance=ri.calculatedDistance;
        calculatedHeadingChange=ri.calculatedHeadingChange;
        time=ri.time;
        distance=ri.distance;
        heading=ri.heading;
        velocity=ri.velocity;
        acceleration=ri.acceleration;
        energy=ri.energy;
        prevHeading=ri.prevHeading;
        avHeadingChange=ri.avHeadingChange;
        timeAvDistance=ri.timeAvDistance;
        avVelocity=ri.avVelocity;
        staticBot=ri.staticBot;
        movementHistory=ri.movementHistory;
        movementHistorySize=ri.movementHistorySize;
        robot=ri.robot;
    }
    
    public robotInfo(String name, double x, double y, double time, double distance, double heading, double velocity, double acceleration, double energy, double calculatedHeading, double calculatedDistance, double calculatedHeadingChange) {
        this.name=name;
        this.x=x;
        this.y=y;
        prevX=x;
        prevY=y;
        this.time=time;
        this.distance=distance;
        this.heading=heading;
        this.velocity=velocity;
        this.acceleration=acceleration;
        this.energy=energy;
        prevHeading=heading;
        timeAvDistance=distance;
        avVelocity=velocity;
        this.calculatedHeading=calculatedHeading;
        this.calculatedDistance=calculatedDistance;
        this.calculatedHeadingChange=calculatedHeadingChange;
        approx=true;
        //updateHistory(this);
    }
    
    /** Creates a new instance of robotInfo */
    public robotInfo(String name, double x, double y, double time, double distance, double heading, double velocity, double energy) {
        this.name=name;
        this.x=x;
        this.y=y;
        prevX=x;
        prevY=y;
        this.time=time;
        this.distance=distance;
        this.heading=heading;
        this.velocity=velocity;
        this.energy=energy;
        prevHeading=heading;
        timeAvDistance=distance;
        avVelocity=velocity;
        updateHistory(this);
    }
    
    public robotInfo(ScannedRobotEvent evt, double x, double y) {
        new robotInfo(evt.getName(),x,y,evt.getTime(),evt.getDistance(),evt.getHeading(),evt.getVelocity(),evt.getEnergy());
    }
    
    public void setRobot(ModularRobot robot) {
        this.robot=robot;
    }
    
    private ModularRobot robot=null;
    
    public void update(String name, double x, double y, double time, double distance, double heading, double velocity, double energy) {
        this.name=name;
        double newCalculatedHeading=utils.normalAngle(utils.getBearing(this.x,this.y,x,y));
        calculatedHeadingChange=newCalculatedHeading-calculatedHeading;
        calculatedHeading=newCalculatedHeading;
        calculatedDistance=utils.dist(this.x,this.y,x,y);
        this.x=x;
        this.y=y;
        //calculatedHeading=utils.normalAngle(utils.getBearing(prevX,prevY,x,y));
        //calculatedDistance=utils.dist(prevX,prevY,x,y);
        prevX=x;
        prevY=y;
        this.distance=distance;
        headingChange=utils.normalRelativeAngle(heading-this.heading)/(time-this.time);
        this.heading=heading;
        if(velocity!=this.velocity) accelerationTimer=(long)time;
        acceleration=(velocity-this.velocity)/(time-this.time);
        this.velocity=velocity;
        energyDrop=this.energy-energy;
        if(robot!=null) {
            if(energyDrop>0&&energyDrop<=3) {
                double bh=utils.normalAngle(utils.getBearing(x,y,robot.getX(),robot.getY()));
                VirtualBullet vb=new VirtualBullet((long)time,energyDrop,x,y,bh);
                robot.enemyBullets.addElement(vb);
                int robotIndex=robot.persistentRobotNames.indexOf(name);
                
                double robotHeading=robot.getHeading();
                double robotVelocity=Math.abs(robot.getVelocity());
                double dist=utils.dist(x,y,robot.getX(),robot.getY());
                double bulletTravelTime=dist/(20-(3*energyDrop));
                double robotTravelDist=robotVelocity*bulletTravelTime;
                double estX = robot.getX() + robotTravelDist * Math.sin(Math.toRadians(robotHeading));
                double estY = robot.getY() + robotTravelDist * Math.cos(Math.toRadians(robotHeading));
                bh=utils.normalAngle(utils.getBearing(x,y,estX,estY));
                
                robot.enemyBullets.addElement(new VirtualBullet((long)time,energyDrop,x,y,bh));
            }
        }
        this.energy=energy;
        avHeadingChange=utils.normalRelativeAngleDiff(heading,prevHeading)/(time-this.time);
        prevHeading=heading;
        if(timeAvHeadingChange==Double.POSITIVE_INFINITY) {
            timeAvHeadingChange=avHeadingChange;
        } else {
            timeAvHeadingChange=(0.9*timeAvHeadingChange)+(0.1*avHeadingChange);
        }
        timeAvDistance=(0.75*distance)+(0.25*timeAvDistance);
        avVelocity=(avVelocity+velocity)/(time-this.time);
        staticBot=avVelocity<0.01;
        this.time=time;
        updateHistory(this);
    }
    
    protected void updateHistory(robotInfo ri) {
        robotInfo lastInHistory=null;
        if(movementHistory.size()>0) {
            lastInHistory=(robotInfo)movementHistory.elementAt(0);
        }
        if(movementHistory.size()>0&&ri.time()-lastInHistory.time()>1) {
            robotInfo lih=lastInHistory;
            long timeDiff=(long)ri.time-(long)lih.time;
            double headingChange=utils.normalRelativeAngle(ri.calculatedHeading-lih.calculatedHeading)/timeDiff;
            double bearing=utils.normalAngle(utils.getBearing(lih.x,lih.y, ri.x,ri.y));
            double distance=Point2D.distance(lih.x,lih.y,ri.x,ri.y)/timeDiff;
            Point2D point=new Point2D.Double(lih.x,lih.y);
            long time=(long)lih.time;
            for(int i=0; i<timeDiff; i++) {
                double pointX = point.getX() + distance * Math.sin(Math.toRadians(bearing));
                double pointY = point.getY() + distance * Math.cos(Math.toRadians(bearing));
                point=new Point2D.Double(pointX,pointY);
                time++;
                robotInfo newEntry= new robotInfo(ri.name, pointX, pointY, time, Double.NaN, Double.NaN, bearing, distance, lih.energy, lih.calculatedHeading+((i+1)*headingChange), distance,headingChange);
                newEntry.movementHistory=new Vector();
                movementHistory.insertElementAt(newEntry,0);
            }
        } else {
            robotInfo newEntry=new robotInfo(ri);
            newEntry.movementHistory=new Vector();
            movementHistory.insertElementAt(newEntry,0);
        }
        while(movementHistory.size()>movementHistorySize) {
            movementHistory.removeElement(movementHistory.lastElement());
        }
    }
    
    public void update(ScannedRobotEvent evt, double x, double y) {
        update(evt.getName(),x,y,evt.getTime(),evt.getDistance(),evt.getHeading(),evt.getVelocity(),evt.getEnergy());
    }
    
    public void update(robotInfo ri) {
        update(ri.name(), ri.x(), ri.y(), ri.time(), ri.distance(), ri.heading(), ri.velocity(), ri.energy());
    }
    
    public String name() {return name;}
    public double x() {return x;}
    public double y() {return y;}
    public double time() {return time;}
    public double distance() {return distance;}
    public double heading() {return heading;}
    public double velocity() {return velocity;}
    public double acceleration() {return acceleration;}
    public long accelerationTimer() {return accelerationTimer;}
    public double energy() {return energy;}
    
    public double headingChange() {return headingChange;}
    public double averageHeadingChange() {return avHeadingChange;}
    public double timeAverageHeadingChange() {return timeAvHeadingChange;}
    public double timeAverageDistance() {return timeAvDistance;}
    public double averageVelocity() {return avVelocity;}
    
}
