// -*- java -*-

package eem;

import robocode.*;
import robocode.util.Utils;
import java.util.ArrayList; 
import java.util.*;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

import java.io.IOException;

//import eem.external.trees.secondGenKD.KdTree;
import eem.external.trees.jk.KDTree;

/**
 * zapper - robocode robot by Eugeniy E. Mikhailov
 */
public class zapper extends AdvancedRobot {
	static boolean firstTimeInit = true;
	static boolean isBulletShielder = false;
	static boolean isRoundOver = false;
	double gunSkippingFireWhenReadyCnt = 0;
	double bulletEnergy=3;
	double firingAngle=0;
	double gunPrecision=3./180.*Math.PI;
	long time = 0;
	long enemyLastSeenTime = 0;
	long enemyUnseenGracePeriod = 10;
	botStatus enemy = null;
	botStatus bot   = null;//new botStatus();
	Point BattleField = new Point();
	double BattleFieldDiagonal = 0;
	Point SWcorner = null;
	Point NEcorner = null;
	Point SWcornerCollision = null;
	Point NEcornerCollision = null;
	Bullet _bullet=null;
	Driver _driver = null;
	double lastEnemyBulletEnergy = 2; // 2 is good default for a typical enemy bullet
	boolean virtrualHitOnRealWave = true; // shall we track for seen by enemy angles in virtual waves
	boolean enemyEmitsVirtualWaves = false; // shall enemy emit a wave every click
	static long firedBulletCnt=0;
	static long hitBulletCnt=0;
	static long enemyFiredBulletCnt=0;
	static long enemyHitBulletCnt=0;
	static long myWaveCnt=0;    // these two are to be able decay the old data
	static long enemyWaveCnt=0;
	double myStatsDecayTime = 1000;
	public ArrayList<Wave> myWaves = new ArrayList<Wave>();
	public ArrayList<Wave> enemyWaves = new ArrayList<Wave>();
	double ramAvoidDistance = 200;

	int neigborsNumForMasterBotGun = 100;
	int neigborsNumForEnemyBotGun = 10;
	int myGunKdTreeSize = 100000;
	int MaxVirtualWavesMy = myGunKdTreeSize;
	int MaxVirtualWavesEnemy = myGunKdTreeSize; // Math.min(500, myGunKdTreeSize/3);
	public static KDTree.WeightedManhattan<Hit> hitsByMeTree = null;
	public static KDTree.WeightedManhattan<Hit> realWaveHitsByMeTree = null;
	public static KDTree.WeightedManhattan<Hit> hitsByEnemyTree = null;
	public static KDTree.WeightedManhattan<Hit> realWaveHitsByEnemyTree = null;
	public static KDTree.WeightedManhattan<Hit> realHitsByEnemyTree = null;

	// stats
	public static HashMap<String, Gun> gunMap = null;
	public static int[] notMatchedFiringSolutionCnt = null;
	public static int[] notFiredWhenCold = null;
	public static int[] bulletHitBulletCnt = null;
	public static int winCnt = 0;

	// gun managing related
	double IDEAL_BULLET_ENERGY = 1.95;
	double ENERGY_SAVING_BULLET = Rules.MIN_BULLET_POWER;
	double EPS = .00001; // double precision when used for comparison
	FiringSolutionsSet fullSetOfFiringSolutions = new FiringSolutionsSet();
	String bestGunName = "NaN";
	
	// logging
	private static RobocodeFileWriter fileWriter = null;

	public void run() {
		// start of the Round
		isRoundOver = false;
		setColors(Color.red, Color.white, Color.red);
		BattleField.x = getBattleFieldWidth();
		BattleField.y = getBattleFieldHeight();
		BattleFieldDiagonal = BattleField.dist( new Point() );
		SWcorner = new Point(18,18);
		SWcornerCollision = new Point(19,19);
		NEcorner = new Point(BattleField.x-18, BattleField.y-18);
		NEcornerCollision = new Point(BattleField.x-19, BattleField.y-19);
		Driver _driverRC = new RandomCircle();
		Driver _driverWS = new WaveSurfer();
		_driver = _driverWS;
		myWaves = new ArrayList<Wave>();
		enemyWaves = new ArrayList<Wave>();
		enemyLastSeenTime = 0;;
		botStatus tmpBot = new botStatus();
		if ( hitsByMeTree == null ) {
			hitsByMeTree = new KDTree.WeightedManhattan<Hit>(name2ind.size());
			hitsByMeTree.setWeights(tmpBot.scale);
		} else { updateTreeWeights( hitsByMeTree ); }
		if ( realWaveHitsByMeTree == null ) {
			realWaveHitsByMeTree = new KDTree.WeightedManhattan<Hit>(name2ind.size());
			realWaveHitsByMeTree.setWeights(tmpBot.scale);
		} else { updateTreeWeights( realWaveHitsByMeTree ); }
		if ( hitsByEnemyTree == null ) {
			hitsByEnemyTree = new KDTree.WeightedManhattan<Hit>(name2ind.size());
			hitsByEnemyTree.setWeights(tmpBot.scale);
		} else { updateTreeWeights( hitsByEnemyTree ); }
		if ( realWaveHitsByEnemyTree == null ) {
			realWaveHitsByEnemyTree = new KDTree.WeightedManhattan<Hit>(name2ind.size());
			realWaveHitsByEnemyTree.setWeights(tmpBot.scale);
		} else { updateTreeWeights( realWaveHitsByEnemyTree ); }
		if ( realHitsByEnemyTree == null ) {
			realHitsByEnemyTree = new KDTree.WeightedManhattan<Hit>(name2ind.size());
			realHitsByEnemyTree.setWeights(tmpBot.scale);
		} else { updateTreeWeights( realHitsByEnemyTree ); }
		if ( gunMap == null ) {
			gunMap = new HashMap<String, Gun>();
			fillMyGunMap(gunMap);
		}
		if (firstTimeInit) {
			firstTimeInit = false;
			notMatchedFiringSolutionCnt = new int[getNumRounds()];
			notFiredWhenCold = new int[getNumRounds()];
			bulletHitBulletCnt = new int[getNumRounds()];

			if ( fileWriter == null && this.getName().startsWith("eem.zapper vtest") ) {
				//String logFileName = this.getName() + "_wave.log";
				String logFileName = "eem.zapper_vtest_wave.log";
				dbg("logFileName: " + logFileName);
				try {
					fileWriter = new RobocodeFileWriter( this.getDataFile( logFileName ) );
				} catch (IOException ioe) {
					System.out.println("Trouble opening the logging file: " + ioe.getMessage());
				}
			}
		} else {
			if ( getRoundNum() > 5) {
				tuneupGuns(gunMap);
			}
		}

		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);

		setTurnRadarRight(Double.POSITIVE_INFINITY);

		while (true) {
			initTic();
			if ( (time - enemyLastSeenTime) > enemyUnseenGracePeriod ) {
				if (getOthers() > 0 ) { dbg("RADAR SLIP. SHAME! IT SHOULD NOT HAPPEN"); }
				setTurnRadarRight(Double.POSITIVE_INFINITY);
			}
			if (isRoundOver) {
				dbg("no enemies left");
				doWavesCleanUp();
				printStats();
				isRoundOver = false;
			}
			
			/* Not sure if this is good idea
			// decay gun stats
			for (String gunName : gunStatsMap.keySet() ) {
				GunStats _gs =  gunStatsMap.get(gunName);
				int threshold = 100;
				double alpha = 0.9;
				int delta = _gs.firedCnt - threshold;
				if ( delta > 0) {
					_gs.firedCnt *= alpha;
					_gs.hitCnt   *= alpha;
					if ( _gs.hitCnt < 0) {
						_gs.hitCnt = 0;
					}
				}
				delta=_gs.realFiredCnt - threshold;
				if ( delta > 0) {
					_gs.realFiredCnt   *= alpha;
					_gs.realHitCnt *= alpha;
					if ( _gs.realHitCnt < 0) {
						_gs.realHitCnt = 0;
					}
				}
			}
			*/

			_driver = _driverWS;
			if ( enemy != null ) {
				if (enemy.pos.dist( bot.pos ) < ramAvoidDistance ) {
					// we are possibly rammed
					// switch to random motion with good anti ram
					//_driver = _driverRC;
				}
			}
			_driver.move();

			execute();
		}

	}

	public void tuneupGuns(HashMap<String, Gun> map){
		dbg("tuning guns");
		ArrayList<Map.Entry<String,Gun>> glist = new ArrayList<>(map.entrySet());
		glist.sort(Collections.reverseOrder(Map.Entry.comparingByValue())); // best forward
		int nBest = 3; // number of best guns which will be mutated
		ArrayList<Gun> bestGuns = new ArrayList<Gun>();
		// selecting up to nBest top guns which are tunable
		for (int i=0; i < Math.min(nBest, glist.size()); i++) {
			Gun g= glist.get(i).getValue();
			if ( g.name.equals("realGun") ) { continue; }
			if ( !g.tunable ) { continue; }
			bestGuns.add(g);
			if (bestGuns.size() >= nBest) { break; }
		}
		// mutate the best guns and add them to selection
		int nMutations = 2;
		for( Gun g : bestGuns ) {
			for(int i=0; i<nMutations; i++) {
				Gun ng =  new KDTreeGun(g);
				ng.stats.degrade();
				ng.mutate();
				if ( map.containsKey( ng.getName() ) ) {
					continue; // do not put double of already existing guns
				}
				map.put(ng.getName(), ng);
			}
		}
		// trim gunMap to required number of guns
		int nGunsToKeep = 10; // remember there are a few (5) fast guns which do not slow calculation
		glist = new ArrayList<>(map.entrySet());
		glist.sort(Map.Entry.comparingByValue()); // worst forward
		for( Map.Entry<String,Gun> e :  glist) {
			Gun g = e.getValue();
			if (g.getName().equals("realGun")) { continue; } // keep realGun
			if (g.fast) { continue; } // keep fast gun
			if (gunMap.size()<= nGunsToKeep) { break; }
			map.remove(g.getName());
		}
	}

	public void fillMyGunMap(HashMap<String, Gun> map){
		Gun _gun = null;

		_gun = new Gun(); // HoT
		_gun.name = "realGun";
		map.put( _gun.getName(), _gun);

		// simple and fast non learning guns
		_gun = new Gun(); // HoT
		map.put( _gun.getName(), _gun);

		_gun = new RandomGun();
		map.put( _gun.getName(), _gun);

		_gun = new LinearGun();
		map.put( _gun.getName(), _gun);

		_gun = new SmartRandomGun();
		map.put( _gun.getName(), _gun);

		TargetingWeights tw = null;
		tw = new TargetingWeights();

		// Main Gun
		tw.realWave_realHit = 1; tw.realWave_virtualHit = 1;
		tw.virtualWave_virtualHit = 1;
		tw.timeDecay = Double.POSITIVE_INFINITY;
		tw.distScale = 1;
		tw.smoothingFactor = 0.1;

		_gun = new KDTreeGun("MainGun", tw);
		map.put( _gun.getName(), _gun);

		tw.timeDecay = 10000;
		_gun = new KDTreeGun("MainGun", tw);
		map.put( _gun.getName(), _gun);

		// Anti - HawkOnFire
		tw.realWave_realHit = 1; tw.realWave_virtualHit = 1;
		tw.virtualWave_virtualHit = 1;
		tw.timeDecay = 100000;
		tw.distScale = 1;
		tw.smoothingFactor = 0.05;
		_gun = new KDTreeGun("anti-HawkOnFireGun", tw);
		map.put( _gun.getName(), _gun);

		// Anti Surfer Gun (work better against my own bots like IWillFireNoBullet
		tw.realWave_realHit = -1; tw.realWave_virtualHit = 1;
		tw.virtualWave_virtualHit = 1.0;
		tw.timeDecay = 100000;
		tw.distScale = 1; // all nearest neighbors are equal weight
		tw.smoothingFactor = 0.10;
		_gun = new KDTreeGun("anti-Surfer", tw);
		map.put( _gun.getName(), _gun);

		tw.smoothingFactor = 0.20;
		_gun = new KDTreeGun("anti-Surfer", tw);
		map.put( _gun.getName(), _gun);

		// Anti BasiscGFSurfer
		tw.realWave_realHit = -0.1; tw.realWave_virtualHit = 1.0;
		tw.virtualWave_virtualHit = 0.0;
		tw.timeDecay = 10000;
		tw.smoothingFactor = 0.10;
		tw.distScale = 1;

		_gun = new KDTreeGun("anti-BasicGFSurfer", tw);
		map.put( _gun.getName(), _gun);

		// Anti Shadow
		tw.realWave_realHit = -0.3; tw.realWave_virtualHit = 1.0;
		tw.virtualWave_virtualHit = 0.0;
		tw.distScale = 1;
		tw.timeDecay = 100;
		tw.smoothingFactor = 0.10;
		_gun = new KDTreeGun("anti-ShadowGun", tw);
		map.put( _gun.getName(), _gun);
	}
	
	public class Driver {
		Point destinationPoint = new Point(BattleField.x/2, BattleField.y/2);
		public void move(){}
	}

	public class RandomCircle extends Driver {
		double circlingDirection = 1;
		double timeToChangeDirection = 0;
		public void move(){
			Point c = new Point();
			double R = 200; //BattleFieldDiagonal / 2;
			if ( enemy == null ) {
				// move to center
				this.destinationPoint.x = BattleField.x/2;
				this.destinationPoint.y = BattleField.y/2;
				moveToDestination( this.destinationPoint );
			} else {
				// simple circle around enemy in random directions
				double headOnAngle = enemy.pos.angleTo( bot.pos ); // angle from enemy
				double a = headOnAngle;
				double desiredDist = BattleFieldDiagonal/3;
				double distToEnemy = bot.pos.dist(enemy.pos);
				boolean enemyIsRamming = (distToEnemy <= ramAvoidDistance);
				timeToChangeDirection--;
				//if ( timeToChangeDirection < 0 && !enemyIsRamming ) {
				if ( timeToChangeDirection < 0 ) {
					//dbg("changing direction");
					this.circlingDirection *= -1;;
					timeToChangeDirection = Math.random()*40;
					if (  Math.random() < .1 ) {
						//dbg("long leap");
						timeToChangeDirection =  Math.random()*20;
					}
				}
				double aOffset = Math.PI/2*(distToEnemy-30)/desiredDist;
				if ( distToEnemy < 55) { aOffset = 0; }
				a += this.circlingDirection*aOffset;
				//dbg("aOf " + aOffset );
				double da = Math.PI/10;
				da = this.circlingDirection*da;
				double dR = 10;
				//R=desiredDist + dR;
				Point destP = new Point();
				//dbg("looking for new destination");
				//a += this.circlingDirection*aOffset;
				int cnt=0, cntMax=100;
				dbg("dist to enemy: "+ distToEnemy);
				boolean isDirectionFlipped = false;
				R = 4+Math.abs(bot.speed)/8*R;
				do {
					//R -= dR;
					destP.x = bot.pos.x + R*Math.cos(a);
					destP.y = bot.pos.y + R*Math.sin(a);
					//dbg( "R = " + R + " " + "da = " +da + " " +  destP );
					a += this.circlingDirection*da;
					if ( enemyIsRamming && Math.abs(a-headOnAngle)> Math.PI/2 ) {
						if ( !isDirectionFlipped ) {
							dbg("Dive in protection, attempted to move toward ramming enemy");
							this.circlingDirection *= -1;
							a=headOnAngle;
							isDirectionFlipped = true;
						} else {
							dbg("we are cornered, attempting to ram back");
							a=headOnAngle + Math.PI;
							destP.x = bot.pos.x + R*Math.cos(a);
							destP.y = bot.pos.y + R*Math.sin(a);
							break;
						}
					}
				} while ( !destP.isInsideBox( SWcorner, NEcorner) && (cntMax > cnt++)  );
				dbg( "dest = " +  destP );
				this.destinationPoint.x = destP.x;
				this.destinationPoint.y = destP.y;

				moveToDestination( this.destinationPoint );
			}
		}
	}

	public class WaveSurfer extends Driver {
		public void move() {
			Wave wToSurf = null;
			double waveClosestDist = Double.NEGATIVE_INFINITY;
			boolean virtualWave = false;
			for (int i = 0; i < enemyWaves.size(); i++) {
				Wave w = (Wave) enemyWaves.get(i);
				if (!w.isReal) continue; // not surfing virtual waves
				double surfDist = w.getSurfingDistanceTo(bot.pos);
				// positives mean that wave is behind the point
				if (surfDist > -2 ) {
					// this wave either behind or we are surfing it
					// so too late to worry about it
					continue;
				} else {
					if ( surfDist > waveClosestDist ) {
						// this wave is closer to us
						waveClosestDist = surfDist;
						wToSurf = w;
					}
				}

			}
			if (wToSurf == null && enemyWaves.size() > 0) {
				// we did not find a real enemy wave, will use old virtual
				wToSurf = enemyWaves.get(0);
			}
			if (wToSurf == null && enemy != null) {
				// enemy exists but we do not even have a virtual wave to surf
				// we create a fake wave
				wToSurf = new Wave();
				wToSurf.source = enemy;
				wToSurf.target = bot;
				// TODO a typical enemy bullet energy
				wToSurf.bulletEnergy = 3.0;
				assignWaveDanger( wToSurf );
				virtualWave = true;
				enemyWaves.add(wToSurf);
			}
			if (wToSurf == null) {
				//dbg("No enemy waves to surf");
				// do some default motion
				return;
			}
			if (wToSurf.surfingInfo.isCalculated) {
				// if we have it calculated, we already moving there
				// also it helps against default bot alignment (0 rad) 
				// when remaining travel distance is 0
				//dbg("danger for this w is known");
				//return;
			}
			double maxExcapeAnge = maxEscapeAngleForSpeed(wToSurf.getSpeed());
			double safestDanger = Double.POSITIVE_INFINITY;
			double headOnAngle = wToSurf.source.pos.angleTo( wToSurf.target.pos );
			double refAngle = wToSurf.source.pos.angleTo( bot.pos );
			// find how far bot could move CW or CCW from current position
			// before it get hit
			// positives mean that wave is behind the point
			int safestBin =0;
			// checking CCW direction
			int surfDirection = 1; // 1 means CCW, -1 means CW
			DangerPoint ccwDestinationPoint = findTheSafestPontOnWave( wToSurf, surfDirection );
			firingAngle = Utils.normalRelativeAngle( wToSurf.source.pos.angleTo( ccwDestinationPoint.pos ) - headOnAngle );
			int gfBin = xToBinInRange( firingAngle, -maxExcapeAnge, maxExcapeAnge, wToSurf.Nbins );
			//dbg("safest CCW point " +  ccwDestinationPoint + " and gfBin " + gfBin);
			if ( ccwDestinationPoint.danger < safestDanger ) {
				safestDanger = ccwDestinationPoint.danger;
				safestBin = gfBin;
				destinationPoint = ccwDestinationPoint.pos;
			}

			// checking CW direction
			surfDirection = -1; // 1 means CCW, -1 means CW
			DangerPoint cwDestinationPoint = findTheSafestPontOnWave( wToSurf, surfDirection );
			firingAngle = Utils.normalRelativeAngle( wToSurf.source.pos.angleTo( cwDestinationPoint.pos ) - headOnAngle );
			gfBin = xToBinInRange( firingAngle, -maxExcapeAnge, maxExcapeAnge, wToSurf.Nbins );
			//dbg("safest CW  point " +  cwDestinationPoint + " and gfBin " + gfBin);
			if ( cwDestinationPoint.danger < safestDanger ) {
				safestDanger = cwDestinationPoint.danger;
				safestBin = gfBin;
				destinationPoint = cwDestinationPoint.pos;
			}

			//dbg("" + arrayToTextPlot(wToSurf.waveDanger) + " <- wave danger");
			/* handy to have txt display of current and position to be
			firingAngle = Utils.normalRelativeAngle( wToSurf.source.pos.angleTo( destinationPoint ) - headOnAngle );
			double[] myPosArray = new double[ wToSurf.Nbins ];
			double myAngle = wToSurf.source.pos.angleTo( bot.pos );
			int myCurrentBin=xToBinInRange( myAngle - headOnAngle, -maxExcapeAnge, maxExcapeAnge, wToSurf.Nbins );
			myPosArray[ myCurrentBin ]=-3;
			myPosArray[ safestBin ]=5;
			//dbg("" + arrayToTextPlot(myPosArray) + " <- my current and reachable positions in the wave");
			*/
			//dbg("========================================================");
			wToSurf.surfingInfo.safestReachableBin = safestBin;
			wToSurf.surfingInfo.destinationPoint = this.destinationPoint;
			wToSurf.surfingInfo.isCalculated = true;
			moveToDestination( this.destinationPoint );
		}
	}

	public DangerPoint findTheSafestPontOnWave(Wave wToSurf, double surfDirection ) {
		Point destP = new Point( bot.pos );
		double safestDanger = Double.POSITIVE_INFINITY;
		double desiredDist = BattleFieldDiagonal/3;
		desiredDist = 800;
		double maxExcapeAnge = maxEscapeAngleForSpeed(wToSurf.getSpeed());
		double maxBodyRot = 10./180.0*Math.PI;
		double probeStick = 220;
		double angleToCorrectDist = 20.0/180.0*Math.PI;
		double testAngle = 0;
		//double headOnAngle = wToSurf.source.pos.angleTo( wToSurf.target.pos );
		Point curV = new Point( bot.velocity );
		botStatus futBot = new botStatus();
		futBot.pos = new Point(bot.pos);
		futBot.velocity = new Point(bot.velocity);
		futBot.heading = bot.heading;
		futBot.speed = bot.speed;
		double pDanger = 0;
		if ( futBot.speed < 0 ) {
			// normalizing heading and speed
			futBot.speed *= -1;
			futBot.heading += Math.PI;
		}
		int timeToSurf = 100; // reasonable limit
		for (int cnt=1; cnt <= timeToSurf; cnt++) {
			double latVel = wToSurf.source.pos.lateralVelocityOf( futBot );
			double radVel = wToSurf.source.pos.radialVelocityOf( futBot );
			double distToSource = wToSurf.source.pos.dist(futBot.pos);
			double speed = futBot.velocity.length();
			maxBodyRot = (10-0.75*Math.abs(speed))/180.0*Math.PI;
			double direction = futBot.velocity.angle();
			//dbg("-----------------");
			//dbg("curBotPos " + futBot.pos + " curBotVel = " + futBot.velocity);
			//dbg("direction = " + direction + " velocity based");
			if ( speed == 0 ) {
				direction = futBot.heading;
				//dbg("direction = " + direction + " heading based");
			}
			//dbg(" old velocity " + futBot.velocity  + " speed = " + futBot.velocity.length());
			//dbg("dist to source = " + distToSource + " radVel " +  radVel + " latVel " + latVel);
			double rA = maxBodyRot*Math.signum( latVel);
			//dbg(" angle to futBot.pos " + wToSurf.source.pos.angleTo( futBot.pos ) );
			double headOnAngle = wToSurf.source.pos.angleTo( futBot.pos );
			double desiredHeading =  surfDirection*Math.PI/2; // relative to head on
			//dbg("desiredHeading raw " + desiredHeading);
			double ramDangerDist = 100;
			double ramMultiplier =1;
			boolean isEnemyRamming =  isRamming(futBot, wToSurf);
			desiredHeading += 
				Math.signum( distToSource - desiredDist ) 
				* angleToCorrectDist * surfDirection 
				* Math.min(1, Math.abs(distToSource - desiredDist)/36);
			if ( isEnemyRamming ) {
				desiredHeading = surfDirection * Math.PI*40./180. ;
				//dbg("enemy ramming");
			}
			//dbg("desiredHeading enemy dist corrected " + desiredHeading/Math.PI*180);
			double probeAngleIncrement = surfDirection*1.0/180*Math.PI;
			desiredHeading -= probeAngleIncrement;
			Point testP = null;
			int cntHere=0, cntMax=200;
			do {
				desiredHeading += probeAngleIncrement; // relative to head on
				testP = new Point ( futBot.pos);
				testP.addPolarVec( 4+futBot.speed/8*probeStick, desiredHeading + headOnAngle );
				//dbg("desiredHeading probe in the box " + desiredHeading*180/Math.PI + " to point " + testP);
			} while ( !testP.isInsideBox( SWcorner, NEcorner) && (cntMax > cntHere++)  );
			//dbg("desiredHeading box corrected " + desiredHeading*180/Math.PI);
			desiredHeading += headOnAngle;
			double missingAngle = Utils.normalRelativeAngle( desiredHeading - futBot.heading );

			//dbg(" velocity before zero correction " + futBot.velocity  + " speed = " + futBot.velocity.length() + " heading " + futBot.heading);
			if ( Utils.isNear(speed,0) && (Math.abs( missingAngle ) > Math.PI/2) ) {
				// we have a chance to choose right direction
				futBot.heading += Math.PI;
			}
			missingAngle = Utils.normalRelativeAngle( desiredHeading - futBot.heading );
			//dbg(" velocity before rotation " + futBot.velocity  + " speed = " + futBot.velocity.length() + " heading " + futBot.heading);

			//dbg("need to rotate " + missingAngle );
			rA = Math.min(maxBodyRot, Math.abs(missingAngle)) *Math.signum( missingAngle );
			if ( Math.abs( missingAngle ) > Math.PI/2 ) {
				// we need to decelerate and rotate other way
				rA = -rA;
			}
			futBot.velocity.rotateBy( rA );
			futBot.heading+= rA;
			//dbg(" new velocity after rotation " + futBot.velocity  + " speed = " + futBot.velocity.length() + " heading " + futBot.heading);

			Point updVelocity = futBot.velocity;
			missingAngle = Utils.normalRelativeAngle( desiredHeading - futBot.heading );
			if ( Math.abs( missingAngle) <= Math.PI/2 ) {
				// may be we can accelerate
				if ( speed < 8 ) {
					double maxAccel = 1;
					speed += maxAccel;
					speed = Math.min( speed, 8 );
					updVelocity = new Point();
					updVelocity.addPolarVec( speed, futBot.heading);
					//dbg("latVel after accel " + wToSurf.source.pos.lateralVelocityOf( futBot) );
				}
			} else {
				// we should flip velocity direction 
				double maxDeAccel = 2;
				speed -= maxDeAccel;
				if (speed < 0) {
					speed *= -1;
					futBot.heading += Math.PI;
				}
				updVelocity = new Point();
				updVelocity.addPolarVec( speed, futBot.heading);
			}
			futBot.velocity = updVelocity;
			futBot.speed = futBot.velocity.length();

			//dbg(" new velocity after accel/deaccel " + futBot.velocity  + " speed = " + futBot.velocity.length());
			testP = new Point ( futBot.pos);
			testP.add( futBot.velocity );

			double dxToEnemy = Math.abs( enemy.pos.x - futBot.pos.x );
			double dyToEnemy = Math.abs( enemy.pos.y - futBot.pos.y );
			boolean collisionWithEnemy = false;
			if ( (dxToEnemy < (34.0))  && (dyToEnemy < (34.0) ) ){
				collisionWithEnemy = true;
			}
			if (testP.isInsideBox( SWcorner, NEcorner) && !collisionWithEnemy) {
				if ( isEnemyRamming && (Math.PI-Math.abs(desiredHeading - headOnAngle))< 36/distToSource ) {
					//dbg("dive in protection: not going that direction");
				} else {
					futBot.pos = testP;
				}
			} else {
				futBot.velocity = new Point(0,0);
				futBot.speed = 0;
			}
			//dbg("futPos " + futBot.pos + " curV " + futBot.velocity + " speed " + futBot.velocity.length() );
			if (wToSurf.isBehindAtTime( futBot, time + cnt) ) {
				   //dbg("cnt= " + cnt + " " + futBot + " isBehind wave");
			   	break;
		   	}
			// let's get the danger of this point
			headOnAngle = wToSurf.source.pos.angleTo( wToSurf.target.pos );
			double firingAngle = Utils.normalRelativeAngle( wToSurf.source.pos.angleTo( futBot.pos ) - headOnAngle );
			double distToFutPos = wToSurf.source.pos.dist( futBot.pos );
			double botAngularSize = 25/distToFutPos;
			int gfBinSt = xToBinInRange( firingAngle-botAngularSize, -maxExcapeAnge, maxExcapeAnge, wToSurf.Nbins );
			int gfBinEn = xToBinInRange( firingAngle+botAngularSize, -maxExcapeAnge, maxExcapeAnge, wToSurf.Nbins );
			//dbg("gfBinSt " + gfBinSt + "; gfBinEn " + gfBinEn);
			for (int gfBin=gfBinSt; gfBin <= gfBinEn; gfBin++) {
				pDanger += wToSurf.waveDanger[gfBin];
			}
			//if (distToSource > 60 ) pDanger =0;
			//pDanger += 1e-2/wToSurf.source.pos.dist( futBot.pos ); //bot danger
			//dbg("fut Pos " + futBot.pos + " curV " + futBot.velocity + " speed " + futBot.velocity.length() + " with danger " + pDanger + " gfBin " + gfBin + " at gF " + firingAngle/maxExcapeAnge);
			if (isEnemyRamming && !wToSurf.isReal ) {
				pDanger =0; // when enemy is ramming we should be more worried about getting away
			}
			if ( distToSource < 100 ) {
				pDanger =0; // if source is so close there is no wave to dodge the bullet
			}
			// adding some enemy distance dependent danger
			pDanger *= 1.0/distToSource;
			pDanger += .1/distToSource;
			//dbg("this point danger = " + pDanger);
			if ( pDanger <= safestDanger ) {
				safestDanger = pDanger;
				destP = futBot.pos;
				//dbg("safest point <=-- " +  destP + " with gf = " + firingAngle/maxExcapeAnge);
			}
		}
		DangerPoint dest = new DangerPoint();
		dest.pos = destP;
		dest.danger = pDanger;
		return dest;
	}

	public class DangerPoint {
		Point pos = new Point(0,0);
		double danger = 0;
		public String toString() {
			String str="";
			str += pos + " with danger " + danger;
			return str;
		}
	}

	public boolean isRamming( botStatus bot, Wave wToSurf ) {
		return isRamming( bot, wToSurf.source );
	}

	public boolean isRamming( botStatus bot, botStatus enemy ) {
		if (bot.pos.dist(enemy.pos) < ramAvoidDistance ) {
			return true;
		}
		return false;
	}

	public void moveToDestination( Point destP ) {
		double angleToDest = bot.pos.angleTo( destP );
		double distToDest = bot.pos.dist( destP );
		double realHeading = bot.heading;
		double rotAngle = Utils.normalRelativeAngle( angleToDest - realHeading );
		double direction = 1;
		if ( Math.abs(rotAngle) > Math.PI/2 ) {
			rotAngle = Utils.normalRelativeAngle( rotAngle - Math.PI );
			direction = -1;

		}
		setTurnLeftRadians( rotAngle);
		setAhead(distToDest*direction);
	}

	public void initTic() {
		time = getTime();
		//dbg("tic: " + time );
		updateMasterBot();
		//dbg(bot);
		updateMyWaves();
		updateEnemyWaves();
		if (hitsByEnemyTree.size() > MaxVirtualWavesEnemy) enemyEmitsVirtualWaves=false;
		if ( enemy != null && enemyEmitsVirtualWaves ) {
			// virtual wave from enemy
			boolean isReal = false;
			addEnemyWave( enemy, lastEnemyBulletEnergy, isReal );
		}
	}

	public void updateMasterBot() {
		double oldAverageSpeed = 0;
		if ( bot != null ) {
			if ( time == bot.time ) {
				// already update for this tic
				// most likely we get it during the onScannedRobot event
				return;
			}
			oldAverageSpeed = bot.averageSpeed;
		}
		botStatus prevBotStatus = bot;
		bot = new botStatus();
		bot.prev = prevBotStatus;
		bot.name = getName();
		bot.pos.x=getX();
		bot.pos.y=getY();
		bot.gunHeat = getGunHeat();
		// proper Cartesian heading
		bot.heading = Utils.normalRelativeAngle(Math.PI/2 -  getHeadingRadians());
		bot.speed = getVelocity();
		double weight=0.9;
		bot.averageSpeed = weight*oldAverageSpeed + (1-weight)*bot.speed; 
		bot.time = getTime();
		bot.velocity.x = bot.speed * Math.cos( bot.heading );
		bot.velocity.y = bot.speed * Math.sin( bot.heading );
	}

	public void doWavesCleanUp() {
		dbg("requested to do waves cleanup");
		// TODO shall I somehow count my real waves which are still in the air
		// otherwise my hit rate is underestimated a bit
		myWaves = new ArrayList<Wave>();
		// we still need to surf enemy waves
		//enemyWaves = new ArrayList<Wave>();

	}

	public void updateMyWaves() {
		for (int i = 0; i < myWaves.size(); i++) {
			Wave w = (Wave) myWaves.get(i);
			if ( w.isCrossing( enemy.pos ) ) {
				//dbg("wave fired at time " + w.source.time + " crosses bot " + enemy.name);
				boolean isTrueHit = false;
				registerHitOnMyWave(w, enemy.pos, isTrueHit);
			}
			if ( w.isBehind(enemy) ) {
				for (String gunName : w.firingSolutions.keySet() ) {
					if ( !gunMap.containsKey( gunName ) ) {
						dbg("ERROR: unknown gun = " + gunName + " is used in the wave");
						continue;
					} else {
						gunMap.get(gunName).stats.firedCnt++;
						if (w.isReal) {
							gunMap.get(gunName).stats.realFiredCnt++;
						}
					}
				}
				myWaves.remove(i); 
				i--;
			}
		}
	}

	public void registerHitOnMyWave( Wave w, Point pos, boolean isTrueHit) {
		if (w.hit == null ) {
			w.hit = new Hit();
			w.hit.hitAngleRange = w.hitAngleRange( pos ) ;
		} else {
			w.hit.hitAngleRange.merge( w.hitAngleRange( pos ) );
		}
		//_hit.hitAngle =  w.hitAngle( pos );
		w.hit.waveCount = w.count;
		w.hit.hitTime = myWaveCnt;
		if (!w.hit.isWaveReal) { w.hit.isWaveReal = w.isReal; } // do not downgrade real to virtual
		if (!w.hit.isReal) { w.hit.isReal = isTrueHit; } // do not downgrade real to virtual
		if (w.coord == null) {
			w.coord = w.source.treeCoord( w.target, w.bulletEnergy );
		}
		String strOut = "{\"my_wave\": 1, \"coord\": " + Arrays.toString(w.coord) + ", " + w.hit.toString() + " }";
		//dbg(strOut);
		log(strOut);
		w.logHitInTree(w.hit, hitsByMeTree);
		if ( w.isReal ) {
			w.logHitInTree(w.hit, realWaveHitsByMeTree);
		}

		boolean isHitFiringSolutionFound = false;
		ArrayList<String> gunsToRemove = new ArrayList<String>();
		for (String gunName : w.firingSolutions.keySet() ) {
			if ( !gunMap.containsKey( gunName ) ) {
				dbg("ERROR: unknown gun = " + gunName + " is used in the wave");
				continue;
			} else {
				double firingAngle = w.firingSolutions.get( gunName );
				if ( w.hit.contains(firingAngle) ) {
					// this firing solution has a hit
					isHitFiringSolutionFound = true;
					gunMap.get( gunName ).stats.firedCnt++;
					gunMap.get( gunName ).stats.hitCnt++;
					if (isTrueHit || w.isReal) {
						gunMap.get( gunName ).stats.realHitCnt++;
						gunMap.get( gunName ).stats.realFiredCnt++;
					}
					gunsToRemove.add( gunName ); // otherwise we double counting
				}
			}
		}
		if ( isTrueHit && !isHitFiringSolutionFound ) {
			dbg("Warning: guns on this wave already counted as True hits, and not available at tic " + time);
			notMatchedFiringSolutionCnt[getRoundNum()]++;
		}
		for (String gunName : gunsToRemove ) {
			w.firingSolutions.remove( gunName ); 
		}
	}

	public void registerHitOnEnemyWave( Wave w, Point pos, boolean isTrueHit) {
		if (w.hit == null ) {
			w.hit = new Hit();
			w.hit.hitAngleRange = w.hitAngleRange( pos ) ;
		} else {
			w.hit.hitAngleRange.merge( w.hitAngleRange( pos ) );
		}
		//w.hit.hitAngle =  w.hitAngle( pos );
		w.hit.waveCount = w.count;
		w.hit.hitTime = myWaveCnt;
		if (!w.hit.isWaveReal) { w.hit.isWaveReal = w.isReal; } // do not downgrade real to virtual
		if (!w.hit.isReal) { w.hit.isReal = isTrueHit; } // do not downgrade real to virtual
		if (w.coord == null) {
			dbg("registerHitOnEnemyWave");
			w.coord = w.source.treeCoord( w.target, w.bulletEnergy );
		}
		w.logHitInTree( w.hit, hitsByEnemyTree);
		if ( w.hit.isReal ) {
			w.logHitInTree( w.hit, realHitsByEnemyTree );
		}
		if ( w.isReal ) {
			w.logHitInTree( w.hit, realWaveHitsByEnemyTree );
		}
	}

	public void updateEnemyWaves() {
		for (int i = 0; i < enemyWaves.size(); i++) {
			Wave w = (Wave) enemyWaves.get(i);
			if (
					w.isCrossing( bot.pos ) 
					&& virtrualHitOnRealWave // shall we track for seen by enemy angles
			   ) { 
				//dbg("wave fired at time " + w.source.time + " crosses bot " + bot.name);
				boolean isTrueHit = false;
				registerHitOnEnemyWave( w, bot.pos, isTrueHit );
			}
			if ( w.isBehind( bot ) ) {
				enemyWaves.remove(i); 
				i--;
			}
		}
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		time = getTime();
		enemyLastSeenTime = time;
		//dbg("enemy Scanned at time " + time);
		updateMasterBot();
		//dbg("my Pos" + bot);
		HashMap<String, Double> fSols = new HashMap<String, Double>();

		double enemyHeading = Utils.normalAbsoluteAngle( getHeadingRadians() + e.getBearingRadians());
		double distance = e.getDistance();
		double oldAverageSpeed = 0;
		double oldEnergy = 0;
		double enemyBulletEnergy = 0;
		if ( enemy != null ) {
			oldAverageSpeed = enemy.averageSpeed;
			oldEnergy = enemy.energy;
		}
		botStatus prevEnemyStatus = enemy;
		enemy = new botStatus();
		enemy.prev = prevEnemyStatus;
		enemy.energy = e.getEnergy();
		enemy.pos.x = bot.pos.x + Math.sin(enemyHeading) * distance;
		enemy.pos.y = bot.pos.y + Math.cos(enemyHeading) * distance;
		enemy.name=e.getName();
		// gun heat calculations
		if ( enemy.prev != null ) {
			enemy.gunHeat = Math.max(0, enemy.prev.gunHeat - getGunCoolingRate());
		} else {
			if (time < 30 ) {
				enemy.gunHeat = 3.0 - getGunCoolingRate()*time;
			}
		}
		// proper Cartesian heading
		enemy.heading =  gameAngleToCartesian(e.getHeadingRadians());
		enemy.speed = e.getVelocity();
		double weight = 0.9;
		enemy.averageSpeed = weight*oldAverageSpeed + (1-weight)*enemy.speed; 
		enemy.velocity.x = enemy.speed * Math.cos( enemy.heading );
		enemy.velocity.y = enemy.speed * Math.sin( enemy.heading );
		enemy.time = time;
		//dbg(enemy);


		// let's decide if enemy fired a bullet or it is something else
		double energyChange = oldEnergy - enemy.energy;
		if ( energyChange > 0 ) {
			if ( prevEnemyStatus != null ) {
				// could it be collision with a wall?
				double accel = Math.abs( enemy.speed ) - Math.abs( prevEnemyStatus.speed );
				//dbg( "accel = " + accel);
				if (accel < - Rules.DECELERATION) {
					// collision with a wall or a bot
					if (!enemy.pos.isInsideBox( SWcornerCollision, NEcornerCollision)) {
						// collision with a wall
						double wallCollisionPenalty = Rules.getWallHitDamage( prevEnemyStatus.speed );
						energyChange -= wallCollisionPenalty;
						//dbg("tic: " + time + " wall hit detected with energy penalty " + wallCollisionPenalty + " for the speed " + prevEnemyStatus.speed );
					} else {
						if ( Utils.isNear(energyChange, Rules.ROBOT_HIT_DAMAGE) ) {
							// bots collided
							energyChange -= Rules.ROBOT_HIT_DAMAGE; // 0.6 energy points
						} else {
							dbg("this is likely a bot with bot collision on top of the wall hit with energy change of " + energyChange);
							dbg("TODO make code to handle such collisions");
						}
					}
				}
			}
			if (  energyChange > Rules.MAX_BULLET_POWER ) {
				dbg(" unaccounted energy drop forcing energy of bullet to " + Rules.MAX_BULLET_POWER );
				energyChange = Rules.MAX_BULLET_POWER;
			}
			if ( !Utils.isNear(energyChange, 0) ) {
				enemyBulletEnergy = energyChange;
				if ( energyChange < Rules.MIN_BULLET_POWER - EPS ) {
					dbg(" suspiciously low energy drop of " + energyChange + " for a bullet");
				}
				//dbg("tic: " + time + " enemy fired bullet with energy " + enemyBulletEnergy);
				boolean isReal = true;
				enemy.gunHeat = enemyBulletEnergy/5.0 + 1.0 - getGunCoolingRate(); // we detect 1 click after the fire
				addEnemyWave( enemy, enemyBulletEnergy, isReal );
			}
		}

		// simple radar lock
		double radRotAngle =  Utils.normalRelativeAngleDegrees(getHeading() + e.getBearing() - getRadarHeading());
		if (radRotAngle > 0) {
			radRotAngle += 45/2;
		} else {
			radRotAngle -= 45/2;
		}
		setTurnRadarRight( radRotAngle);

		// Fire the gun. Remember firing happens with previous turn solutions
		// so we do it before calculating the new one
		fSols = fullSetOfFiringSolutions.fSols;
		if ( fSols.containsKey( bestGunName ) ) {
			firingAngle = fSols.get( bestGunName );
		} else {
			firingAngle = 0;  // always point to enemy
			bulletEnergy = Double.NaN;
		}
		_bullet = null;
		double distToEnemy = bot.pos.dist( enemy.pos );
		// gun firing angle
		if ( distToEnemy < 200 ) {
			bulletEnergy = robocode.Rules.MAX_BULLET_POWER;
		} else {
			bulletEnergy = IDEAL_BULLET_ENERGY;
			if ((enemy.energy - getEnergy() > 0) && (getEnergy() < 10))  {
				// energy saving
				bulletEnergy = ENERGY_SAVING_BULLET;
			}
		}
		// do not fire bullet more energetic than necessary
		// bullet damage 4*bE + max(0, 2*(bE-1))
		double bulletNeededToKill = (enemy.energy+2)/6.0;
		if (bulletNeededToKill < 1 ) { bulletNeededToKill = enemy.energy/4.0; }
		bulletEnergy = Math.min( bulletEnergy, bulletNeededToKill);
		bulletEnergy = Math.max( bulletEnergy, Rules.MIN_BULLET_POWER); // but we need to fire at least MIN_BULLET_POWER
		bulletEnergy = Math.min( getEnergy()-.05, bulletEnergy);
		// FIXME fire a wave even if no real bullet can be fired, i.e. we low on energy
		if (bulletEnergy >= Rules.MIN_BULLET_POWER && !Double.isNaN(bulletEnergy) ) {
			if ( Utils.isNear(0, Math.abs(getGunTurnRemainingRadians())) || ( gunSkippingFireWhenReadyCnt >2 && !isBulletShielder ) ) {
				//dbg("Gun angle = " + gameAngleToCartesian(getGunHeadingRadians()) );
				//dbg("Gun remaining angle = " + Math.abs(getGunTurnRemainingRadians()) );
				gunSkippingFireWhenReadyCnt=0;
				_bullet = setFireBullet( bulletEnergy );
			} else {
				if ( Utils.isNear(bot.gunHeat,0) ) {
					gunSkippingFireWhenReadyCnt++;
					//dbg("not firing when cold at tic " + time + " heat is " + getGunHeat());
				   	notFiredWhenCold[getRoundNum()]++;
				}
			}
			if (_bullet != null ) {
				//dbg("==> bullet fired at time " + time + " with energy " + _bullet.getPower());
				firedBulletCnt++;
				bulletEnergy = _bullet.getPower();
				String gunName = "realGun";
				double realGunFiringAngle =  Utils.normalRelativeAngle( gameAngleToCartesian(getGunHeadingRadians()) - bot.pos.angleTo( enemy.pos ) ); // with respect to HoT
				fSols.put(gunName, realGunFiringAngle);
			}
			if ( hitsByMeTree.size() <= MaxVirtualWavesMy ) {
				Wave w = new Wave();
				myWaveCnt++;
				w.count = myWaveCnt;
				w.source = bot;
				w.target = enemy;
				if ( Double.isNaN(bulletEnergy) ) {
					bulletEnergy = IDEAL_BULLET_ENERGY; // This should never happen
				}
				w.bulletEnergy = bulletEnergy;
				w.firingSolutions = fSols;
				w.isReal = false;
				w.coord = fullSetOfFiringSolutions.coord;
				if (_bullet != null ) {
					w.isReal = true;
					w.bulletEnergy = _bullet.getPower();
					gunMap.get( bestGunName ).stats.realUseCnt++;
				}
				myWaves.add(w);
				for (Wave eW: enemyWaves ) {
					eW.addSafetyCorridorFromWave( w );
				}
				if ( bestGunName.equals( "shieldGun") ) {
					// for shield gun we also fire virtual bullet
					w = new Wave();
					myWaveCnt++;
					w.count = myWaveCnt;
					w.source = bot;
					w.target = enemy;
					w.bulletEnergy = IDEAL_BULLET_ENERGY; // default energy. FIXME: use distance
					w.firingSolutions = fSols;
					w.isReal = false;
					myWaves.add(w);
				}
			} else {
				dbg("hitsByMeTree is full, do not generate wave which cannot process");
			}
		}

		bulletEnergy = Math.min( bulletEnergy, robocode.Rules.MAX_BULLET_POWER );
		bulletEnergy = (Math.round( bulletEnergy * 10 ) - .5 )/10; // exploiting x.x5 power bug in old bots

		bulletEnergy = Math.min( bulletEnergy, enemy.energy/4); // damage per bullet
		bulletEnergy = Math.max( 0.102, bulletEnergy); // energy below 0.1 not allowed
		if ( isBulletShielder ) {
			bulletEnergy = 0.3; // bullet shielder
		}
		bulletEnergy = Math.min( getEnergy()-.05, bulletEnergy);

		// create enough info about future bot status
		botStatus fbot = new botStatus();
		fbot.time = bot.time+1;
		fbot.pos = new Point(bot.pos );
		fbot.pos.add( bot.velocity );
		fbot.velocity = new Point( bot.velocity );
		fbot.prev = bot;
		fbot.name = bot.name;

		// some useful defaults
		double requiredGunPrecision = gunPrecision;
		Point targetFuturePos = new Point( enemy.pos ); 
		targetFuturePos.add( enemy.velocity );

		if ( !isBulletShielder ) {
		fullSetOfFiringSolutions = calcFiringSolutions( fbot, enemy, bulletEnergy );
		fSols = fullSetOfFiringSolutions.fSols;
		firingAngle = 0;
		ArrayList<Map.Entry<String,Gun>> glist = new ArrayList<>(gunMap.entrySet());
		glist.sort(Collections.reverseOrder(Map.Entry.comparingByValue())); // sort by gun hitRatio
		for (int i=0; i < glist.size(); i++) {
			bestGunName = glist.get(i).getKey();
			if ( !bestGunName.equals("realGun") ) { break; }
		}
		firingAngle = fSols.get( bestGunName );
		//dbg("Best gun: " + bestGunName + ", firingAngle: " + firingAngle + ", hitRate: " + gunMap.get( bestGunName ).stats.getHitRatioEstimate() );
		
		// anti bullet shield measure: avoid headOn firing
		double enemyBotAngularSize = 18/distToEnemy;
		if ( Math.abs(firingAngle) < (enemyBotAngularSize)/20 ) {
			//dbg("avoiding exact headOn firing");
			if (Math.random() > 0.5) {
				firingAngle =  enemyBotAngularSize/5;
			} else {
				firingAngle = -enemyBotAngularSize/5;
			}
		}
			requiredGunPrecision = Math.max(gunPrecision, enemyBotAngularSize/3);
		} else {
			// we are using bullet shielder

			// let's find the closest wave
			Wave wToIntercept = null;
			double waveClosestDist = Double.NEGATIVE_INFINITY;
			for (int i = 0; i < enemyWaves.size(); i++) {
				Wave w = (Wave) enemyWaves.get(i);
				if (!w.isReal) continue; // not intercepting virtual waves
				double surfDist = w.getSurfingDistanceTo(fbot.pos);
				// positives mean that wave is behind the point
				if (surfDist > -(18+2*w.getSpeed()) ) {
					// this wave either behind or too close
					// so too late to worry about it
					continue;
				} else {
					if ( surfDist > waveClosestDist ) {
						// this wave is closer to us
						waveClosestDist = surfDist;
						wToIntercept = w;
					}
				}
			}
			if ( wToIntercept == null ) {
				bulletEnergy = 0; // fake bullet which gun will not fire
				firingAngle = 0;
			} else {
				dbg("At time " + time + " trying to intercept wave fired at " + wToIntercept.source.time);
				// creating  rudimentary intercepting wave
				Wave w = new Wave();
				w.bulletEnergy = bulletEnergy;
				w.source = fbot;
				w.target = null;

				double enemyBulletGuessedAngle = 0; // relative to HoT
				if (wToIntercept.surfingInfo.isCalculated) {
					double maxEscapeAngle = maxEscapeAngleForSpeed( wToIntercept.getSpeed());
					int i=wToIntercept.surfingInfo.safestReachableBin;
					enemyBulletGuessedAngle = binToXInRange( i, -maxEscapeAngle, maxEscapeAngle, wToIntercept.waveDanger.length);
				}
				Point firingSolution = counterBulletFiringAngle( wToIntercept, enemyBulletGuessedAngle, w);
				firingAngle = firingSolution.x;
				//requiredGunPrecision = firingSolution.y;
				bulletEnergy = firingSolution.y;
				firingAngle = Utils.normalRelativeAngle( firingAngle - fbot.pos.angleTo( enemy.pos ) ); // relative to HoT
				if ( Double.isNaN(firingAngle) ) {
					firingAngle = 0;
					bulletEnergy = Double.NaN; // we should not fire such bullet
				}

				String gunName = "shieldGun";
				bestGunName = gunName;
				fSols.put(gunName, firingAngle);
			}
		}

		// gun Rotation
		double futureGunFiringAngle =  Utils.normalRelativeAngle( gameAngleToCartesian(getGunHeadingRadians()) - fbot.pos.angleTo( targetFuturePos ) ); // with respect to HoT
		double remainGunTurn = firingAngle - futureGunFiringAngle;
		setTurnGunLeftRadians(1.0 * remainGunTurn);
	}

	public class FiringSolutionsSet {
		double [] coord = null;  // tree coordinate used for calculation
		public HashMap<String, Double> fSols= new HashMap<String, Double>(); // map of gun names to firing angles
	}


	public FiringSolutionsSet calcFiringSolutions( botStatus bot, botStatus enemy, double bulletEnergy) {
		FiringSolutionsSet fullSetOfFiringSolutions = new FiringSolutionsSet();
		double[] coord = bot.treeCoord( enemy, bulletEnergy );
		fullSetOfFiringSolutions.coord = coord;
		boolean isSequentialSorting = true;
		double maxExcapeAnge = maxEscapeAngleForSpeed(Rules.getBulletSpeed( bulletEnergy ));
		double halfBotAngularSize = 25/bot.pos.dist( enemy.pos );
		int Nbins = (int) Math.ceil( 2*maxExcapeAnge/ halfBotAngularSize * 3.5);

		HashMap<String, Double> fSols = new HashMap<String, Double>();
		fullSetOfFiringSolutions.fSols = fSols;

		// kd-tree guns
		KDTree.WeightedManhattan<Hit> tree;
		tree =  hitsByMeTree;
		if (myWaveCnt > 100) {
			//tree =  realWaveHitsByMeTree;
		}
		int nn = (int) (10 + Math.sqrt( tree.size()));
		ArrayList<KDTree.SearchResult<Hit>> cluster = tree.nearestNeighbours( coord, nn);

		for(Gun _gun : gunMap.values() ) {
			_gun.addToMap(fSols, coord, cluster, maxExcapeAnge, Nbins);
		}

		return fullSetOfFiringSolutions;
	}

	public class Gun implements Comparable<Gun> {
		String name = "DefaultGun"; 
		boolean tunable = false;
		boolean fast = true; // is this gun fast to produce firingAngle?
		GunStats stats = new GunStats();
		KDTree.WeightedManhattan<Hit> tree = null;
		TargetingWeights tw = null;

		public Gun() { this("HoT", false); }
		public Gun(String _name, boolean _tunable) {
			name = _name;
			tunable = _tunable;
		}
		public Gun(Gun g) {
			this.name = g.name;
			this.tunable = g.tunable;
			this.fast    = g.fast;
			this.stats = new GunStats(g.stats);  // cloning values
			this.tree = g.tree;
			this.tw   = new TargetingWeights(g.tw); // cloning values
		}
		public void mutate() {
			double changeProbability =.3;
			double sign = 1;
			if ( Math.random() > changeProbability ){
				if ( Math.random() > 0.5 ){ sign = 1;} else {sign=-1;}
				tw.realWave_realHit += sign*0.1;
			}
			if ( Math.random() > changeProbability ){
				if ( Math.random() > 0.5 ){ sign = 1;} else {sign=-1;}
				tw.realWave_virtualHit += sign*0.1;
			}
			if ( Math.random() > changeProbability ){
				if ( Math.random() > 0.5 ){ sign = 1;} else {sign=-1;}
				tw.virtualWave_virtualHit += sign*0.1;
			}
			if ( Math.random() > changeProbability ){
				if ( Math.random() > 0.5 ){ sign = 1;} else {sign=-1;}
				tw.timeDecay *= Math.pow(2, sign);
			}
			if ( Math.random() > changeProbability ){
				if ( Math.random() > 0.5 ){ sign = 1;} else {sign=-1;}
				tw.smoothingFactor *= Math.pow(2, sign);
			}
			if ( Math.random() > changeProbability ){
				if ( Math.random() > 0.5 ){ sign = 1;} else {sign=-1;}
				tw.distScale *= Math.pow(2, sign);
			}
		}
		public String getName() {
			String out = this.name;
			//out += "{tunable="+tunable+"}";
		   	return out;
	   	}
		public String toString(){
			String out = this.name;
			out += "{tunable="+tunable+ ", fast="+fast+"}";
			return out;
		}
		double getFiringAngle() {
			return 0; // head on targeting HoT
		}
		double getFiringAngle(double[] coord) {
			return getFiringAngle(); // head on targeting HoT
		}
		double getFiringAngle(double[] coord, ArrayList<KDTree.SearchResult<Hit>> cluster) {
			return getFiringAngle(coord); 
		}
		double getFiringAngle(double[] coord, ArrayList<KDTree.SearchResult<Hit>> cluster, double maxExcapeAnge, int Nbins) {
			return getFiringAngle(coord, cluster);
		}
		void addToMap(HashMap<String, Double> map, double[] coord, ArrayList<KDTree.SearchResult<Hit>> cluster, double maxExcapeAnge, int Nbins) {
			double fA = getFiringAngle(coord, cluster, maxExcapeAnge, Nbins);
			if (!Double.isNaN(fA)) {
				map.put( this.getName(), fA);
			}
		}
		public int compareTo(Gun g) {
			return stats.compareTo(g.stats);
		}
	}

	public class LinearGun extends Gun {
		public LinearGun() { name = "LinearGun"; }

		double getFiringAngle(double[] coord) {
			double vLat = coord[name2ind.get("lateralVelocity")];
			double bulletEnergy = coord[name2ind.get("bulletEnergy")];
			return linearGunAngle( vLat, Rules.getBulletSpeed( bulletEnergy ) );
		}
	}

	public class KDTreeGun extends Gun {
		public KDTreeGun() { super("KDTreeGun", true); }
		public KDTreeGun(String _name, TargetingWeights _tw) {
			this();
		   	name = _name;
			tw =new TargetingWeights(_tw);
			fast = false;
	   	}
		public KDTreeGun(Gun g) {
			super(g);
		}
		public String getName(){
			String out = super.getName();
			out += tw.toString();
			return out;
		}
		public String toString(){
			String out = super.toString();
			out += tw.toString();
			return out;
		}
		double getFiringAngle(double[] coord, ArrayList<KDTree.SearchResult<Hit>> cluster, double maxExcapeAnge, int Nbins) {
			double firingAngle = calcFiringAngleFromClusterForTargetWeight( cluster, tw, maxExcapeAnge, Nbins);
			return firingAngle;
		}
	}

	public class RandomGun extends Gun {
		public RandomGun() { name = "RandomGun"; }

		double getFiringAngle(double[] coord) {
			double bulletEnergy = coord[name2ind.get("bulletEnergy")];
			double maxExcapeAnge = maxEscapeAngleForSpeed(Rules.getBulletSpeed( bulletEnergy ));
			return 2*(Math.random()-0.5)*maxExcapeAnge;
		}
	}

	public class SmartRandomGun extends RandomGun {
		public SmartRandomGun() { name = "SmartRandomGun"; }

		double getFiringAngle(double[] coord, ArrayList<KDTree.SearchResult<Hit>> cluster) {
			// smart random gun calculate maximum escape angle based on observed points
			// than fire somewhere in between
			if  (cluster.size() > 10 ) {
				double minEA=Double.POSITIVE_INFINITY;
				double maxEA=Double.NEGATIVE_INFINITY;
				for ( KDTree.SearchResult<Hit> hitEntry : cluster ) {
					if (minEA > hitEntry.payload.hitAngleRange.leftEnd) {
						minEA = hitEntry.payload.hitAngleRange.leftEnd;
					}
					if (maxEA < hitEntry.payload.hitAngleRange.rightEnd) {
						maxEA = hitEntry.payload.hitAngleRange.rightEnd;
					}
				}
				firingAngle = minEA+Math.random()*(maxEA - minEA);
			} else {
				firingAngle = Double.NaN;
			}
			return firingAngle;
		}
	}

	public double[] clusterWeights(
			ArrayList<KDTree.SearchResult<Hit>> cluster, TargetingWeights tw
	) {
		// weights
		double[] weights = new double[cluster.size()]; // distance from location
		double[] timeW   = new double[cluster.size()]; // distance in time
		double[] waveHitW= new double[cluster.size()]; // distance virtual/real wave/hit
		for (int i=0; i< cluster.size(); i++) {
			KDTree.SearchResult<Hit> hitEntry = cluster.get(i);
			weights[i] =  - hitEntry.distance*tw.distScale;
			timeW[i] =  hitEntry.payload.hitTime/tw.timeDecay;
			double hitWeight = 1;
			if (hitEntry.payload.isWaveReal) { 
				if ( hitEntry.payload.isReal ) {
					hitWeight *= tw.realWave_realHit;
				} else {
					hitWeight *= tw.realWave_virtualHit;
				}
			} else {
				if ( hitEntry.payload.isReal ) {
					dbg("Error: real hit cannot be on virtual wave");
				} else {
					hitWeight *= tw.virtualWave_virtualHit;
				}
			}
			waveHitW[i] = hitWeight;
		}
		softMax( weights );
		softMax( timeW );
		for (int i=0; i< cluster.size(); i++) {
			weights[i] *= timeW[i]*waveHitW[i];
		}
		return weights;
	}

	public double[] cluster2hitBinProbabilty(
			ArrayList<KDTree.SearchResult<Hit>> cluster, TargetingWeights tw,
			double maxExcapeAnge, int Nbins
	) {
		double[] weights = clusterWeights( cluster, tw );
		double[] hitProb = new double[Nbins];
		for (int i=0; i< cluster.size(); i++) {
			KDTree.SearchResult<Hit> hitEntry = cluster.get(i);
			int binL = xToBinInRange(hitEntry.payload.hitAngleRange.leftEnd, -maxExcapeAnge, maxExcapeAnge, Nbins);
			int binR = xToBinInRange(hitEntry.payload.hitAngleRange.rightEnd, -maxExcapeAnge, maxExcapeAnge, Nbins);
			for (int bin = binL; bin<=binR; bin++) {
				hitProb[bin] += weights[i];
			}
		}
		//dbg( arrayToTextPlot(hitProb) + " <--- before smoothing firing angle weights");
		hitProb = smoothWaveDanger( hitProb, tw.smoothingFactor); 
		//dbg( arrayToTextPlot(hitProb) + " <--- firing angle weights");
		return hitProb;
	}

	public double calcFiringAngleFromClusterForTargetWeight(
			ArrayList<KDTree.SearchResult<Hit>> cluster, TargetingWeights tw,
			double maxExcapeAnge, int Nbins
			) {
		// this KdTree nearest neighbors giving most probable firing angle
		// in firing angles distributions
		if  (cluster.size() != 0 ) {
			//dbg("===================================");
			//dbg("cluster size = " + cluster.size() + " tree size = " + tree.size());
			//dbg("coord: " + Arrays.toString(coord) );
			double[] hitProb = cluster2hitBinProbabilty( cluster, tw, maxExcapeAnge, Nbins);

			ArrayStats stats = new ArrayStats( hitProb );
			int bestBin = stats.maxBin;
			firingAngle = binToXInRange( bestBin, -maxExcapeAnge, maxExcapeAnge, Nbins);

			/* tui debug for firing solutions
			double[] hitChoice = new double[Nbins];
			hitChoice[bestBin] = 1;
			dbg( arrayToTextPlot(hitProb) + " <--- firing angle weights");
			dbg( arrayToTextPlot(hitChoice) + " <--- firing angle choice");
			*/
		} else {
			//dbg("cluster is empty");
			firingAngle = 0;
		}
		return firingAngle;
	}

	public double[] smoothWaveDanger(double[] danger, double spreadFraction) {
		// spread fraction tells the fraction of the bins to which danger spills
		int Nbins = danger.length;
		double dw = Math.max(0.01, spreadFraction*Nbins);
		double[] smoothedDanger = new double[Nbins];
		//dbg( arrayToTextPlot(danger) + " before smoothing");
		for (int i=0; i< Nbins; i++) {
			double hitWeight = danger[i];
			for (int k= 0; k<=4*dw; k++) {
				double hitSpreadWeight = 1.0/(1.0+1.0*k*k/dw/dw);
				if ((i-k) >= 0 )   smoothedDanger[i-k] += hitWeight*hitSpreadWeight;
				if (k==0) continue;
				if ((i+k) < Nbins) smoothedDanger[i+k] += hitWeight*hitSpreadWeight;
			}
		}
		//dbg( arrayToTextPlot(smoothedDanger) + " after smoothing");
		return smoothedDanger;
	}

		public Point counterBulletFiringAngle(Wave enemyWave, double enemyBulletHeading, Wave counterFireWave) {
			// we will use point to get firing angle and precision
			Point firingSolution = new Point(Double.NaN,0); 
			enemyBulletHeading += enemyWave.source.pos.angleTo( enemyWave.target.pos ); // adding HoT angle
			dbg("enemyBulletHeading = " + enemyBulletHeading);
			Point enemyBulletPosition = new Point ( enemyWave.source.pos );
			Point bulletVelocity = new Point(0,0);
		   	bulletVelocity.addPolarVec(enemyWave.getSpeed(), enemyBulletHeading); 
			long gapTime = counterFireWave.source.time - enemyWave.source.time;
			if ( gapTime < 0 ) {
				dbg("ERROR: do not know yet how to counter fire before enemy fired");
				return firingSolution;
			}
			// let's calculate where is the bullet at the counter fire time
			while ( gapTime > 0 ) {
				gapTime--;
				enemyBulletPosition.add ( bulletVelocity );
			}
			if ( enemyWave.getDistTo(enemyBulletPosition) > enemyWave.getDistTo(counterFireWave.source.pos) ) {
				dbg("WARNING: this wave is behind us already, no need to fire at it");
				return firingSolution;
			}
			int maxCnt = 100;
			for (long i = 1; i <= maxCnt; i++) {
				enemyBulletPosition.add ( bulletVelocity );
				if ( enemyWave.getDistTo(enemyBulletPosition) > enemyWave.getDistTo(counterFireWave.source.pos) ) {
					dbg("WARNING: this wave is behind us already, no need to fire at it");
					return firingSolution;
				}
				double overShotDist = i*counterFireWave.getSpeed() - counterFireWave.getDistTo( enemyBulletPosition );
				if ( overShotDist > 0 ) {
					// our wave just crossed the enemy bullet
					double overShotTime = overShotDist/counterFireWave.getSpeed();
					Point idealInterseptPoint = new Point( enemyBulletPosition );
					idealInterseptPoint.x -= bulletVelocity.x * 0.5; // half a step back
					idealInterseptPoint.y -= bulletVelocity.y * 0.5;
					double firingAngle = counterFireWave.source.pos.angleTo( idealInterseptPoint );
					double idealInterceptingBulletSpeed = counterFireWave.source.pos.dist( idealInterseptPoint )/ (i-0.5);
					dbg("ideal speed is = " + idealInterceptingBulletSpeed + " current is " + counterFireWave.getSpeed() + " travel time " + i + " intercept time is " + (counterFireWave.source.time + i) );
					double idealInterceptingBulletEnergy = (20 - idealInterceptingBulletSpeed)/3.0;
					dbg("required energy for bullet " + idealInterceptingBulletEnergy);
					double realisticInterceptingBulletEnergy = putInRange( idealInterceptingBulletEnergy, Rules.MIN_BULLET_POWER, Rules.MAX_BULLET_POWER);
					double realisticInterceptingBulletSpeed = Rules.getBulletSpeed(realisticInterceptingBulletEnergy);
					dbg("adjusted energy " + realisticInterceptingBulletEnergy);
					double bulletCentersMismatch = Math.abs(idealInterceptingBulletSpeed - Rules.getBulletSpeed(realisticInterceptingBulletEnergy) )*(i-0.5);
					dbg("bulletCentersMismatch " + bulletCentersMismatch + " for bullet speed " + Rules.getBulletSpeed( realisticInterceptingBulletEnergy ));
					if ( bulletCentersMismatch > realisticInterceptingBulletSpeed/4) {
						// we have not find good solution
						dbg("WARNING: the intercepting solution is likely to miss, discarding it");
						return firingSolution; 
					}

					firingSolution.x = firingAngle;
					firingSolution.y = realisticInterceptingBulletEnergy;
					return firingSolution;
				}
			}

			dbg("WARNING: could not intercept the enemy wave with heading angle " + enemyBulletHeading );
			return firingSolution;
		}

	public void onBulletHit(BulletHitEvent event) {
		time = getTime();
		// master bot hit someone
		hitBulletCnt++;
		//dbg("my hit ratio " + hitBulletCnt + "/" + firedBulletCnt + " = " + String.format( "%.1f", 100.0*hitBulletCnt/firedBulletCnt) + " %");
		//printStats();
		// let's account for this energy change in enemy
		Bullet bullet = event.getBullet();
		double enemyEnergyChange = 4*bullet.getPower();
		enemyEnergyChange += (bullet.getPower() > 1) ? 2*( bullet.getPower() -1 ) : 0;
		//dbg( "tic: " + time + " enemy lost " + enemyEnergyChange + " due to master bot fire");
	    enemy.energy -= enemyEnergyChange;

		boolean isTrueHit = true;
		boolean hitWaveFound = false;
		Point pos = new Point(bullet.getX(),bullet.getY());
		for (int i = 0; i < myWaves.size(); i++) {
			Wave w = (Wave) myWaves.get(i);
			if ( !w.isReal ) { continue; }
			if ( w.isCrossing( pos ) ) {
				//dbg("wave fired at time " + w.source.time + " crosses bot " + enemy.name);
				hitWaveFound = true;
				registerHitOnMyWave(w, enemy.pos, isTrueHit);
			}
		}
		if (!hitWaveFound) {
			dbg("SHAME: did not find wave containing bullet at tic " + time);
		}
	}

	public void onHitByBullet(HitByBulletEvent event) {
		time = getTime();
		// master bot was hit by someone
		enemyHitBulletCnt++;
		//dbg("enemy hit ratio " + enemyHitBulletCnt + "/" + enemyFiredBulletCnt + " = " + String.format( "%.1f", 100.0*enemyHitBulletCnt/enemyFiredBulletCnt) + " %");
		//printStats();
		// let's find which wave hits me
		Wave wHit = null;
		Bullet bullet = event.getBullet();
		// account for enemy energy gain
		double enemyEnergyChange = 3*bullet.getPower();
	    enemy.energy += enemyEnergyChange;
		//dbg( "tic: " + time + " enemy gain " + enemyEnergyChange + " due to its successful fire, enemy energy now " + enemy.energy);
		Point hitLocation = new Point( bullet.getX(), bullet.getY() );
		wHit = findRealWaveClosestToPoint( hitLocation, bullet.getPower() );
		if ( wHit != null) {
			// update hit stats
			wHit.isReal = true;
			boolean isTrueHit = true;
			registerHitOnEnemyWave( wHit, hitLocation, isTrueHit);
			updateEnemyWavesDanger();
		}
	}

	public void onBulletHitBullet(BulletHitBulletEvent event) {
		time = getTime();
		// ("bullets intersection detected");
		bulletHitBulletCnt[getRoundNum()]++;
		Wave wHit = null;
		Bullet bullet = event.getHitBullet(); // enemy bullet
		Bullet myBullet = event.getBullet(); // enemy bullet
		// TODO this is approximation of the intersection location 
		// but this is ok for hitAngle detection
		Point hitLocation = new Point( bullet.getX(), bullet.getY() ); //apparently before bullet advanced on this tic
		wHit = findEnemyRealWaveClosestToBulletHit( bullet, myBullet );
		if ( wHit != null) {
			// update hit stats
			wHit.isReal = true;
			boolean isTrueHit = true;
			registerHitOnEnemyWave( wHit, hitLocation, isTrueHit);
			// now let's make this wave virtual
			// so we do not act against a wave with no bullet
			wHit.isReal = false;
			updateEnemyWavesDanger();
		}
		// TODO remove/make virtual hit wave from the master bot waves
	}

	public void updateEnemyWavesDanger() {
		for (int i = 0; i < enemyWaves.size(); i++) {
			Wave w = (Wave) enemyWaves.get(i);
			assignWaveDanger(w);
		}
	}

	public Wave findEnemyRealWaveClosestToBulletHit( Bullet enemyBullet, Bullet bullet) {
		Point hitLocation = new Point( enemyBullet.getX(), enemyBullet.getY() ); //apparently before bullet advanced on this tic
		Wave wHit = null;
		double closestWaveDist = Double.POSITIVE_INFINITY;
		for (int i = 0; i < enemyWaves.size(); i++) {
			Wave w = (Wave) enemyWaves.get(i);
			if ( !w.isReal ) { continue; }
			//dbg("dist from wave to hitLocation is " +w.getSurfingDistanceTo( hitLocation ) );
			//dbg( "wave bullet " + w.bulletEnergy + " struck bullet " + bullet.getPower() );
			if ( ! Utils.isNear(w.bulletEnergy, enemyBullet.getPower()) ) {
				continue;
			}
			double d = Math.abs( w.getSurfingDistanceTo( hitLocation ) );
			if ( d < closestWaveDist ) {
				closestWaveDist = d;
				wHit = w;
			}
		}
		if ( closestWaveDist > 2*19.7 ) {  // 19.7 is maximum bullet speed
			dbg("Code imperfection detected: ==================");
			dbg("Shame on me. Could not find enemy wave which struck my bullet at  " + hitLocation);
			if ( wHit != null ) {
				dbg( "wave bullet " + wHit.bulletEnergy + " struck bullet " + bulletEnergy );
				dbg("The closest surf of the wave is at distance " + closestWaveDist );
			}
			dbg("==============================================");
			wHit = null;
		}
		return wHit;
	}

	public Wave findRealWaveClosestToPoint( Point hitLocation, double bulletEnergy ) {
		Wave wHit = null;
		double closestWaveDist = Double.POSITIVE_INFINITY;
		for (int i = 0; i < enemyWaves.size(); i++) {
			Wave w = (Wave) enemyWaves.get(i);
			if ( !w.isReal ) { continue; }
			//dbg("dist from wave to hitLocation is " +w.getSurfingDistanceTo( hitLocation ) );
			//dbg( "wave bullet " + w.bulletEnergy + " struck bullet " + bullet.getPower() );
			if ( ! Utils.isNear(w.bulletEnergy, bulletEnergy) ) {
				continue;
			}
			double d = Math.abs( w.getSurfingDistanceTo( hitLocation ) );
			if ( d < closestWaveDist ) {
				closestWaveDist = d;
				wHit = w;
			}
		}
		if ( closestWaveDist > 25 ) { // bot diagonal
			dbg("Code imperfection detected: ==================");
			dbg("Shame on me. Could not find enemy wave which struck me at " + hitLocation);
			if ( wHit != null ) {
				dbg( "wave bullet " + wHit.bulletEnergy + " struck bullet " + bulletEnergy );
				dbg("The closest surf of the wave is at distance " + closestWaveDist );
			}
			dbg("==============================================");
			wHit = null;
		}
		return wHit;
	}

	public void onRoundEnded(RoundEndedEvent event) {
		time = getTime();
		// RoundEndedEvent has priority higher than WinEvent or DeathEvent
		// so we cannot use it to print unifying stats :(, stats would be one round late
		//dbg("Round ended at " + time);
		//printStats();
	}

	public void onWin(WinEvent event) {
		time = getTime();
		winCnt++;
		isRoundOver = true;
		//dbg("Master bot win the round at " + time);
		//printStats();
	}
	public void onDeath(DeathEvent event) {
		time = getTime();
		isRoundOver = true;
		//dbg("Master bot loose the round at " + time);
		//printStats();
	}

	public void printStats() {
		double[] hitRatios = {1.0*hitBulletCnt/firedBulletCnt, 0,  1.0*enemyHitBulletCnt/enemyFiredBulletCnt};
		String out = "";
		out += "hit ratios my vs enemy: " + arrayToTextPlot(hitRatios) ;
		out += "  ";
		out += "my hit ratio " + hitBulletCnt + "/" + firedBulletCnt + " = " + String.format( "%.1f", 100.0*hitBulletCnt/firedBulletCnt) + " %";
		out += "  ";
		out += "enemy hit ratio " + enemyHitBulletCnt + "/" + enemyFiredBulletCnt + " = " + String.format( "%.1f", 100.0*enemyHitBulletCnt/enemyFiredBulletCnt) + " %";
		ArrayList<Map.Entry<String,Gun>> lGuns = new ArrayList<>(gunMap.entrySet());
		lGuns.sort(Map.Entry.comparingByValue()); // sort by gun hitRatio
		//lGuns.sort(Map.Entry.comparingByKey()); // sort by gun name
		boolean firstTime = true;
		for( Map.Entry<String,Gun> entry : lGuns ) {
			GunStats _gs = entry.getValue().stats;
			out += "\n";
			out += _gs.toString(firstTime);
			out += " " + entry.getKey();
			firstTime = false;
		}
		//
		out += "\n";
		out += "Counts of not found matching firing solution: " + Arrays.toString(notMatchedFiringSolutionCnt);
		out += "\n";
		out += "Counts of not firing when gun is cold       : " + Arrays.toString(notFiredWhenCold);
		out += "\n";
		out += "Counts of bullet hit bullet                 : " + Arrays.toString(bulletHitBulletCnt);
		out += "\n";
		out += "Win ratio " + winCnt + "/" + (1+getRoundNum());
	
		dbg( out );
		//dbg("my hits tree size " + hitsByMeTree.size() );
		//dbg("enemy hits tree size " + hitsByEnemyTree.size() );
	}

	public void addEnemyWave( botStatus enemy, double bulletEnergy, boolean isReal ) {
		// enemy is status at time of the fire detection 
		// according to robocode physics this is 2 tics later
		// after actual fire
		// see robocode physics
		// http://robowiki.net/wiki/Robocode/Game_Physics
		//dbg("detected enemy " + enemy.name + " fire at time " + time + " with bullet energy " + bulletEnergy);
		Wave w = new Wave();
		enemyWaveCnt++;
		w.count = enemyWaveCnt;
		w.isReal = isReal;
		if ( w.isReal ) enemyFiredBulletCnt++;
		w.source = enemy;
		if ( enemy.prev != null ) {
			w.source = enemy.prev;
		}
		w.target = bot;
		if ( bot.prev != null ) {
			w.target = bot.prev;
			if ( bot.prev.prev != null ) {
				w.target = bot.prev.prev;
			}
		}
		w.bulletEnergy = bulletEnergy;
		lastEnemyBulletEnergy=w.bulletEnergy;
		enemyWaves.add(w);

		assignWaveDanger(w);
		if (w.isReal) {
			// add safety corridors from the flying waves of master bot 
			for (Wave mW: myWaves ) {
				w.addSafetyCorridorFromWave(mW);
			}
		}

		//if ( w.isReal ) {
		//dbg( Arrays.toString(w.waveDanger));
		//dbg( arrayToTextPlot(w.waveDanger));
		//}
	}

	public void assignWaveDanger( Wave w ) {
		// wave danger
		double[] coord = w.coord;
		if (coord == null) {
			coord = w.source.treeCoord( w.target, w.bulletEnergy );
			w.coord = coord;
		}
		double maxExcapeAnge = maxEscapeAngleForSpeed(w.getSpeed());
		double distToTarget = w.source.pos.dist( w.target.pos );
		double halfBotAngularSize = 25.0/distToTarget;
		int Nbins = (int) Math.ceil( 2*maxExcapeAnge/ halfBotAngularSize * 3.5);
		w.waveDanger = new double[Nbins];
		w.Nbins=Nbins;

		boolean isSequentialSorting = true;
		double enemyHitRate = 1.0 * enemyHitBulletCnt / (enemyFiredBulletCnt+1);
		//KDTree.WeightedManhattan<Hit> tree = hitsByEnemyTree;
		//KDTree.WeightedManhattan<Hit> tree = realWaveHitsByEnemyTree;
		KDTree.WeightedManhattan<Hit> tree = realHitsByEnemyTree;

		TargetingWeights tw = new TargetingWeights();
		//if ( false ) {
		if ( enemyHitRate < .10 || enemyFiredBulletCnt < 40 ) {
			// This is anti fixed gun measure, i.e. HoT, linear, circular, etc
			tw.realWave_realHit = 1; tw.realWave_virtualHit = 0;
			tw.virtualWave_virtualHit = 0;
			tw.timeDecay = Double.POSITIVE_INFINITY;
			tw.smoothingFactor = halfBotAngularSize/maxExcapeAnge/5;
			tw.distScale = 1; // all nearest neighbors are equal weight
		} else {
			// enemy likely to use GF stats
			tw.realWave_realHit = 1; tw.realWave_virtualHit = 0.1;
			tw.virtualWave_virtualHit = 0;
			//tw.timeDecay = Double.POSITIVE_INFINITY;
			tw.timeDecay = 1000;
			tw.smoothingFactor = halfBotAngularSize/maxExcapeAnge/5;
			tw.distScale = 1; // all nearest neighbors are equal weight
		}

		//int nn = (int) (100 + Math.sqrt( tree.size()));
		int nn = (int) (10 + Math.sqrt( tree.size()));
		ArrayList<KDTree.SearchResult<Hit>> cluster = tree.nearestNeighbours( coord, nn);
		double[] hitProb = new double[Nbins];
		if  (cluster.size() != 0 ) {
			//dbg("===================================");
			//dbg("cluster size = " + cluster.size() + " tree size = " + tree.size());
			//dbg("coord: " + Arrays.toString(coord) );
			hitProb = cluster2hitBinProbabilty( cluster, tw, maxExcapeAnge, Nbins);
			normSumTo1InPlace(hitProb);
			//dbg( arrayToTextPlot(hitProb) + " <--- kdTree enemy wave danger weights");
		}

		// reflected tree coordinates
		botStatus bS = new botStatus();
		double[] reflCoord = bS.treeCoordReflected(coord);
		TargetingWeights twRefl = new TargetingWeights();
		double scale = 0.4;
		twRefl.realWave_realHit = scale* tw.realWave_realHit;
		twRefl.realWave_virtualHit = scale* tw.realWave_virtualHit;
		twRefl.virtualWave_virtualHit = scale* tw.virtualWave_virtualHit;
		twRefl.timeDecay = tw.timeDecay;
		twRefl.smoothingFactor = tw.smoothingFactor;
		twRefl.distScale = tw.distScale;
		cluster = tree.nearestNeighbours( reflCoord, nn);
		double[] reflHitProb = new double[Nbins];
		if  (cluster.size() != 0 ) {
			//dbg("===================================");
			//dbg("cluster size = " + cluster.size() + " tree size = " + tree.size());
			//dbg("coord: " + Arrays.toString(coord) );
			reflHitProb = cluster2hitBinProbabilty( cluster, twRefl, maxExcapeAnge, Nbins);
			reverseInPlace(reflHitProb);
			normSumTo1InPlace(reflHitProb);
			//dbg( arrayToTextPlot(reflHitProb) + " <--- kdTree reflected enemy wave danger weights");
		}
		double reflWeight = 0.3;
		multiplyByInPlace(hitProb, 1-reflWeight);
		multiplyByInPlace(reflHitProb, reflWeight);
		addInPlace(hitProb, reflHitProb);
		normSumTo1InPlace(hitProb);

		// scaling fixed gun weight should increase with enemyHitRate
		double fixedGunWeight = 0;
		if (enemyHitBulletCnt < 4 ) {
			fixedGunWeight = 0.2;
		} else {
			double d = enemyHitRate/0.025;
			fixedGunWeight = 0.2*Math.exp( - d*d );
		}
		//dbg("fixedGunWeight = " + fixedGunWeight);
		multiplyByInPlace(hitProb, 1-fixedGunWeight);

		// calculating fixed linear gun danger
		double[] linearGunHitProb = new double[Nbins];
		double lgAngle=linearGunAngle(coord[name2ind.get("lateralVelocity")], w.getSpeed());
		int linGunBin = xToBinInRange(lgAngle, -maxExcapeAnge, maxExcapeAnge, Nbins);
		linearGunHitProb[linGunBin] = 1;
		double[] linGunHitProb = smoothWaveDanger( linearGunHitProb, 8*halfBotAngularSize/maxExcapeAnge/5); 
		normSumTo1InPlace(linGunHitProb);
		multiplyByInPlace(linGunHitProb, fixedGunWeight);

		// adding it all together
		w.waveDanger = hitProb;
		addInPlace(w.waveDanger, linGunHitProb);
		//dbg( arrayToTextPlot(w.waveDanger) + " <--- Final enemy wave danger weights");
	}

	double linearGunAngle(double latVel, double bulletSpeed) {
			return Math.asin(latVel/bulletSpeed);
	}

	public class TargetingWeights {
		public double 
			 realWave_realHit = 1, realWave_virtualHit = 1,
			 virtualWave_virtualHit = 1,
			 // note: virtualWave_realHit is actually impossible
			 timeDecay = Double.POSITIVE_INFINITY,
			 smoothingFactor = 0.1,
		     distScale = 1.0; // how to scale distances in KDTree

		public TargetingWeights() {}
		public TargetingWeights(TargetingWeights tw) {
			// cloning input tw
			realWave_realHit    = tw.realWave_realHit;
			realWave_virtualHit = tw.realWave_virtualHit;
			virtualWave_virtualHit = tw.virtualWave_virtualHit;
			timeDecay           = tw.timeDecay;
			smoothingFactor     = tw.smoothingFactor;
			distScale           = tw.distScale;
		}

		public String toString() {
			String out = "";
		   	out += "{";
		   	out += "WH=" + realWave_realHit;
			out += " Wh=" + realWave_virtualHit;
			out += " wh=" + virtualWave_virtualHit;
			out += " tD=" + timeDecay;
			out += " smth=" + smoothingFactor;
			out += " distScale=" + distScale;
		   	out += "}";
			return out;
		}
	}

	public int xToBinInRange( double x, double lowEnd, double hiEnd, int Nbins ) {
		if (lowEnd > hiEnd ) {
			double tmp = hiEnd;
			hiEnd = lowEnd;
			lowEnd = tmp;
		}
		if ( x <=lowEnd ) return 0;
		if ( x >= hiEnd  ) return (Nbins - 1);
		double range = hiEnd - lowEnd;
		return (int) Math.round((x-lowEnd)/range*(Nbins - 1));
	}

	public double binToXInRange( int bin, double lowEnd, double hiEnd, int Nbins ) {
		if (lowEnd > hiEnd ) {
			double tmp = hiEnd;
			hiEnd = lowEnd;
			lowEnd = tmp;
		}
		if ( bin <= 0 ) return lowEnd;
		if ( bin >= (Nbins -1) ) return hiEnd;
		double range = hiEnd - lowEnd;
		return lowEnd + range*bin/(Nbins -1);
	}

	public static String arrayToTextPlot( double[] bins) {
		// outputs text style/plot histograms
		// inspired by https://github.com/holman/spark
		String ticks = "▁▂▃▄▅▆▇█";
		int ticksNum = 8;
		double bMax = Double.NEGATIVE_INFINITY;
		double bMin = Double.POSITIVE_INFINITY;
		int ind;
		double b;
		for (int i=0; i < bins.length; i++) {
			// find stats
			b=bins[i];
			if ( b > bMax)
				bMax = b;
			if ( b < bMin)
				bMin = b;
		}
		String sout = "";
		double range = bMax - bMin;
		if ( range==0 )
			range = 1;
		for (int i=0; i < bins.length; i++) {
			// normalize
			b=(bins[i]-bMin)/range;
			ind = (int) Math.floor( b*ticksNum );
			if ( ind == ticksNum )
				ind = ticksNum - 1;
			sout += ticks.charAt(ind);
		}
		sout += " With range from " + bMin + " to " + bMax;
		return sout;
	}
	public static void dbg( Object str ) {
		System.out.println( str );
	}
	public void log( String str ) {
		if ( fileWriter != null ) {
			try {
				str = str + "\n";
				fileWriter.write(str);
				fileWriter.flush();
			} catch (IOException ioe) {
				System.out.println("Trouble writing to the log file: " + ioe.getMessage());
			}
		} else {
			//System.out.println("The log file writer does not exist");
		}
	}

	public class Point extends Point2D.Double {
		//double x=0;
		//double y=0;

		public Point() {x=0; y=0;}
		public Point( double xs, double ys) {x=xs; y=ys;}
		public Point( Point pOther) {x=pOther.x; y=pOther.y;}

		public String toString() { return ("P=( " + x +", " + y + " )"); };
		public double dist(Point p) {
			double dx = x - p.x;
			double dy = y - p.y;
			return Math.sqrt(dx*dx+dy*dy);
		}
		public Point vectorToTarget(Point p) {
			Point vec = new Point();
			vec.x = p.x-x;
			vec.y = p.y-y;
			return vec;
		}
		public double angleTo(Point p) {
			double dx = p.x - x;
			double dy = p.y - y;
			return Math.atan2( dy, dx);
		}
		public double angle() {
			// gives its own direction angle
			Point origin = new Point();
			return origin.angleTo( this );
		}
		public double scalarProduct(Point p) {
			return ( x*p.x + y*p.y );
		}
		public double vectorProduct(Point p) {
			// self x p
			return ( x*p.y - y*p.x );
		}
		public double length() {
			return dist( new Point() );
		}
		public Point rotateBy(double a) {
			// rotate vector presented in this point by angle a
			double s=Math.sin(a);
			double c=Math.cos(a);
			double xo = x;
			double yo = y;
			x=c*xo - s*yo;
			y=s*xo + c*yo;
			return this;
		}
		public Point add(Point p) {
			// add vector presented by point p
			x+=p.x;
			y+=p.y;
			return this;
		}
		public Point addPolarVec(double r, double angle) {
			// add vector presented by point p
			x+=r*Math.cos( angle );
			y+=r*Math.sin( angle );
			return this;
		}
		public double lateralVelocityOf(botStatus target) {
			// positive means that target is moving CCW
			Point radVec = this.vectorToTarget( target.pos );
			double latVel = radVec.vectorProduct( target.velocity);
			latVel /= radVec.length();
			return latVel;
		}

		public double radialVelocityOf(botStatus target) {
			// positive means that target is moving away
			Point radVec = this.vectorToTarget( target.pos );
			double radVel = radVec.scalarProduct( target.velocity);
			radVel /= radVec.length();
			return radVel;
		}
		public boolean isInsideBox(Point c1, Point c2) {
			// check if point is inside rectangle defined by corners c1 and c2
			return (           ( Math.min( c1.x, c2.x) < x)
					&& ( Math.max( c1.x, c2.x) > x)
					&& ( Math.max( c1.y, c2.y) > y)
					&& ( Math.min( c1.y, c2.y) < y) );
		}

	}

	public static HashMap<String, Integer> name2ind = new HashMap<String, Integer>();
	{
		name2ind.put("distance", 0);
		name2ind.put("lateralVelocity", 1);
		name2ind.put("radialVelocity", 2);
		name2ind.put("bulletEnergy", 3);
		name2ind.put("averageSpeed", 4);
		name2ind.put("ccwMEA", 5);
		name2ind.put("cwMEA", 6);
		name2ind.put("averageRadialVelocity", 7);
		name2ind.put("pastInfo0", 8);
	}

	public class botStatus {
		Point pos = new Point();
		botStatus prev = null;
		double energy = 0;
		double heading = 0;
		double speed = 0;
		double averageSpeed = 0;
		double gunHeat = 0;
		String name = "";
		long time = 0;
		Point velocity = new Point();
		static double[] scale = new double[name2ind.size()];

		public botStatus() {
			scale[name2ind.get("distance")] = 1./1000*10;
			scale[name2ind.get("lateralVelocity")] = 1./8;
			scale[name2ind.get("radialVelocity")] = 1./8/0.2;
			scale[name2ind.get("bulletEnergy")] = 1./3/0.2;
			scale[name2ind.get("averageSpeed")] = 1./8/0.3;
			scale[name2ind.get("ccwMEA")] = 1./0.06;
			scale[name2ind.get("cwMEA")]  = 1./0.06;
			scale[name2ind.get("averageRadialVelocity")]  = 1./8;
			scale[name2ind.get("pastInfo0")]  = 1./0.06;
		}

		double [] treeCoord(botStatus target, double bulletEnergy) {
			double[] coord = new double[name2ind.size()];
			double dist = pos.dist( target.pos );
			coord[name2ind.get("distance")] = dist;
			coord[name2ind.get("lateralVelocity")] = pos.lateralVelocityOf(target);
			coord[name2ind.get("radialVelocity")] = pos.radialVelocityOf(target);
			coord[name2ind.get("bulletEnergy")] = bulletEnergy;
			coord[name2ind.get("averageSpeed")] = Math.abs(target.averageSpeed);
			double bSpeed = Rules.getBulletSpeed( bulletEnergy );
			double ccwMEA = maxRealEscapeAngleForSpeed( bSpeed, this.pos, target.pos, true);
			double  cwMEA = maxRealEscapeAngleForSpeed( bSpeed, this.pos, target.pos, false);
			coord[name2ind.get("ccwMEA")] = ccwMEA;
			coord[name2ind.get("cwMEA")] =  cwMEA;
			// fill coordinate array with info related to several steps back
			int maxStepsBack=10;
			//int[] stepsBackList = {5, 10, 25, maxStepsBack};
			int[] stepsBackList = {maxStepsBack};
			botStatus bsPrev = this;
			botStatus tsPrev = target;
			coord[name2ind.get("averageRadialVelocity")] = bsPrev.pos.radialVelocityOf(tsPrev); // radial velocity averaged
			int backCount = 0;
			for (backCount=0; backCount <= maxStepsBack; backCount++) {
				for(int i=0; i < stepsBackList.length; i++) {
					if ( i <= 10 ) {
						// weighted average of radial velocity
						double alpha = 0.9;
						coord[name2ind.get("averageRadialVelocity")] *= alpha;
						coord[name2ind.get("averageRadialVelocity")] += (1-alpha)*bsPrev.pos.radialVelocityOf(tsPrev);
					}
					// are we at required position 
					if ( stepsBackList[i] == backCount ) {
						coord[name2ind.get("pastInfo0")+i] = Utils.normalRelativeAngle( bsPrev.pos.angleTo(tsPrev.pos)- bsPrev.pos.angleTo( target.pos ) ); // relative to HoT
					}
				}
				if ((bsPrev.prev == null) || (tsPrev.prev == null)) {
					backCount++;
					break;
				}
				bsPrev = bsPrev.prev;
				tsPrev = tsPrev.prev;
			}
			// if we cannot reach required steps back, fill missing info with the furthest known info
			backCount--; // for loop over count by 1
			for(int i=0; i < stepsBackList.length; i++) {
				if ( stepsBackList[i] > backCount ) {
					coord[name2ind.get("pastInfo0")+i] = Utils.normalRelativeAngle( bsPrev.pos.angleTo(tsPrev.pos)- bsPrev.pos.angleTo( target.pos ) ); // relative to HoT
				}
			}
			
			// scale coordinates
			/* do not need it we are using weighted tree
			for(int i=0; i < coord.length; i++) {
				coord[i] *= scale[i];
			}
			*/

			//dbg("coord " +arrayToTextPlot(coord));
			return coord;
		}

		double [] treeCoordReflected(double[] coord) {
			//dbg("treeCoordReflected is not set, avoid me");
			// take in account symmetry with respect to lateral velocity
			double[] reflected_coord = new double[coord.length];
			for (int i=0; i < coord.length; i++) {
				reflected_coord[i] =coord[i];
			}
			reflected_coord[name2ind.get("lateralVelocity")] = - coord[name2ind.get("lateralVelocity")];
			reflected_coord[name2ind.get("pastInfo0")] = - coord[name2ind.get("pastInfo0")];
			reflected_coord[name2ind.get("ccwMEA")] = - coord[name2ind.get("cwMEA")];
			reflected_coord[name2ind.get("cwMEA")] = - coord[name2ind.get("ccwMEA")];
			return reflected_coord;
		}

		public String toString() {
			String str="";
			str += name;
			str += " status at time ";
			str += time;
			str += ":";
			str += " position ";
			str += pos;
			str += ", speed ";
			str += speed;
			str += ", averageSpeed ";
			str += averageSpeed;
			str += ", heading ";
			str += heading;
			str += ", velocity ";
			str += velocity;
			return str;
		}
	}

	public class SurfingInfo {
		public boolean isCalculated = false;
		int safestReachableBin=0;
		Point destinationPoint = null;
	}

	public class Wave {
		Hit hit = null;
		botStatus source = new botStatus();
		botStatus target = new botStatus();
		long count = 0;
		boolean isReal = false; // virtual or real wave
		int Nbins = 31; // keep it odd, so the head-on-angle is the proper bin
		double[] waveDanger = new double[Nbins];
		double bulletEnergy = 0;
		HashMap<String, Double> firingSolutions = null;
		double [] coord = null;  // tree coordinate used for firingSolutions calculation
		public SurfingInfo surfingInfo = new SurfingInfo();
		public ArrayList<Point> safetyCorridors = new ArrayList<Point>();
		public ArrayList<KDTree.WeightedManhattan<Hit>> markedTrees = new ArrayList<>(); // list of trees to which hit is already logged

		public Wave() {
			int gf0bin = (int)((Nbins-1)/2);
			double gf0danger = 0*1e-4;
			double width=Nbins*.2;
			waveDanger[ gf0bin ] = gf0danger; // small danger to head-On-Angle
			for (int i=0; i< Nbins; i++ ) {
				double diff = i-gf0bin;
				diff /= width;
				waveDanger[i] = gf0danger/( 1 + diff*diff);
			}

		}

		void logHitInTree(Hit h, KDTree.WeightedManhattan<Hit> tree){
			// indicate if logged hit to the tree
			if ( markedTrees.contains( tree ) ) {
				return;
			}
			markedTrees.add(tree);
			tree.addPoint(coord, h);
		}

		double getSpeed() {
			return ( 20 - bulletEnergy * 3 );
		}

		double getDistTraveled() {
			long t = time - source.time;
			double dist = t*getSpeed();
			return dist;
		}
		double getDistTraveledAtTime(long timeNow) {
			long t = timeNow - source.time;
			double dist = t*getSpeed();
			return dist;
		}
		double getDistTo(Point p) {
			double dist = source.pos.dist( p);
			return dist;
		}
		double getSurfingDistanceTo(Point p) {
			// positive means that wave already passed the point p
			return getDistTraveled() -  getDistTo( p );
		}
		boolean isOutside() {
			if ( getDistTraveled() >  BattleFieldDiagonal ) {
				return true;
			}
			return false;
		}
		boolean isBehind(botStatus b) {
			if ( getSurfingDistanceTo(b.pos) >  25 ) {
				return true;
			}
			return false;
		}
		boolean isBehindAtTime(botStatus b, long timeNow) {
			if ( (getDistTraveledAtTime(timeNow) - getDistTo( b.pos)) >  25 ) {
				return true;
			}
			return false;
		}
		boolean isCrossing( Point p ) {
			// check the wave crosses a bot at point p 
			if ( Math.abs( getSurfingDistanceTo(p) ) < 18 ) {
				return true;
			}
			return false;
		}
		double hitAngle(Point p) {
			double hit = source.pos.angleTo( p );
			double headOn = source.pos.angleTo( target.pos );
			return Utils.normalRelativeAngle( hit - headOn );
		}
		Range hitAngleRange(Point p) {
			Range hR = new Range();
			double botHW = 18;
			Point [] corners = { new Point(botHW, botHW), new Point(botHW, -botHW), new Point(-botHW, botHW), new Point(-botHW, -botHW)  };
			for( Point pC : corners ) {
				double hA = this.hitAngle(new Point(p).add(pC));
				hR.merge(hA);
			}
			return hR;
		}
		public double firingAngleWithMaxDanger() {
			// relative to HoT direction
			double maxEscapeAngle = maxEscapeAngleForSpeed(getSpeed());
			return binToXInRange( maxBinInArray( waveDanger ), -maxEscapeAngle, maxEscapeAngle, waveDanger.length);
		}
		public Point calcSafetyCorridorFromWave(Wave w) {
			//Point.x is CCW end and Point.y is CW end of safety corridor (sC)
			Point sC = null;
			Point noSolution = null;
			double headOnAngle = w.source.pos.angleTo( w.target.pos );
			if ( w.firingSolutions == null ) return noSolution;
			if ( !w.firingSolutions.containsKey( "realGun" ) ) return noSolution;
			double bulletHeading = headOnAngle + w.firingSolutions.get( "realGun" );

			Point bulletVelocity = new Point(0,0);
		   	bulletVelocity.addPolarVec(w.getSpeed(), bulletHeading); 


			long gapTime = this.source.time - w.source.time;
			long this_delta = 0, w_delta = 0;
			if (gapTime > 0 ) {
				w_delta = gapTime;
			} else {
				this_delta = -gapTime;
			}

			// search for wave interception time
			Point bulletHeadPos;
			double distToBulletHead;
			double thisWaveTravel;
			long maxCnt=100; // max tics to propagate 
			int i=-1;
			do {
				i++;
				bulletHeadPos = new Point(w.source.pos);
				bulletHeadPos.addPolarVec( w.getSpeed()*(w_delta+i), bulletHeading );
				distToBulletHead = this.getDistTo( bulletHeadPos );
				thisWaveTravel = this.getSpeed()*(this_delta+i);
			} while ( distToBulletHead > thisWaveTravel && i < maxCnt );

			// i=0; wave is already behind the bullet
			// i>=maxCnt waves did not crossed within allocated clicks
			if ( i == 0 || i >= maxCnt ) return noSolution;

			// if we are here this wave crosses the other wave bullet within given time

			// very primitive safety corridor assignment
			headOnAngle = this.source.pos.angleTo( this.target.pos );
			double sC_angle1 = this.source.pos.angleTo( bulletHeadPos ) - headOnAngle;
			Point bulletTailPos = new Point(w.source.pos);
			bulletTailPos.addPolarVec( w.getSpeed()*(w_delta+i-1), bulletHeading );
			double sC_angle2 = this.source.pos.angleTo( bulletTailPos ) - headOnAngle;

			sC_angle1 = Utils.normalRelativeAngle( sC_angle1 );
			sC_angle2 = Utils.normalRelativeAngle( sC_angle2 );
			if ( sC_angle1 > sC_angle2 ) {
				sC = new Point(sC_angle1, sC_angle2); 
			} else {
				sC = new Point(sC_angle2, sC_angle1); 
			}
			return sC;
		}

		public double getBotAngularSizeAtPoint(Point p) {
			double dist = getDistTo( p );
			return 2*Math.atan( 25.0/dist);
		}

		public void addSafetyCorridorFromWave( Wave w ) {
			if (!this.isReal) return;
			if (!w.isReal) return;
			Point sC = calcSafetyCorridorFromWave(w);
			if (sC == null) return;
			safetyCorridors.add(sC);

			// if we are adding safety corridor, let's decrease wave danger in it
			double maxEscapeAngle = maxEscapeAngleForSpeed( getSpeed() );
			if ( 
					!isInRange( sC.x, maxEscapeAngle, maxEscapeAngle ) &&
					!isInRange( sC.y, maxEscapeAngle, maxEscapeAngle )
			   )
		   	{
				// at least one end of the safety corridor is within maxEscapeAngle 
				int gfBinMin = xToBinInRange( sC.y, -maxEscapeAngle, maxEscapeAngle, this.waveDanger.length );
				int gfBinMax = xToBinInRange( sC.x, -maxEscapeAngle, maxEscapeAngle, this.waveDanger.length );
				// first, assign 0 danger at the shadow points
				for(int i=gfBinMin; i<= gfBinMax; i++) {
					if (waveDanger[i] > 0) {
						waveDanger[i] *= 0.0;
					}
				}
				// second, smooth it by the bot width
				double[] oldWaveDanger  = waveDanger.clone();
				double botHalfWidth = (int) Math.ceil(getBotAngularSizeAtPoint(target.pos)/(2*maxEscapeAngle)*waveDanger.length/2.0); // in units of bins number
				for(int i=gfBinMin; i<= gfBinMax; i++) {
					for (int k = (int)Math.max(0, i-botHalfWidth); k<(int)Math.min(i+botHalfWidth, waveDanger.length); k++) {
						waveDanger[i] += oldWaveDanger[k]/(2*botHalfWidth);
					}
				}

				
				surfingInfo.isCalculated = false; // we need to update surfing solutions
			}
		}

		public void onPaint(Graphics2D g) {
			// default colors (enemy waves)
			Color colorSafestReachableGF = new Color(0x00, 0xff, 0x00, 0xff);
			Color colorWaveReal    = new Color(0xdd, 0x00, 0x00, 0xff);
			Color colorWaveVirtual = new Color(0x00, 0x00, 0xdd, 0xff);
			if ( source.name.equals( getName() ) ) {
				// colors for my bot waves
				colorWaveReal    = new Color(0xdd, 0xdd, 0x00, 0x80);
				colorWaveVirtual = new Color(0x00, 0x40, 0x40, 0x80);
				return; // do not paint my waves
			}
			Color colorWave = colorWaveReal;
			if ( !isReal ) {
				colorWave = colorWaveVirtual;
				return;
			} else {
				colorWave = colorWaveReal;
			}
			double headOnAngle = source.pos.angleTo( target.pos );
			double distTraveled = (time - source.time)*getSpeed();

			// draw present position
			g.setColor( colorWave );
			drawCircle(g, source.pos, distTraveled);
			// draw next tic position
			g.setColor( colorWave.brighter() );
			drawCircle(g, source.pos, distTraveled+getSpeed());

			// draw source pos at fire time
			g.setColor( colorWave );
			//drawRect(g, source.pos, 36, 36);

			// draw target pos at fire time
			g.setColor( colorWave );
			//drawRect(g, target.pos, 36, 36);

			// draw HoT line
			g.setColor( colorWave );
			//drawLine(g, source.pos, target.pos);

			// draw firing solutions
			if ( firingSolutions != null ) {
				for (String gunName : firingSolutions.keySet() ) {
					if ( !gunName.equals("realGun") ) continue;
					double fA = headOnAngle + firingSolutions.get(gunName);
					Point endP = new Point( source.pos );
					endP.addPolarVec( distTraveled + getSpeed(), fA);
					g.setColor( colorWave );
					//drawLine(g, source.pos, endP);
				}
			}

			// draw head on location
			{
				Point strtP = new Point( source.pos );
				strtP.addPolarVec( distTraveled-getSpeed(), headOnAngle);
				Point endP = new Point( source.pos );
				endP.addPolarVec( distTraveled, headOnAngle);
				g.setColor( colorWave );
				drawLine(g, strtP, endP);
			}

			// draw wave danger
			g.setColor( colorWave );
			double maxEscapeAngle = maxEscapeAngleForSpeed(getSpeed());
			ArrayStats aS = new ArrayStats( waveDanger );
			if ( Utils.isNear(aS.max-aS.min, 0) ) aS.max=aS.min+1;
			for( int i=0; i< waveDanger.length; i++) {
				double fA = binToXInRange( i, -maxEscapeAngle, maxEscapeAngle, waveDanger.length);
				fA += headOnAngle;

				Point strtP = new Point( source.pos );
				strtP.addPolarVec( distTraveled , fA);
				Point endP = new Point( source.pos );
				endP.addPolarVec( distTraveled + (waveDanger[i]-aS.min)/(aS.max - aS.min)*getSpeed(), fA);

				g.setColor( colorWave );
				drawLine(g, strtP, endP);
			}

			if (surfingInfo.isCalculated) {
				// safest reachable GF
				int i = surfingInfo.safestReachableBin;
				double fA = binToXInRange( i, -maxEscapeAngle, maxEscapeAngle, waveDanger.length);
				fA += headOnAngle;

				// border for safest reachable corridor
				g.setColor( colorSafestReachableGF );
				double distToDest = source.pos.dist(surfingInfo.destinationPoint);
				int Nsegments=10;
				for(int k=0; k<Nsegments; k++) {
					for(int j=0; j<4; j++) { // j in charge of the resulting line thickness
					Point endP  = new Point( source.pos );
					Point strtP = new Point( source.pos );
					strtP.addPolarVec( distTraveled-1-j, fA + 18.0/distToDest*(-1.0+2.0*k/Nsegments));
					endP.addPolarVec ( distTraveled-1-j, fA + 18.0/distToDest*(-1.0+2.0*(k+1)/Nsegments));
					drawLine(g, strtP, endP);
					}
				}

				// show expected safe position for a bot at the surf time
				g.setColor( colorSafestReachableGF );
				drawRect(g, surfingInfo.destinationPoint, 36, 36);
			}

			// drawing safety corridors
			for( Point sC : safetyCorridors ) {
				double fA1 = headOnAngle + sC.x;
				double fA2 = headOnAngle + sC.y;

				g.setColor( colorSafestReachableGF );
				Point strtP = new Point( source.pos );
				strtP.addPolarVec( distTraveled, fA1);
				Point endP = new Point( source.pos );
				endP.addPolarVec( distTraveled, fA2);
				
				drawLine(g, strtP, endP);
			}
		}
	}

	public class Range {
		double leftEnd =  Double.NaN;
		double rightEnd = Double.NaN;

		void merge(Range r) {
			if (Double.isNaN(this.leftEnd)  || (r.leftEnd  < this.leftEnd) ) { this.leftEnd  = r.leftEnd;  }
			if (Double.isNaN(this.rightEnd) || (r.rightEnd > this.rightEnd)) { this.rightEnd = r.rightEnd; }
		}
		void merge(Double a) {
			Range _tmpR = new Range();
			_tmpR.leftEnd  = a;
			_tmpR.rightEnd = a;
			this.merge(_tmpR);
		}
		boolean contains(double a) {
			if ( (this.leftEnd  <= a) && (a <= this.rightEnd) ) {return true; }
			return false;
		}
		public String toString() {
			String out="";
			out += "\"Range\": [" + this.leftEnd + ", " + this.rightEnd + "]";
			return out;
		}
	}

	public class Hit {
		public Range hitAngleRange = null; // hit angle arc limits at which bot was seen/hit
		public long waveCount=0; // essentially fire time
		public long hitTime = 0; // when hit registered
		public boolean isReal = false;
		public boolean isWaveReal = false;

		boolean contains(double a) {
			return hitAngleRange.contains(a);
		}
		public String toString() {
			String out="";
			out += "\"Hit\": {";
			if (hitAngleRange != null) {
				out += hitAngleRange.toString();
			} else {
				Range _tmp = new Range();
				out += _tmp.toString();
			}
			out += ", ";
			out += "\"waveCount\": " + this.waveCount;
			out += ", ";
			out += "\"hitTime\": " + this.hitTime;
			out += ", ";
			out += "\"isReal\": " + this.isReal;
			out += ", ";
			out += "\"isWaveReal\": " + this.isWaveReal;
			out += "}";
			return out;
		}
	}

	public class GunStats implements Comparable<GunStats> {
		public int firedCnt=0, hitCnt=0;
		public int realFiredCnt=0, realHitCnt=0;
		public int realUseCnt=0;

		public GunStats() {}
		public GunStats(GunStats gs) {
			// this mainly to be used by gun cloning so hit rates start the same
			// we keep all stats except realUseCnt
			firedCnt = gs.firedCnt;
			hitCnt   = gs.hitCnt;
			realFiredCnt = gs.realFiredCnt;
			realHitCnt   = gs.realHitCnt;
			realUseCnt   = 0;
		}
		public void degrade() {
			// increase fire cnt by 1 so hit rates are a bit worse
			// use for mutating guns, so new gun does not look as good
			firedCnt++;
			realFiredCnt++;
		}

		public double getHitRatio() {
			if (firedCnt > 0) {
				return 1.0*this.hitCnt/this.firedCnt;
			}
			return 0;
		}
		public double getRealHitRatio() {
			if (firedCnt > 0) {
				return 1.0*this.realHitCnt/this.realFiredCnt;
			}
			return 0;
		}
		public double getHitRatioEstimate() {
			double _hitRate = getHitRatio();
			if (realFiredCnt > 50 ) {
				_hitRate = getRealHitRatio();
			}
			return _hitRate;
		}
		public int compareTo(GunStats gs) {
			int cmp = (int)Math.signum(getHitRatioEstimate() - gs.getHitRatioEstimate());
			if ( cmp == 0 ) {
				cmp = realUseCnt - gs.realUseCnt;
			}
			return cmp;
		}
		public String toString(){
			String out="";
			out +=  "all waves hit ratio " + this.hitCnt + "/" + this.firedCnt + " = " + String.format( "%.1f", 100.0*getHitRatio()) + "%";
			out += " ";
			out +=  "real waves hit ratio " + this.realHitCnt + "/" + this.realFiredCnt + " = " + String.format( "%.1f", 100.0*getRealHitRatio()) + "%";
			out += " real use count " + realUseCnt;
			return out;
		}
		public String toString(boolean needsHeader){
			String out="";
			if (needsHeader) {
				out += "all wave hit ratio |";
				out += " real wave hit ratio |";
				out += " real use count |";
				out += " gun name\n";
			}
			out +=  String.format("%20s", this.hitCnt + "/" + this.firedCnt + " = " + String.format( "%.1f", 100.0*getHitRatio()) + "% |");
			out +=  String.format("%22s", this.realHitCnt + "/" + this.realFiredCnt + " = " + String.format( "%.1f", 100.0*getRealHitRatio()) + "% |");
			out +=  String.format("%17s", ""+realUseCnt+" |");
			return out;
		}
	}

	public double gameAngleToCartesian( double angle ) {
		return Utils.normalRelativeAngle(Math.PI/2 - angle);
	}

	public void onPaint(Graphics2D g) {
		time = getTime();
		g.setColor(new Color(0x00, 0xff, 0x00, 0x80));
		// draw my waves
		for (int i = 0; i < myWaves.size(); i++) {
			Wave w = (Wave) myWaves.get(i);
			w.onPaint(g);
		}
		// draw enemy waves
		for (int i = 0; i < enemyWaves.size(); i++) {
			Wave w = (Wave) enemyWaves.get(i);
			w.onPaint(g);
		}
	}

	public int maxBinInArray( double[] a ) {
		int maxBin = (int)((a.length-1)/2); // gf=0 bin is the default max
		for (int i=0; i< a.length; i++ ) {
			if ( a[maxBin] < a[i]) {
				maxBin = i;
			}
		}
		return maxBin;
	}
	public double putInRange(double x, double min, double max) {
		if (x< min) return min;
		if (x> max) return max;
		return x;
	}

	public boolean isInRange(double x, double min, double max) {
		if (x< min) return false;
		if (x> max) return false;
		return true;
	}

	public double maxEscapeAngleForSpeed(double bulletSpeed) {
		double safety_margin = 1.2; // to take in account that bot has extra width
		return safety_margin*Math.asin(Rules.MAX_VELOCITY/bulletSpeed);
	}

	public void updateTreeWeights(KDTree.WeightedManhattan tree) {
		double[] w = tree.coordStdInTree();
		//dbg("new std " + Arrays.toString(w));
		for (int i=0; i<w.length; i++) {
			w[i]=1./w[i];
		}
		//dbg("new weights " + Arrays.toString(w));
		tree.setWeights( w );
	}

	public double maxRealEscapeAngleForSpeed(double bulletSpeed, Point source, Point target, boolean isCCW) {
		double dist = source.distance(target);
		double maxDistTraveledBeforeHit = Rules.MAX_VELOCITY * dist /bulletSpeed;
		double rotDir = 1; if (!isCCW) rotDir = -1; // rotation direction from target point of view
		double angle0 = target.angleTo( source);
		Point stick = new Point().addPolarVec( maxDistTraveledBeforeHit, angle0);
		Point stickEnd = null;
		double a = 0, da = 5./180.*Math.PI;
		do {
			a+=da;
			stickEnd = (new Point(target)).add((new Point(stick)).rotateBy( rotDir*a));
		} while ( stickEnd.isInsideBox( SWcorner, NEcorner) && a < Math.PI/2 );
		return Utils.normalRelativeAngle(source.angleTo(stickEnd)-source.angleTo(target));
	}

	// Graphic utilities
	public static void drawLine( Graphics2D g, Point2D.Double strtP, Point2D.Double endP ) {
		g.drawLine((int)strtP.x, (int)strtP.y, (int)endP.x, (int)endP.y);
	}
	public static void drawCircle( Graphics2D g, Point2D.Double p, double R ) {
		g.drawOval( (int)(p.x - R), (int)(p.y - R), (int)(2*R), (int)(2*R) );
	}
	public static void drawRect( Graphics2D g, Point2D.Double p, double width, double height ) {
		g.drawRect( (int)(p.x - width/2), (int)(p.y - height/2), (int)(width), (int)(height) );
	}

	public void reverseInPlace( double[] a1 ) {
		int N = a1.length;
		double tmp;
		for(int i=0; i<= N/2; i++){
			tmp = a1[i];
			a1[i] = a1[N-1-i];
			a1[N-1-i] = tmp;
		}
	}

	public static void addInPlace( double[] a1, double[] a2 ) {
		int Na1= a1.length;
		int Na2= a2.length;
		if (Na1 != Na2) {
			dbg("Error: arrays size do not match, cannot perform 'addInPlace'");
			return;
		}
		for(int i=0; i<Na1; i++){
			a1[i] += a2[i];
		}
	}

	public void multiplyByInPlace( double[] a1, double scale ) {
		for(int i=0; i<a1.length; i++){
			a1[i] *= scale;
		}
	}

	public void divideByInPlace( double[] a1, double scale ) {
		if (scale == 0) {
			scale = 1;
		}
		multiplyByInPlace(a1, 1.0/scale);
	}

	public void scaleTo1InPlace( double[] a1 ) {
		ArrayStats aStat = new ArrayStats(a1);
		divideByInPlace(a1, aStat.max);
	}

	public void normSumTo1InPlace( double[] a1 ) {
		ArrayStats aStat = new ArrayStats(a1);
		divideByInPlace(a1, aStat.sum);
	}

	class ArrayStats {
		double min, max, mean, sum, std, var;
	   	int maxBin, minBin, weightedBin;

		public ArrayStats(double[] a) {
			double wBin =0;
			min = Double.POSITIVE_INFINITY;
			max = Double.NEGATIVE_INFINITY;
			sum = 0; 
			maxBin = (int)((a.length-1)/2); // gf=0 bin is the default max
			minBin = (int)((a.length-1)/2); // gf=0 bin is the default min
			weightedBin = (int)((a.length-1)/2); // gf=0 bin is the default min
			for(int i=0; i<a.length; i++) {
				sum += a[i];
				var  += a[i]*a[i];
				wBin += i*a[i]; 
				if (a[i] < min ) {
					min = a[i];
					minBin = i;
				}
				if (a[i] > max ) {
					max = a[i];
					maxBin = i;
				}
			}
			mean = sum /  a.length;
			var  /=  a.length;
		    var  = Math.abs( var - mean*mean); // abs protects against rounding	
			std = Math.sqrt(var);
			if ( sum > 0 ) {
				weightedBin = (int) Math.round(wBin/sum);
			}
		}

		public String toString() {
			String s = "";
			s += "min: " + min;
			s += " at pos: " + minBin;
			s += ", mean: " + mean;
			s += ", max: " + max;
			s += " at pos: " + maxBin;
			s += ", std: " + std;
			s += ", var: " + var;
			return s;
		}
	}

	public void softMax(double[] weights) {
		ArrayStats stats = new ArrayStats( weights );
		// soft max: smallest distance gets weight of 1,
		// the rest is exponentially smaller
		for (int i=0; i< weights.length; i++) {
			weights[i] = Math.exp( weights[i] - stats.max );
		}
	}

};

// vim: tabstop=4: shiftwidth=4
