/*
 * Decompiled with CFR 0.152.
 */
package metal.shared;

import java.util.Random;
import java.util.TreeMap;
import metal.shared.MAngle;
import metal.shared.MBotData;
import metal.shared.MBullet;
import metal.shared.MBulletEnemy;
import metal.shared.MDna;
import metal.shared.MMath;
import metal.shared.MPoint;
import metal.shared.MPolar;
import robocode.HitByBulletEvent;

public class MChassisCircular {
    public TreeMap bullets = new TreeMap();
    static int c;
    private static MPoint centre;
    static double circleDir;
    static MDna[] dnas;
    private static MPoint enemyPoint;
    private static double firePower;
    private static double fireTime;
    static boolean first;
    static int i;
    static int index;
    static double[] modifiers;
    private static MPoint nextPoint;
    private static Random rand;

    static {
        rand = new Random();
        centre = null;
        nextPoint = null;
        enemyPoint = null;
        firePower = 0.0;
        fireTime = 0.0;
        dnas = new MDna[30];
        i = 0;
        first = true;
        c = 0;
        circleDir = 1.0;
        modifiers = new double[]{12.0, 11.0, 10.0, 8.5, 7.5};
        index = 0;
    }

    public MChassisCircular() {
        MBotData.print("SYSTEM:  Chassis    ... OK");
        centre = new MPoint(MBotData.self.getBattleFieldWidth() / 2.0, MBotData.self.getBattleFieldHeight() / 2.0);
        if (first) {
            MChassisCircular.init();
            first = false;
        }
    }

    public static void go(MPoint toPoint) {
        double dist = MBotData.getLocation().distance(toPoint);
        double ang = MAngle.relative(MAngle.absolute(MBotData.getLocation(), toPoint) - MBotData.self.getHeading());
        if (MMath.abs(ang) > 90.0) {
            dist *= -1.0;
            ang = ang > 0.0 ? (ang -= 180.0) : (ang += 180.0);
        }
        MBotData.self.setTurnRight(ang + MMath.random(-1.0, 1.0));
        MBotData.self.setAhead(dist);
    }

    private static void init() {
        int i = 0;
        while (i < dnas.length) {
            MChassisCircular.dnas[i] = new MDna();
            ++i;
        }
    }

    private static void initDNA() {
        int i = 0;
        while (i < dnas.length) {
            dnas[i].mergeDna(dnas[i].furtilize());
            ++i;
        }
    }

    private static void kiss() {
        MBotData.self.setMaxVelocity(8.0);
        MChassisCircular.go(MBotData.enemy);
    }

    public static void move() {
        try {
            if (MBotData.enemy.energy < 1.5 && MBotData.self.getEnergy() > 12.0 || MBotData.enemy.energy == 0.0) {
                MChassisCircular.kiss();
            } else {
                MChassisCircular.movement();
            }
        }
        catch (Exception e) {
            MBotData.err("SYSTEM:  Chassis    ... FAILED");
            e.printStackTrace();
        }
    }

    private static void movement() {
        if (MBotData.enemy.isFired) {
            int indexD = (int)MMath.clamp(100.0, 0.0, MBotData.enemy.distance / 10.0);
            index = (int)MMath.clamp(30.0, 0.0, (double)indexD / MBullet.getSpeed(firePower));
            MBotData.enemy.isFired = false;
            ++c;
        }
        MPoint enemyLocation = MPoint.getPoint(MBotData.getLocation(), MBotData.enemy.bearing, MBotData.enemy.distance);
        double distDelta = MBotData.enemy.distance <= 400.0 ? 0.1 : -0.1;
        double newX = MBotData.self.getX() + 50.0 * MMath.sin(MBotData.enemy.bearingRel + circleDir * (90.0 + distDelta) + MBotData.self.getHeading());
        double newY = MBotData.self.getY() + 50.0 * MMath.cos(MBotData.enemy.bearingRel + circleDir * (90.0 + distDelta) + MBotData.self.getHeading());
        newX = Math.max(70.0, Math.min(newX, 730.0));
        newY = Math.max(70.0, Math.min(newY, 530.0));
        double modF = MChassisCircular.dnas[MChassisCircular.index].getChromosoom((String)new StringBuffer().append((String)"").append((int)(Math.min((int)((int)(MBotData.enemy.distance / 160.0) + MChassisCircular.c), (int)4) % 4)).toString()).value;
        double mod = modifiers[Math.min((int)(MBotData.enemy.distance / 160.0), 4)];
        mod = modF * mod / 15.0;
        if (Math.random() > Math.pow(mod / MBotData.enemy.distance, mod / MBotData.enemy.distance) || Math.abs(MAngle.relative(MMath.atan2(newX - MBotData.self.getX(), newY - MBotData.self.getY()) - MBotData.enemy.bearing)) < 45.0) {
            circleDir *= -1.0;
        }
        double theta = MAngle.relative(MMath.atan2(newX - MBotData.self.getX(), newY - MBotData.self.getY()) - MBotData.self.getHeading());
        MBotData.self.setAhead(MMath.cos(theta) * 100.0);
        MBotData.self.setTurnRight(MMath.tan(theta));
    }

    public void update(HitByBulletEvent e) {
        try {
            MBulletEnemy b = (MBulletEnemy)MBotData.enemy.bullets.get((e.getVelocity() + "     ").substring(0, 5));
            double dist = b.getDistance();
            double bearing = MPolar.getPolar((MPoint)MBotData.getLocation(), (MPoint)MPolar.getPoint((MPoint)MBotData.getLocation(), (double)e.getBearing(), (double)(-dist))).bearing;
            int indexD = (int)MMath.clamp(100.0, 0.0, dist / 10.0);
            int index = (int)MMath.clamp(30.0, 0.0, (double)indexD / e.getVelocity());
            int i = (int)Math.abs(bearing / 16.0 % 4.0);
            dnas[index].mutate(i + "");
            dnas[index].mutate("dir");
            dnas[index].mutate("speed");
            MBotData.enemy.bullets.remove(b.toString());
        }
        catch (Exception ex) {
            MBotData.err("SYSTEM:  Chassis    ... FAILED TIME: " + MBotData.self.getTime());
            MBotData.err("SYSTEM:   Err: No bullets matched! " + ex.toString());
        }
    }
}

