/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import pa3k.Opponent;
import pa3k.Position;
import pa3k.Range;
import pa3k.SelfTracking;
import pa3k.State;
import robocode.AdvancedRobot;

class Change {
    protected double lkh = 0.0;
    protected State newState;
    protected Range lastOpponentSpeedChange;
    protected Range lastOpponentHitDelay;
    protected Range lastEnergyDropDelay;
    protected Range lastEnergyDrop;
    protected boolean reverseDir;
    protected boolean facingWall;
    protected Range[] ranges;

    public Change(State newState) {
        this.newState = newState;
        this.reverseDir = false;
    }

    public boolean checkConsitency(State oldState) {
        int s = oldState.getSpeed();
        return this.newState.getSpeed() <= s + 1 && this.newState.getSpeed() >= s - 2;
    }

    public boolean isChangingDirection() {
        return this.reverseDir;
    }

    public Change(State newState, boolean reverseDir) {
        this.newState = newState;
        this.reverseDir = reverseDir;
    }

    public void increaseLikelihood() {
        this.lkh += 1.0;
    }

    public boolean isApplicable(long lastOpponentSpeedChange, boolean facingWall, long lastOpponentHitDelay, long lastEnergyDropDelay, double lastEnergyDrop) {
        if (this.facingWall != facingWall) {
            return false;
        }
        return this.ranges[0].test(lastOpponentSpeedChange);
    }

    public double getLikelihood() {
        return this.lkh;
    }

    public State getTargetState() {
        return this.newState;
    }

    public void setValues(AdvancedRobot r, Opponent o, long now, SelfTracking st) {
        this.lastOpponentSpeedChange = new Range((double)o.getLastSpeedChange(now - 1L) - 0.5, 10000.0);
        this.lastEnergyDropDelay = new Range(st.lastEnergyDrop(now));
        this.facingWall = true;
        Position p = new Position(o.getLastPosition());
        p.modify(1L, 140.0, o.getLastHeading());
        if (p.isInBattlefield()) {
            this.facingWall = false;
        }
        this.lastOpponentHitDelay = new Range(0L);
        this.lastEnergyDrop = new Range(0L);
        this.ranges = new Range[1];
        this.ranges[0] = this.lastOpponentSpeedChange;
    }

    public boolean isSpecialCaseOf(Change generalChange) {
        if (this.newState != generalChange.newState) {
            return false;
        }
        if (this.reverseDir != generalChange.reverseDir) {
            return false;
        }
        if (this.facingWall != generalChange.facingWall) {
            return false;
        }
        int i = 0;
        while (i < this.ranges.length) {
            if (!this.ranges[i].isSpecialCaseOf(generalChange.ranges[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public double cmp(Change c) {
        if (this.newState != c.newState) {
            return 0.0;
        }
        if (this.reverseDir != c.reverseDir) {
            return 0.0;
        }
        if (this.facingWall != c.facingWall) {
            return 0.0;
        }
        double score = 0.0;
        int i = 0;
        while (i < this.ranges.length) {
            score += this.ranges[i].cmp(c.ranges[i]);
            ++i;
        }
        return score / (double)this.ranges.length;
    }

    public void generalizeWith(Change c) {
        this.lkh += c.lkh;
        int i = 0;
        while (i < this.ranges.length) {
            this.ranges[i].generalizeWith(c.ranges[i]);
            ++i;
        }
    }

    public String toString() {
        String s = "-> " + this.newState + (this.reverseDir ? " reverse dir " : "");
        int i = 0;
        while (i < this.ranges.length) {
            s = String.valueOf(s) + " " + this.ranges[i];
            ++i;
        }
        if (this.facingWall) {
            s = String.valueOf(s) + " FW";
        }
        return String.valueOf(s) + " (" + this.lkh + ")";
    }
}

