/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import pa3k.BulletTracking;
import pa3k.CalendarMoving;
import pa3k.CalendarMovingTask;
import pa3k.Log;
import pa3k.TaskExecutor;
import pa3k.Tracking;
import robocode.AdvancedRobot;
import robocode.util.Utils;

public class RandomChangeMoving
extends CalendarMoving {
    protected BulletTracking seenAlready;
    protected int timeToDirChange = 0;
    protected boolean fullSpeed;

    public RandomChangeMoving(AdvancedRobot robot, Tracking tracking, boolean fullSpeed) {
        super(robot, tracking);
        this.fullSpeed = fullSpeed;
        this.seenAlready = null;
    }

    @Override
    public void init() {
        super.init();
        this.scheduleDirectionChange(10L);
        if (!this.fullSpeed) {
            this.scheduleSlowSpell(20L);
        }
    }

    @Override
    public void turn() {
        super.turn();
    }

    protected void scheduleSlowSpell(long delta) {
        Log.log(3, "Scheduling slow spell in " + delta + " turns");
        long currentTime = this.robot.getTime();
        CalendarMovingTask tt = new CalendarMovingTask(currentTime + delta, new TaskExecutor(){

            @Override
            public void execute(CalendarMoving m, CalendarMovingTask t) {
                int speed = Utils.getRandom().nextInt(20);
                m.setMaxSpeed(speed);
                RandomChangeMoving.this.scheduleSlowSpell(Utils.getRandom().nextInt(10) + 4);
            }
        });
        this.addTask(tt);
    }

    protected void scheduleDirectionChange(long delta) {
        Log.log(3, "Scheduling direction change in " + delta + " turns");
        long currentTime = this.robot.getTime();
        CalendarMovingTask tt = new CalendarMovingTask(currentTime + delta, new TaskExecutor(){

            @Override
            public void execute(CalendarMoving m, CalendarMovingTask t) {
                RandomChangeMoving.this.direction *= -1;
                RandomChangeMoving.this.scheduleDirectionChange(Utils.getRandom().nextInt(30) + 10);
            }
        });
        this.addTask(tt);
    }
}

