/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import pa3k.AngleUtils;
import pa3k.Change;
import pa3k.Opponent;
import pa3k.Position;
import pa3k.SelfTracking;
import pa3k.State;
import robocode.AdvancedRobot;
import robocode.Robot;
import robocode.util.Utils;

class StateDirectionKeep
extends State {
    public StateDirectionKeep(int speed) {
        super(speed);
    }

    @Override
    public double advancePosition(Position p, double heading, double lastHeading, int direction) {
        super.advancePosition(p, heading, lastHeading, direction);
        return Utils.normalAbsoluteAngle((double)(heading + AngleUtils.difference(heading, lastHeading)));
    }

    @Override
    public Change amIStillHere(AdvancedRobot r, SelfTracking st, Opponent o, long now, State[] states, boolean directionChange, long lastOpponentSpeedChange, boolean facingWall, long lastOpponentHitDelay, long lastEnergyDropDelay, double lastEnergyDrop) throws Exception {
        Position my = new Position((Robot)r);
        Position op = o.getLastPosition();
        double angle = op.getDirectionTo(my);
        angle = Utils.normalAbsoluteAngle((double)(angle + 1.5707963267948966));
        double opp_heading = o.getLastHeading(now) % Math.PI;
        double diff = Math.abs(AngleUtils.difference(angle %= Math.PI, opp_heading));
        int velocity = (int)Math.abs(Math.round(o.getLastVelocity(now)));
        if (velocity == this.speed && diff > 0.2) {
            return null;
        }
        Change c = null;
        c = velocity == 0 ? new Change(states[0]) : (diff < 0.2 ? new Change(states[velocity]) : new Change(states[8 + velocity]));
        c.setValues(r, o, now, st);
        return this.checkChanges(c, lastOpponentSpeedChange, facingWall, lastOpponentHitDelay, lastEnergyDropDelay, lastEnergyDrop);
    }

    public String toString() {
        return "StateDirKeep(" + this.speed + ")";
    }
}

