/*
 * Decompiled with CFR 0.152.
 */
package bing2;

import bing2.Position;

public class MathUtils {
    static double PI2 = Math.PI * 2;

    public static int sign(double d) {
        return d >= 0.0 ? 1 : -1;
    }

    public static int signZ(double d) {
        if (d > 0.0) {
            return 1;
        }
        if (d < 0.0) {
            return -1;
        }
        return 0;
    }

    public static double limit(double d, double d2, double d3) {
        return Math.max(d2, Math.min(d, d3));
    }

    public static long limit(long l, long l2, long l3) {
        return Math.max(l2, Math.min(l, l3));
    }

    public static double normalizeTurn(double d) {
        return Math.atan(Math.tan(d));
    }

    public static boolean needsBack(double d) {
        double d2 = MathUtils.normalizeRadians(d);
        return Math.abs(d2) > 1.5707963267948966;
    }

    public static double normalizeRadians(double d) {
        return MathUtils.normalizeRadians(d, -Math.PI);
    }

    public static double normalizeRadians(double d, double d2) {
        while (d <= d2) {
            d += PI2;
        }
        while (d > d2 + PI2) {
            d -= PI2;
        }
        return d;
    }

    public static double normalizeDegrees(double d, double d2) {
        while (d <= d2) {
            d += 360.0;
        }
        while (d > d2 + 360.0) {
            d -= 360.0;
        }
        return d;
    }

    public static double normalizeDegrees(double d) {
        return MathUtils.normalizeDegrees(d, 0.0);
    }

    public static double toDegrees(double d) {
        return d / PI2 * 360.0;
    }

    public static double toRadians(double d) {
        return d / 360.0 * PI2;
    }

    public static Position absolutePosition(Position position, double d, double d2) {
        return new Position(position.x + Math.sin(d) * d2, position.y + Math.cos(d) * d2);
    }

    public static Position relativePosition(double d, double d2) {
        return new Position(d2 * Math.sin(d), d2 * Math.cos(d));
    }

    public static Position absolutePosition(Position position, Position position2) {
        return new Position(position.x + position2.x, position.y + position2.y);
    }

    public static Position relativePosition(Position position, Position position2) {
        return new Position(position.x - position2.x, position.y - position2.y);
    }

    public static double bearing(Position position, Position position2) {
        return MathUtils.bearing(MathUtils.relativePosition(position, position2));
    }

    public static double bearing(double d, double d2, double d3, double d4) {
        return MathUtils.bearing(new Position(d, d2), new Position(d3, d4));
    }

    public static double bearing(Position position) {
        double d = position.x;
        double d2 = position.y;
        double d3 = Math.sqrt(position.x * position.x + position.y * position.y);
        if (d2 >= 0.0) {
            return Math.asin(d / d3);
        }
        if (d >= 0.0) {
            return Math.PI - Math.asin(d / d3);
        }
        return -Math.PI - Math.asin(d / d3);
    }

    public static double distance(Position position, Position position2) {
        double d = position.x - position2.x;
        double d2 = position.y - position2.y;
        return Math.sqrt(d * d + d2 * d2);
    }

    public static double distance(Position position) {
        return Math.sqrt(position.x * position.x + position.y * position.y);
    }

    public static double distance(double d, double d2, double d3, double d4) {
        double d5 = d - d3;
        double d6 = d2 - d4;
        return Math.sqrt(d5 * d5 + d6 * d6);
    }

    public static Position nextPosition(Position position, double d, double d2) {
        double d3 = Math.sin(d) * d2;
        double d4 = Math.cos(d) * d2;
        return new Position(position.x + d3, position.y + d4);
    }

    public static double entropy(double[] dArray, double d) {
        if (d == 0.0) {
            return MathUtils.maxEntropy(dArray.length);
        }
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d3 = dArray[i] / d;
            d2 += -d3 * MathUtils.myLog(d3) / Math.log(2.0);
        }
        return d2;
    }

    public static double maxEntropy(int n) {
        return -Math.log(1.0 / (double)n) / Math.log(2.0);
    }

    public static double myLog(double d) {
        if (d <= 1.0E-7) {
            return Math.log(1.0E-7);
        }
        return Math.log(d);
    }
}

