/*
 * Decompiled with CFR 0.152.
 */
package jw;

import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.Robot;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BulletCounter3 {
    Bullet hitBullet;
    Bullet hitMeBullet;
    boolean eHit;
    boolean meHit;
    Robot me;
    double myOldEnergy;
    int sumHitNumber;
    int sumShotNumber;
    int hitNumber;
    int shotNumber;
    int CRshots;
    int CRhits;
    int MRshots;
    int MRhits;
    int LRshots;
    int LRhits;
    int ELRshots;
    int ELRhits;
    int sumCRshots;
    int sumCRhits;
    int sumMRshots;
    int sumMRhits;
    int sumLRshots;
    int sumLRhits;
    int sumELRshots;
    int sumELRhits;
    final int longRange = 800;
    final int mediumRange = 400;
    final int closeRange = 200;
    ScannedRobotEvent target;
    int roundNumber;
    double eGain;
    double eLoss;
    double meLoss;
    double meGain;
    int meShots;
    int meHits;
    int meSumShots;
    int meSumHits;
    double damageTaken;
    double damageDone;
    double totalDamageTaken;
    double totalDamageDone;

    public void setHost(Robot me) {
        this.me = me;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double newEnergy;
        double oldEnergy;
        double energyDiff;
        if (this.target == null) {
            this.target = e;
        }
        if ((energyDiff = (oldEnergy = this.target.getEnergy()) - this.eLoss + this.eGain - (newEnergy = e.getEnergy())) >= 0.1) {
            ++this.shotNumber;
            this.shotRange(e);
        }
        this.target = e;
    }

    public void onBulletHit(BulletHitEvent e) {
        this.hitBullet = e.getBullet();
        this.eHit = true;
        this.eLoss = this.getBulletDamage(this.hitBullet);
        this.damageDone += this.eLoss;
        this.meGain = this.hitBullet.getPower() * (double)3;
        ++this.meHits;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        ++this.hitNumber;
        this.meLoss = this.getBulletDamage(e.getBullet());
        this.damageTaken += this.meLoss;
        this.hitMeBullet = e.getBullet();
        this.meHit = true;
        this.eGain = this.hitMeBullet.getPower() * (double)3;
        this.dodgedRange();
    }

    public void run() {
        double myNewEnergy = this.me.getEnergy();
        double energyDiff = this.myOldEnergy - this.meLoss + this.meGain - myNewEnergy;
        if (energyDiff >= 0.1) {
            ++this.meShots;
        }
        this.myOldEnergy = myNewEnergy;
        this.eHit = false;
        this.meHit = false;
        this.eLoss = 0.0;
        this.eGain = 0.0;
        this.meLoss = 0.0;
        this.meGain = 0.0;
    }

    private final double getBulletDamage(Bullet b) {
        double power = b.getPower();
        double damage = 0.0;
        damage = (double)4 * power;
        if (power > 1.0) {
            damage += (double)2 * (power - 1.0);
        }
        return damage;
    }

    public void writeStatistics() {
        int dodged = this.shotNumber - this.hitNumber;
        double dodgeRatio = (double)dodged / (double)this.shotNumber * 100.0;
        System.out.println();
        System.out.println("---------- CurrentRound ---------");
        System.out.println(" Bullets fired at me: " + this.shotNumber);
        System.out.println(" Bullets dodged : " + dodged);
        System.out.println(" bullets hit: " + this.hitNumber);
        System.out.println(" Dodge ratio: " + dodgeRatio + '%');
        System.out.println(" Enemy hit ratio:" + (100.0 - dodgeRatio) + '%');
        System.out.println();
        System.out.println("----------- my stats ------------");
        System.out.println(" shots fired: " + this.meShots);
        System.out.println(" registred hits: " + this.meHits);
        dodged = this.meShots - this.meHits;
        dodgeRatio = (double)dodged / (double)this.meShots * 100.0;
        System.out.println(" enemy dodge ratio : " + dodgeRatio);
        System.out.println(" My hit ratio: " + (100.0 - dodgeRatio));
        System.out.println(" Damage done: " + this.damageDone);
        System.out.println(" Damage taken:" + this.damageTaken);
        System.out.println("---------------------------------");
    }

    public void onWin(WinEvent e) {
        this.endRound();
    }

    public void onDeath(DeathEvent e) {
        this.endRound();
    }

    public void endRound() {
        this.sumHitNumber += this.hitNumber;
        this.sumShotNumber += this.shotNumber;
        this.sumCRshots += this.CRshots;
        this.sumMRshots += this.MRshots;
        this.sumLRshots += this.LRshots;
        this.sumELRshots += this.ELRshots;
        this.sumCRhits += this.CRhits;
        this.sumMRhits += this.MRhits;
        this.sumLRhits += this.LRhits;
        this.sumELRhits += this.ELRhits;
        this.meSumShots = this.meShots + this.meSumShots;
        this.meSumHits = this.meHits + this.meSumHits;
        this.totalDamageTaken += this.damageTaken;
        this.totalDamageDone += this.damageDone;
        this.printOverall();
        ++this.roundNumber;
        this.hitNumber = 0;
        this.shotNumber = 0;
        this.CRshots = 0;
        this.MRshots = 0;
        this.LRshots = 0;
        this.ELRshots = 0;
        this.CRhits = 0;
        this.MRhits = 0;
        this.LRhits = 0;
        this.ELRhits = 0;
        this.meHits = 0;
        this.meShots = 0;
        this.damageDone = 0.0;
        this.damageTaken = 0.0;
        this.target = null;
    }

    private final void shotRange(ScannedRobotEvent e) {
        double eDist = e.getDistance();
        if (eDist < 200.0) {
            ++this.CRshots;
        } else if (eDist < 400.0) {
            ++this.MRshots;
        } else if (eDist < 800.0) {
            ++this.LRshots;
        } else {
            ++this.ELRshots;
        }
    }

    private final void dodgedRange() {
        double eDist = this.target.getDistance();
        if (eDist < 200.0) {
            ++this.CRhits;
        } else if (eDist < 400.0) {
            ++this.MRhits;
        } else if (eDist < 800.0) {
            ++this.LRhits;
        } else {
            ++this.ELRhits;
        }
    }

    private final void printRangeLine(int sumShots, int sumHits, int range, boolean under) {
        int dodged = sumShots - sumHits;
        double dodgeRatio = (double)dodged / (double)sumShots * 100.0;
        if (under) {
            System.out.println("       " + sumShots + "         " + dodged + "         < " + range + "   " + dodgeRatio + '%');
        } else {
            System.out.println("       " + sumShots + "         " + dodged + "         > " + range + "   " + dodgeRatio + '%');
        }
    }

    public void printOverall() {
        int dodged = this.sumShotNumber - this.sumHitNumber;
        double dodgeRatio = (double)dodged / (double)this.sumShotNumber * 100.0;
        System.out.println();
        System.out.println(" ------------ OverAll -----------");
        System.out.println(" End of round " + this.roundNumber + ", dodging so far:");
        System.out.println(" bullets fired at me: " + this.sumShotNumber);
        System.out.println(" bullets hit: " + this.sumHitNumber);
        System.out.println(" bullets dodged : " + dodged);
        System.out.println(" dodge ratio: " + dodgeRatio + '%');
        System.out.println(" Enemy hit ratio:" + (100.0 - dodgeRatio) + '%');
        System.out.println();
        System.out.println("----------- my stats ------------");
        System.out.println(" shots fired: " + this.meSumShots);
        System.out.println(" registred hits: " + this.meSumHits);
        dodged = this.meSumShots - this.meSumHits;
        dodgeRatio = (double)dodged / (double)this.meSumShots * 100.0;
        System.out.println(" enemy dodge ratio : " + dodgeRatio);
        System.out.println(" My hit ratio: " + (100.0 - dodgeRatio));
        System.out.println(" Total damage done: " + this.totalDamageDone);
        System.out.println(" Total damage taken: " + this.totalDamageTaken);
        System.out.println("---------------------------------");
        System.out.println();
    }

    private final /* synthetic */ void this() {
        this.hitBullet = null;
        this.hitMeBullet = null;
        this.eHit = false;
        this.meHit = false;
        this.me = null;
        this.myOldEnergy = 100.0;
        this.sumHitNumber = 0;
        this.sumShotNumber = 0;
        this.hitNumber = 0;
        this.shotNumber = 0;
        this.CRshots = 0;
        this.CRhits = 0;
        this.MRshots = 0;
        this.MRhits = 0;
        this.LRshots = 0;
        this.LRhits = 0;
        this.ELRshots = 0;
        this.ELRhits = 0;
        this.sumCRshots = 0;
        this.sumCRhits = 0;
        this.sumMRshots = 0;
        this.sumMRhits = 0;
        this.sumLRshots = 0;
        this.sumLRhits = 0;
        this.sumELRshots = 0;
        this.sumELRhits = 0;
        this.longRange = 800;
        this.mediumRange = 400;
        this.closeRange = 200;
        this.target = null;
        this.roundNumber = 1;
        this.eGain = 0.0;
        this.eLoss = 0.0;
        this.meLoss = 0.0;
        this.meGain = 0.0;
        this.meShots = 0;
        this.meHits = 0;
        this.meSumShots = 0;
        this.meSumHits = 0;
        this.damageTaken = 0.0;
        this.damageDone = 0.0;
        this.totalDamageTaken = 0.0;
        this.totalDamageDone = 0.0;
    }

    public BulletCounter3() {
        this.this();
    }
}

