/*
 * Decompiled with CFR 0.152.
 */
package jw;

import java.util.Vector;
import jw.RobotPosition;
import robocode.Robot;
import robocode.ScannedRobotEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Enemy3 {
    private int storedMoves;
    private int storedFirePos;
    private String name;
    private Vector positions;
    private Vector firePositions;
    private Robot me;
    private double lastDistance;
    private double lastDirection;
    private double lastSpeed;
    private double lastEnergy;
    private double lastBearing;
    private long lastTime;
    ScannedRobotEvent lastEvent;
    RobotPosition current;

    public void update(ScannedRobotEvent e) {
        double direction = Enemy3.normDeg(e.getBearing() + this.me.getHeading());
        double distance = e.getDistance();
        if (e.getName() == this.getName()) {
            try {
                while (e.getTime() > this.lastTime + 1L) {
                    if (this.positions.size() > 0) {
                        this.positions.add(0, (RobotPosition)this.positions.elementAt(0));
                    }
                    ++this.lastTime;
                }
                RobotPosition tmp = Enemy3.getRobotPosition(e, new RobotPosition(this.me));
                while (Double.isNaN(tmp.getHeading())) {
                    tmp = Enemy3.getRobotPosition(e, new RobotPosition(this.me));
                }
                this.current = tmp;
                this.positions.add(0, tmp);
                while (this.positions.size() > this.storedMoves) {
                    this.positions.removeElementAt(this.storedMoves);
                }
            }
            catch (Exception err) {
                // empty catch block
            }
            this.lastDistance = distance;
            this.lastDirection = direction;
            this.lastSpeed = e.getVelocity();
            this.lastEnergy = e.getEnergy();
            this.lastBearing = e.getBearing();
            this.lastTime = this.me.getTime();
            this.lastEvent = e;
        }
    }

    public static RobotPosition getRobotPosition(ScannedRobotEvent e, RobotPosition me) {
        double direction = Enemy3.normDeg(e.getBearing() + me.getHeading());
        double rX = me.x();
        double rY = me.y();
        double eX = 0.0;
        double eY = 0.0;
        double distance = e.getDistance();
        long lastTime = me.getTime();
        if (direction > 0.0 && direction < 90.0) {
            eX = rX + distance * Math.sin(Math.toRadians(direction));
            eY = rY + distance * Math.cos(Math.toRadians(direction));
        } else if (direction > 90.0 && direction < 180.0) {
            eX = rX + distance * Math.cos(Math.toRadians(direction -= 90.0));
            eY = rY - distance * Math.sin(Math.toRadians(direction));
        } else if (direction > 180.0 && direction < 270.0) {
            eX = rX - distance * Math.sin(Math.toRadians(direction -= 180.0));
            eY = rY - distance * Math.cos(Math.toRadians(direction));
        } else if (direction > 270.0 && direction < 360.0) {
            eX = rX - distance * Math.cos(Math.toRadians(direction -= 270.0));
            eY = rY + distance * Math.sin(Math.toRadians(direction));
        }
        return new RobotPosition(eX, eY, lastTime, e.getHeading(), e.getVelocity());
    }

    public String getName() {
        return this.name;
    }

    public RobotPosition getPosition(int number) {
        RobotPosition tmp;
        try {
            tmp = (RobotPosition)this.positions.elementAt(number);
        }
        catch (Exception e) {
            return null;
        }
        return tmp;
    }

    public RobotPosition getPosition() {
        return this.getPosition(0);
    }

    public double getDirection() {
        return this.lastDirection;
    }

    public double getDistance() {
        return this.lastDistance;
    }

    public double getSpeed() {
        return this.lastSpeed;
    }

    public double getVelocity() {
        return this.getSpeed();
    }

    public double getBearing() {
        return this.lastBearing;
    }

    public double getEnergy() {
        return this.lastEnergy;
    }

    public void printIt() {
        System.out.println("Enemy :" + this.name);
        System.out.println("----------------------------------------");
        System.out.println("Position x,y         " + this.getPosition(0).x() + ',' + this.getPosition(0).y());
        System.out.println("Direction:           " + this.lastDirection);
        System.out.println("Speed:               " + this.lastSpeed);
        System.out.println("Distance:            " + this.lastDistance);
        System.out.println("Energy:              " + this.lastEnergy);
        System.out.println("at timeFrame:        " + this.lastTime);
        System.out.println("----------------------------------------");
        System.out.println("From the event:");
        System.out.println("Distance:            " + this.lastEvent.getDistance());
        System.out.println("Bearing:             " + this.lastEvent.getBearing());
        System.out.println("=========================================");
    }

    private static final double normDeg(double deg) {
        if (deg < 0.0) {
            return Enemy3.normDeg(deg + 360.0);
        }
        if (deg >= 360.0) {
            return Enemy3.normDeg(deg - 360.0);
        }
        return deg;
    }

    public Vector getHistory() {
        return (Vector)this.positions.clone();
    }

    public ScannedRobotEvent getEvent() {
        return this.lastEvent;
    }

    public void setFirePosition() {
        this.current.setFire();
        this.firePositions.add(0, this.current);
        while (this.positions.size() > this.storedFirePos) {
            this.positions.removeElementAt(this.storedFirePos);
        }
    }

    public Vector getFirePositions() {
        return (Vector)this.firePositions.clone();
    }

    private final /* synthetic */ void this() {
        this.storedMoves = 800;
        this.storedFirePos = 100;
        this.positions = new Vector(this.storedMoves);
        this.firePositions = new Vector(this.storedFirePos);
        this.me = null;
        this.lastDistance = 0.0;
        this.lastDirection = 0.0;
        this.lastSpeed = 0.0;
        this.lastEnergy = 0.0;
        this.lastBearing = 0.0;
        this.lastTime = 0L;
        this.lastEvent = null;
        this.current = null;
    }

    public Enemy3(ScannedRobotEvent e, Robot r) {
        this.this();
        this.name = e.getName();
        this.me = r;
        this.update(e);
    }
}

