/*
 * Decompiled with CFR 0.152.
 */
package jw;

import jw.MovementPattern3;
import robocode.AdvancedRobot;
import robocode.HitWallEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PerceptWallAvoider4
extends MovementPattern3 {
    AdvancedRobot me;
    final double wallDistance = 130.0;

    public void run() {
        int cornerNumber = 0;
        int edgeNumber = 0;
        double myX = 0.0;
        double myY = 0.0;
        double fieldHeight = 0.0;
        double fieldWidth = 0.0;
        double wallDistance = 100.0;
        fieldWidth = this.me.getBattleFieldWidth();
        fieldHeight = this.me.getBattleFieldHeight();
        myX = this.me.getX();
        myY = this.me.getY();
        this.me.setMaxVelocity(8.0);
        cornerNumber = this.getCornerNumber();
        if (cornerNumber != 0) {
            this.eChangeDir();
            this.turnFromCorner(cornerNumber);
        } else {
            edgeNumber = this.getEdgeNumber();
            if (edgeNumber != 0) {
                this.eChangeDir();
                this.turnFromEdge(edgeNumber);
            }
        }
    }

    private final void turnFromCorner(int cornerNumber) {
        double fieldWidth = this.me.getBattleFieldWidth();
        double fieldHeight = this.me.getBattleFieldHeight();
        long dir = Math.round(this.me.getVelocity() / Math.abs(this.me.getVelocity()));
        if (dir == 0L) {
            Math.round(this.me.getDistanceRemaining() / Math.abs(this.me.getDistanceRemaining()));
        }
        if (dir == 0L) {
            dir = 1L;
        }
        this.me.setMaxVelocity((double)5);
        switch (cornerNumber) {
            case 1: {
                this.turnAway(this.getBearingTo(130.0, 130.0) - 90.0 + (double)(30L * dir));
                break;
            }
            case 2: {
                this.turnAway(this.getBearingTo(130.0, fieldHeight - 130.0) - 90.0 + (double)(30L * dir));
                break;
            }
            case 3: {
                this.turnAway(this.getBearingTo(fieldWidth - 130.0, fieldHeight - 130.0) - 90.0 + (double)(30L * dir));
                break;
            }
            case 4: {
                this.turnAway(this.getBearingTo(fieldWidth - 130.0, 130.0) - 90.0 + (double)(30L * dir));
            }
        }
    }

    private final int getCornerNumber() {
        double myX = this.me.getX();
        double myY = this.me.getY();
        double fieldWidth = this.me.getBattleFieldWidth();
        double fieldHeight = this.me.getBattleFieldHeight();
        if (myX < 130.0 && myY < 130.0) {
            return 1;
        }
        if (myX > fieldWidth - 130.0 && myY > fieldHeight - 130.0) {
            return 3;
        }
        if (myX < 130.0 && myY > fieldHeight - 130.0) {
            return 2;
        }
        if (myX > fieldWidth - 130.0 && myY < 130.0) {
            return 4;
        }
        return 0;
    }

    private final int getEdgeNumber() {
        double myX = this.me.getX();
        double myY = this.me.getY();
        double fieldWidth = this.me.getBattleFieldWidth();
        double fieldHeight = this.me.getBattleFieldHeight();
        if (myX < 130.0) {
            return 1;
        }
        if (myY < 130.0) {
            return 4;
        }
        if (myX > fieldWidth - 130.0) {
            return 3;
        }
        if (myY > fieldHeight - 130.0) {
            return 2;
        }
        return 0;
    }

    private final boolean angleToSteep(int cn, long dir) {
        double mh = this.me.getHeading();
        if (dir == (long)-1) {
            mh = this.normDeg(mh - 180.0);
        }
        switch (cn) {
            case 1: {
                boolean bl = false;
                if (mh < 300.0 && mh > 240.0) {
                    bl = true;
                }
                return bl;
            }
            case 4: {
                boolean bl = false;
                if (mh < 210.0 && mh > 150.0) {
                    bl = true;
                }
                return bl;
            }
            case 3: {
                boolean bl = false;
                if (mh > 60.0 && mh < 110.0) {
                    bl = true;
                }
                return bl;
            }
            case 2: {
                boolean bl = false;
                if (mh < 30.0 || mh > 330.0) {
                    bl = true;
                }
                return bl;
            }
        }
        return false;
    }

    private final void turnFromEdge(int number) {
        double fieldWidth = this.me.getBattleFieldWidth();
        double fieldHeight = this.me.getBattleFieldHeight();
        long dir = Math.round(this.me.getVelocity() / Math.abs(this.me.getVelocity()));
        if (dir == 0L) {
            if (this.me.getDistanceRemaining() != 0.0) {
                dir = Math.round(this.me.getDistanceRemaining() / Math.abs(this.me.getDistanceRemaining()));
            } else {
                dir = 1L;
                this.turnAway(this.getBearingTo(fieldWidth / (double)2, fieldHeight / (double)2) - 90.0 + (double)(45L * dir));
                this.me.setAhead(300.0);
            }
        }
        if (this.angleToSteep(number, dir)) {
            this.me.setMaxVelocity((double)3);
        }
        this.turnAway(this.getBearingTo(fieldWidth / (double)2, fieldHeight / (double)2) - 90.0 + (double)(30L * dir));
    }

    private final void turnAway(double bearing) {
        if (bearing < 180.0) {
            if (360.0 - (bearing + 180.0) < bearing) {
                this.turnToBearing(180.0 + bearing);
            } else {
                this.turnToBearing(bearing);
            }
        } else if (360.0 - bearing < bearing - 180.0) {
            this.turnToBearing(bearing - 180.0);
        } else {
            this.turnToBearing(bearing);
        }
    }

    public void turnToBearing(double bearing) {
        if (bearing < 180.0) {
            this.me.setTurnRight(bearing);
        } else {
            this.me.setTurnRight(bearing - 360.0);
        }
    }

    protected double getBearingTo(double heading) {
        return this.normDeg(heading - this.me.getHeading());
    }

    protected double getBearingTo(double x, double y) {
        double myX = this.me.getX();
        double myY = this.me.getY();
        double dx = Math.abs(x - myX);
        double dy = Math.abs(y - myY);
        double bearing = 0.0;
        if (x > myX && y > myY) {
            bearing = Math.atan(dx / dy);
        } else if (x > myX && y < myY) {
            bearing = 1.5707963267948966 + Math.atan(dy / dx);
        } else if (x < myX && y < myY) {
            bearing = Math.PI + Math.atan(dx / dy);
        } else if (x < myX && y > myY) {
            bearing = 4.71238898038469 + Math.atan(dy / dx);
        }
        bearing = Math.toDegrees(bearing);
        bearing = this.normDeg(bearing - this.me.getHeading());
        return bearing;
    }

    private final double normDeg(double deg) {
        if (deg < 0.0) {
            return this.normDeg(deg + 360.0);
        }
        if (deg >= 360.0) {
            return this.normDeg(deg - 360.0);
        }
        return deg;
    }

    private final void eChangeDir() {
        if (this.target != null) {
            double eBear = this.target.getBearing();
            if (this.target.getDistance() < 500.0) {
                if (this.dir == -1) {
                    if (eBear < -120.0 || eBear > 120.0) {
                        this.dir = 1;
                    }
                } else if (this.dir == 1 && eBear > -60.0 && eBear < 60.0) {
                    this.dir = -1;
                }
            }
        }
    }

    public void onHitWall(HitWallEvent e) {
        double wb = e.getBearing();
        if (wb > 135.0 || wb < -135.0) {
            this.me.setAhead(200.0);
        } else if (wb < 45.0 && wb > -45.0) {
            this.me.setAhead(-200.0);
        }
    }

    private final /* synthetic */ void this() {
        this.me = null;
        this.wallDistance = 130.0;
    }

    public PerceptWallAvoider4(AdvancedRobot me) {
        this.this();
        this.me = me;
    }
}

