/*
 * Decompiled with CFR 0.152.
 */
package gtf.robocode;

import robocode.ScannedRobotEvent;

class RobotData {
    int id;
    String name;
    long time;
    double x;
    double y;
    double energy;
    double vx;
    double vy;

    RobotData(long time, String name, double x, double y, double energy, double speed, double headingRadians) {
        this.time = time;
        this.name = name;
        this.x = x;
        this.y = y;
        this.energy = energy;
        this.vx = speed * Math.sin(headingRadians);
        this.vy = speed * Math.cos(headingRadians);
    }

    public static RobotData convert(long time, double myX, double myY, double myHeading, ScannedRobotEvent event) {
        double myHeadingRadians = Math.toRadians(myHeading);
        double distance = event.getDistance();
        double absoluteBearingRadians = event.getBearingRadians() + myHeadingRadians;
        double x = myX + distance * Math.sin(absoluteBearingRadians);
        double y = myY + distance * Math.cos(absoluteBearingRadians);
        return new RobotData(time, event.getName(), x, y, event.getEnergy(), event.getVelocity(), event.getHeadingRadians());
    }

    public double distance(RobotData data) {
        double dx = this.x - data.x;
        double dy = this.y - data.y;
        return Math.sqrt(dx * dx + dy * dy);
    }
}

