/*
 * Decompiled with CFR 0.152.
 */
package synapse;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.Event;
import robocode.Rules;
import robocode.WinEvent;
import robocode.util.Utils;
import synapse.BaseBot;
import synapse.BulletCondition;
import synapse.Gun;
import synapse.Module;
import synapse.Segmentation;
import synapse.Util;
import synapse.Wave;
import synapse.segmentation.Acceleration;
import synapse.segmentation.Axis;
import synapse.segmentation.BulletFlightTime;
import synapse.segmentation.LastStopped;
import synapse.segmentation.Orthogonality;
import synapse.segmentation.Velocity;

public class GunAutoSegmented
extends Module
implements Gun {
    private static LinkedList<Axis> axes;
    private static Segmentation[] segments;
    private static final int NUM_WAVEBUCKETS = 32;
    private static final float FIRED_WAVE_WEIGHT = 1.0f;
    private static final float INITIAL_NON_FIRED_WAVE_WEIGHT = 0.15f;
    private static float nonFiredWaveWeight;
    private static final float INITIAL_NORMAL_POWER = 2.0f;
    private static float normalPower;
    private static float BIN_SMOOTHING_VALUE;
    private BaseBot bot;
    private float power;
    private float firingGuessFactor;
    private int firingSegmentation;
    private int firingSegment;
    private TreeSet<Wave> waves = new TreeSet();
    private Point2D.Double locationNextTurn;

    static {
        nonFiredWaveWeight = 0.15f;
        normalPower = 2.0f;
        BIN_SMOOTHING_VALUE = 2.25f;
    }

    public GunAutoSegmented(BaseBot bot) {
        this.bot = bot;
        if (segments == null) {
            axes = new LinkedList();
            axes.add(new Velocity(12));
            axes.add(new LastStopped(10));
            axes.add(new Orthogonality(6));
            axes.add(new Acceleration());
            axes.add(new BulletFlightTime());
            segments = new Segmentation[1 << axes.size()];
            int i = 0;
            while (i < segments.length) {
                LinkedList<Axis> segAx = new LinkedList<Axis>();
                int j = 0;
                while (j < axes.size()) {
                    if ((i & 1 << j) > 0) {
                        segAx.add(axes.get(j));
                    }
                    ++j;
                }
                float depth = 100.0f - 50.0f * (float)(segAx.size() / axes.size());
                GunAutoSegmented.segments[i] = new Segmentation(32, segAx.toArray(new Axis[0]), depth, false);
                ++i;
            }
        } else {
            Segmentation[] segmentationArray = segments;
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                Segmentation s = segmentationArray[n2];
                s.clearHits();
                ++n2;
            }
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }

    private void doAiming(boolean firing) {
        if (!firing) {
            this.bot.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(Util.absoluteBearing(this.bot.location, this.bot.target.location) - this.bot.getGunHeadingRadians())));
        } else {
            float bestFitness = 0.0f;
            int s = 0;
            while (s < segments.length) {
                int index = segments[s].getIndex(this.bot.target);
                float fit = segments[s].getFitness(index);
                if (fit > bestFitness) {
                    this.firingSegmentation = s;
                    this.firingSegment = index;
                    bestFitness = fit;
                }
                ++s;
            }
            this.firingGuessFactor = segments[this.firingSegmentation].getBestGuessFactor(this.firingSegment);
            double scaledPower = normalPower;
            this.power = (float)Math.max(0.1, Math.min(this.bot.target.energy / 4.0, (this.bot.getEnergy() < 25.0 ? this.bot.getEnergy() / 25.0 : 1.0) * Util.limit(0.1, this.bot.target.distance * (2.0 * scaledPower - 6.0) / this.bot.preferredDistance + 6.0 - scaledPower, 3.0)));
            double maxBearing = Math.abs(Math.asin(8.0 / Rules.getBulletSpeed((double)this.power)));
            int clockwise = this.bot.target.velocity * Math.sin(this.bot.target.heading - Util.absoluteBearing(this.bot.target.location, this.locationNextTurn)) > 0.0 ? -1 : 1;
            double leadRadians = (double)((float)clockwise * this.firingGuessFactor) * maxBearing;
            double absBearing = this.bot.target.bearing + this.bot.heading;
            this.bot.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absBearing + leadRadians - this.bot.getGunHeadingRadians())));
        }
    }

    @Override
    public void doTick() {
        if (this.active) {
            this.locationNextTurn = new Point2D.Double();
            this.locationNextTurn.setLocation(this.bot.location);
            this.locationNextTurn.x += this.bot.getVelocity() * Math.cos(this.bot.getHeadingRadians());
            this.locationNextTurn.y += this.bot.getVelocity() * Math.sin(this.bot.getHeadingRadians());
            this.adjustParameters();
            int clockwise = this.bot.target.velocity * Math.sin(this.bot.target.heading - Util.absoluteBearing(this.bot.target.location, this.bot.location)) > 0.0 ? -1 : 1;
            boolean wasFired = false;
            if (this.bot.getGunHeat() == 0.0 && Utils.isNear((double)this.bot.getGunTurnRemaining(), (double)0.0) && this.power > 0.0f && this.bot.getEnergy() > (double)this.power && this.bot.target != null && !Utils.isNear((double)this.bot.target.energy, (double)0.0) && this.bot.target.name != null && !this.bot.target.name.contains("wiki.challenge.WaveSurfingChallengeBot")) {
                this.bot.setFire(this.power);
                wasFired = true;
                this.bot.totalPowerFired += (double)this.power;
                ++this.bot.shotsFired;
                ++BaseBot.shotsFiredBattle;
                this.bot.target.lastIncomingBulletFlightTime = (int)(this.bot.target.distance / Rules.getBulletSpeed((double)this.power));
            } else if (this.bot.getGunHeat() > this.bot.getGunCoolingRate()) {
                this.doAiming(false);
            } else if (this.bot.getGunTurnRemaining() <= 20.0) {
                this.doAiming(true);
            }
            int[] indices = new int[segments.length];
            int i = 0;
            while (i < segments.length) {
                indices[i] = segments[i].getIndex(this.bot.target);
                ++i;
            }
            Wave newest = new Wave(this.locationNextTurn, this.bot.target.location, this.bot.time, this.power, clockwise, this.firingSegmentation, indices, this.firingSegment);
            if (wasFired) {
                newest.setFired(this.firingGuessFactor);
            }
            this.waves.add(newest);
        }
        this.manageWaves();
    }

    private void manageWaves() {
        long time = this.bot.time;
        Iterator<Wave> i = this.waves.iterator();
        while (i.hasNext()) {
            Wave w = i.next();
            if (!((double)(time - w.ctime) * w.velocity - 20.0 > w.origin.distance(this.bot.target.location))) continue;
            int j = 0;
            Segmentation[] segmentationArray = segments;
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                Segmentation s = segmentationArray[n2];
                s.registerHit((float)Wave.getGuessFactor(w, this.bot.target.location.x, this.bot.target.location.y), w.indices[j], w.getFired() && j == w.segmentation, w.getFired() ? 1.0f : nonFiredWaveWeight, BIN_SMOOTHING_VALUE);
                ++j;
                ++n2;
            }
            if (w.getHit() == BulletCondition.ARRIVING) {
                w.setHit(BulletCondition.MISSED_TARGET);
            }
            i.remove();
        }
    }

    private void adjustParameters() {
    }

    @Override
    public void useEvent(Event e) {
        if (e instanceof BulletHitEvent) {
            BulletHitEvent evt = (BulletHitEvent)e;
            this.markHit(evt.getBullet(), BulletCondition.HIT_TARGET);
        } else if (e instanceof BulletHitBulletEvent) {
            this.markHit(((BulletHitBulletEvent)e).getBullet(), BulletCondition.HIT_BULLET);
        } else if (e instanceof DeathEvent || e instanceof WinEvent) {
            System.out.println("Non-firing wave weight: " + Math.floor(100.0f * nonFiredWaveWeight) / 100.0);
        }
    }

    private void markHit(Bullet bullet, BulletCondition bulletCondition) {
        for (Wave w : this.waves) {
            if (!w.getFired() || !Utils.isNear((double)bullet.getVelocity(), (double)w.velocity) || !Utils.isNear((double)bullet.getPower(), (double)w.power) || !(Math.abs(w.origin.distance(bullet.getX(), bullet.getY()) - (double)(this.bot.time - w.ctime) * w.velocity) < 20.0)) continue;
            if (bulletCondition == BulletCondition.HIT_TARGET) {
                segments[w.segmentation].registerSuccess(w.bestSegment);
            }
            w.setHit(bulletCondition);
        }
    }

    @Override
    public void doPaint(Graphics2D g) {
        if (!this.active) {
            return;
        }
        g.setStroke(new BasicStroke(0.0f));
        double bright = 0.0;
        if (this.bot.getOthers() == 1) {
            double time = this.bot.getTime();
            for (Wave w : this.waves) {
                if (!w.getFired()) continue;
                double radius = (time - (double)w.ctime) * w.velocity;
                double arcSegment = w.extent / 32.0;
                float[] buckets = segments[w.segmentation].getBuckets(w.bestSegment);
                float max = segments[w.segmentation].getMaximum(w.bestSegment);
                int i = 0;
                while (i < 32) {
                    Color waveColor;
                    double segmentHeading = w.heading + (double)w.clockwise * (arcSegment * (double)i - w.extent / 2.0);
                    bright = buckets[i] / max;
                    switch (w.getHit()) {
                        case HIT_TARGET: {
                            waveColor = new Color(0, 255, 0, (int)(255.0 * (0.5 + 0.5 * bright)));
                            break;
                        }
                        case HIT_BULLET: {
                            waveColor = new Color(0, 0, 255, (int)(255.0 * (0.25 + 0.75 * bright)));
                            break;
                        }
                        default: {
                            waveColor = new Color(255, 77, 0, (int)(255.0 * (0.25 + 0.75 * bright)));
                        }
                    }
                    g.setColor(waveColor);
                    bright *= 2.0;
                    int thickness = 3;
                    g.fillPolygon(new int[]{(int)(w.origin.x + (radius + 3.0 + 3.0) * Math.sin(segmentHeading)), (int)(w.origin.x + (radius + 3.0) * Math.sin(segmentHeading)), (int)(w.origin.x + (radius + 3.0) * Math.sin(segmentHeading + arcSegment)), (int)(w.origin.x + (radius + 3.0 + 3.0) * Math.sin(segmentHeading + arcSegment))}, new int[]{(int)(w.origin.y + (radius + 3.0 + 3.0) * Math.cos(segmentHeading)), (int)(w.origin.y + (radius + 3.0) * Math.cos(segmentHeading)), (int)(w.origin.y + (radius + 3.0) * Math.cos(segmentHeading + arcSegment)), (int)(w.origin.y + (radius + 3.0 + 3.0) * Math.cos(segmentHeading + arcSegment))}, 4);
                    ++i;
                }
                g.setColor(new Color(255, 255, 255, 127));
                String[] seg = segments[w.segmentation].toString().split(" / ");
                int i2 = 0;
                while (i2 < seg.length) {
                    g.drawString(seg[i2], (int)(w.origin.x + (radius + 2.0) * Math.sin(w.heading + w.extent / 2.0)), (int)(w.origin.y + (radius + 2.0) * Math.cos(w.heading + w.extent / 2.0)) - 12 * i2);
                    ++i2;
                }
            }
        }
    }
}

