/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import pa3k.BulletTracking;
import pa3k.Log;
import pa3k.Opponent;
import pa3k.Position;
import pa3k.RobotModule;
import pa3k.Tracking;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.Rules;
import robocode.util.Utils;

public abstract class Gun
extends RobotModule {
    protected Opponent target = null;
    protected Tracking tracking;
    protected int waiting;
    private int toFire;
    protected BulletTracking newBullet;

    public Gun(AdvancedRobot advancedRobot, Tracking tracking) {
        super(advancedRobot);
        this.tracking = tracking;
        this.toFire = 0;
        this.waiting = 0;
        this.newBullet = null;
    }

    public Opponent getTarget() {
        return this.target;
    }

    @Override
    public void turn() {
        Position position = new Position((Robot)this.robot);
        if (this.target != null && !this.target.isDead() && this.target.getLastEnergy() < 0.1 && this.robot.getGunHeat() == 0.0 && position.distance(this.target.getLastPosition()) > 500.0) {
            position.modify(1L, this.robot.getVelocity(), this.robot.getHeadingRadians());
            this.newBullet = new BulletTracking(0.1, position, this.target, this.tracking, this.robot.getTime());
            this.newBullet.setFiringAngle(position.getDirectionTo(this.target.getLastPosition()));
            return;
        }
        if (this.newBullet != null) {
            double d = this.robot.getGunHeadingRadians();
            this.newBullet.adjustForBulletCatchers();
            d = Utils.normalRelativeAngle((double)(this.newBullet.getFiringAngle() - d));
            this.robot.setTurnGunRightRadians(d);
            if (this.robot.getGunHeat() > 0.0) {
                Log.log(1, "Trying to fire from heated gun");
                this.newBullet = null;
            } else if (this.toFire == 1) {
                if (this.robot.getGunTurnRemainingRadians() == 0.0) {
                    Bullet bullet = this.robot.setFireBullet(this.newBullet.getEnergy());
                    if (bullet != null) {
                        this.newBullet.setValues(bullet, this.robot.getTime());
                        this.tracking.bulletFired(this.newBullet, this.target);
                    }
                } else {
                    Log.log(2, "Missed fire, gun not turned");
                    this.waiting = 0;
                }
                this.toFire = 0;
                this.newBullet = null;
            } else {
                this.toFire = 1;
            }
        } else if (this.target != null) {
            Position position2 = new Position((Robot)this.robot);
            double d = this.robot.getGunHeadingRadians();
            d = Utils.normalRelativeAngle((double)(position2.getDirectionTo(this.target.getLastPosition()) - d));
            if (d > 1.0471975511965976) {
                this.robot.setTurnGunRightRadians(Rules.GUN_TURN_RATE_RADIANS);
            } else if (d < -1.0471975511965976) {
                this.robot.setTurnGunRightRadians(-Rules.GUN_TURN_RATE_RADIANS);
            }
        }
    }

    public void robotDeath(RobotDeathEvent robotDeathEvent) {
        Opponent opponent = this.tracking.getByName(robotDeathEvent.getName());
        if (opponent == this.target) {
            this.target = null;
        }
    }

    public void hitRobot(Opponent opponent) {
        this.tracking.setOpponentOfInterest(this.target);
        this.target = opponent;
    }
}

