/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import pa3k.Gun;
import pa3k.Log;
import pa3k.MonteCarlo;
import pa3k.MonteCarloAiming;
import pa3k.Opponent;
import pa3k.Position;
import pa3k.Tracking;
import robocode.AdvancedRobot;
import robocode.Robot;

public class MonteCarloGun
extends Gun {
    protected int waiting;
    protected double lastHitProbability;
    protected long targetReevaluate;
    protected MonteCarlo mc;

    public MonteCarloGun(AdvancedRobot advancedRobot, Tracking tracking, MonteCarlo monteCarlo) {
        super(advancedRobot, tracking);
        this.mc = monteCarlo;
    }

    @Override
    public void init() {
        this.waiting = 0;
        this.lastHitProbability = 0.0;
    }

    @Override
    public void turn() {
        int n;
        Position position = new Position((Robot)this.robot);
        position.modify(1L, this.robot.getVelocity(), this.robot.getHeadingRadians());
        if (this.targetReevaluate <= 0L || this.target == null || this.target.lastSeen(this.robot.getTime()) > 3L) {
            this.targetReevaluate = 30L;
            Object[] objectArray = this.tracking.getTargets();
            if (objectArray.length > 0) {
                this.target = (Opponent)objectArray[0];
            }
            if (this.target != null) {
                this.tracking.setOpponentOfInterest(this.target);
                Log.log(2, "Targeting " + this.target + " random hit probability " + this.lastHitProbability);
            }
        }
        if (this.target != null && this.newBullet == null && (n = this.target.getScanPriority(this.robot.getTime())) != -1 && n < 2) {
            double d = MonteCarloAiming.getRandomHitProbability(this.mc, 1.8, position);
            assert (d != Double.NaN);
            if (this.robot.getGunHeat() == 0.0 && (this.waiting == 0 || d > 0.11)) {
                double d2 = 1.8;
                if (d > 0.15) {
                    d2 = 2.4;
                }
                if (d > 0.2) {
                    d2 = 3.0;
                }
                if (d < 0.1) {
                    d2 = 0.6;
                }
                if (d2 > this.robot.getEnergy() - 0.1) {
                    d2 = this.robot.getEnergy() - 0.1;
                }
                if (d2 >= 0.1) {
                    double d3 = this.target.getLastEnergy() / 4.0;
                    if (d3 < d2 && (d2 = d3) < 0.1) {
                        d2 = 0.1;
                    }
                    this.newBullet = this.target.getSelfAiming().getBestAimingAngle(position, this.target, this.tracking, d2, this.robot.getTime());
                    Log.log(2, "Firing at " + this.target + " monte carlo hit probability " + d);
                    this.waiting = 15;
                }
            } else if (this.waiting > 0) {
                --this.waiting;
            }
            this.lastHitProbability = d;
        }
        --this.targetReevaluate;
        super.turn();
    }
}

