/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.awt.Color;
import pa3k.AngleUtils;
import pa3k.BulletTracking;
import pa3k.CalendarMoving;
import pa3k.CalendarMovingTask;
import pa3k.Log;
import pa3k.Opponent;
import pa3k.Position;
import pa3k.TaskExecutor;
import pa3k.Tracking;
import robocode.AdvancedRobot;
import robocode.Robot;
import robocode.util.Utils;

public class WaveSurfing
extends CalendarMoving
implements TaskExecutor {
    protected BulletTracking wave = null;

    public WaveSurfing(AdvancedRobot advancedRobot, Tracking tracking) {
        super(advancedRobot, tracking);
    }

    @Override
    public void turn() {
        Position position = new Position((Robot)this.robot);
        BulletTracking bulletTracking = this.tracking.getClosestBullet();
        if (bulletTracking != this.wave && bulletTracking != null) {
            int n;
            int n2;
            int n3;
            int n4;
            this.wave = bulletTracking;
            long l = this.robot.getTime();
            double[] dArray = this.wave.getEscapeBins();
            Opponent opponent = this.wave.getOwner();
            double d = this.wave.getETA(position) - l - 1L;
            double d2 = position.distance(opponent.getLastPosition());
            double d3 = opponent.getLastPosition().getDirectionTo(position);
            double d4 = this.robot.getVelocity() * (double)this.direction;
            if (d4 < 0.0) {
                d4 *= -1.0;
                this.direction *= -1;
            }
            double d5 = position.projectAngle((long)d, 8.0, d4, opponent, 0, false);
            double d6 = position.projectAngle((long)d, 8.0, d4, opponent, 1, false);
            double d7 = position.projectAngle((long)d, 0.0, d4, opponent, 0, false);
            double d8 = position.projectAngle((long)d, 8.0, d4, opponent, 0, true);
            double d9 = position.projectAngle((long)d, 8.0, d4, opponent, 1, true);
            double d10 = position.projectAngle(2L * (long)d / 3L, 8.0, d4, opponent, 0, true);
            double d11 = position.projectAngle(2L * (long)d / 3L, 8.0, d4, opponent, 1, true);
            Position[] positionArray = new Position[7];
            int n5 = positionArray.length;
            n5 = dArray.length >= 11 ? positionArray.length : (dArray.length >= 9 ? 5 : (dArray.length >= 6 ? 3 : 2));
            for (n4 = 0; n4 < positionArray.length; ++n4) {
                positionArray[n4] = new Position(this.wave.getOwner().getLastPosition());
            }
            n4 = this.direction;
            if (AngleUtils.difference(position.getDirectionTo(this.wave.getSource()), this.robot.getHeadingRadians()) < 0.0) {
                n4 *= -1;
            }
            positionArray[0].modify(1L, d2, Utils.normalAbsoluteAngle((double)(d3 + (double)n4 * d5)));
            positionArray[1].modify(1L, d2, Utils.normalAbsoluteAngle((double)(d3 + (double)n4 * d6)));
            positionArray[2].modify(1L, d2, Utils.normalAbsoluteAngle((double)(d3 + d7)));
            positionArray[3].modify(1L, d2, Utils.normalAbsoluteAngle((double)(d3 + (double)n4 * d8)));
            positionArray[4].modify(1L, d2, Utils.normalAbsoluteAngle((double)(d3 + (double)n4 * d9)));
            positionArray[5].modify(1L, d2, Utils.normalAbsoluteAngle((double)(d3 + (double)n4 * d10)));
            positionArray[6].modify(1L, d2, Utils.normalAbsoluteAngle((double)(d3 + (double)n4 * d11)));
            double d12 = this.wave.getAngleAdvance();
            int[] nArray = new int[n5];
            for (n3 = 0; n3 < nArray.length; ++n3) {
                nArray[n3] = (int)(AngleUtils.difference(this.wave.getSource().getDirectionTo(positionArray[n3]), this.wave.getNegativeAngle() - d12 / 2.0) / d12);
                if (nArray[n3] < 0) {
                    nArray[n3] = 0;
                }
                if (nArray[n3] < dArray.length) continue;
                nArray[n3] = dArray.length - 1;
            }
            n3 = 0;
            for (n2 = 1; n2 < n5; ++n2) {
                if (!(positionArray[n2].getWallDistance() < positionArray[n3].getWallDistance())) continue;
                n3 = n2;
            }
            if (positionArray[n3].getWallDistance() < 100.0) {
                Log.log(3, "Deleting the idx " + n3 + " as it is too close to the wall");
                dArray[nArray[n3]] = 100000.0;
            }
            n2 = 0;
            for (n = 1; n < nArray.length; ++n) {
                if (dArray[nArray[n]] <= dArray[nArray[n2]]) {
                    n2 = n;
                }
                Log.paintFilledCircle(3, positionArray[n], 20, new Color(255, 100, 100, 50), (int)d / 3);
            }
            n = -1;
            for (int i = 0; i < nArray.length; ++i) {
                if (i == n2 || n != -1 && !(dArray[nArray[i]] <= dArray[nArray[n]])) continue;
                n = i;
            }
            if (Utils.getRandom().nextDouble() < 0.5) {
                n2 = n;
            }
            Log.paintFilledCircle(2, positionArray[n2], 20, new Color(255, 100, 100, 100), (int)d);
            switch (n2) {
                case 0: {
                    this.setMaxSpeed(8.0);
                    Log.log(3, "Full speed ahead");
                    break;
                }
                case 1: {
                    this.setMaxSpeed(8.0);
                    this.direction *= -1;
                    Log.log(3, "Full speed backwards");
                    break;
                }
                case 2: {
                    this.setMaxSpeed(0.0);
                    Log.log(3, "Stop");
                    break;
                }
                case 3: {
                    this.setMovingBudget(Math.abs(d8), this.wave.getSource());
                    Log.log(3, "Forward with stop");
                    break;
                }
                case 4: {
                    this.setMovingBudget(Math.abs(d9), this.wave.getSource());
                    this.direction *= -1;
                    Log.log(3, "Backward with stop");
                    break;
                }
                case 5: {
                    this.setMovingBudget(Math.abs(d10), this.wave.getSource());
                    Log.log(3, "Slow forward");
                    break;
                }
                case 6: {
                    this.setMovingBudget(Math.abs(d11), this.wave.getSource());
                    this.direction *= -1;
                    Log.log(3, "Slow backward");
                }
            }
            if (dArray.length > 4) {
                this.setPivot(new Position(opponent.getLastPosition()));
            }
        }
        if (this.wave != null && this.wave.getEvaded()) {
            this.setPivot(null);
            this.setMaxSpeed(8.0);
        }
        super.turn();
    }

    @Override
    public void execute(CalendarMoving calendarMoving, CalendarMovingTask calendarMovingTask) {
        this.direction *= -1;
    }
}

