/*
 * Decompiled with CFR 0.152.
 */
package techdude.forest;

import java.util.ArrayList;
import techdude.forest.EnemyFiredListener;
import techdude.forest.FlamingForest;
import techdude.forest.Pattern;
import techdude.forest.PatternAnalyzer;
import techdude.forest.TechDudeRecord;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class TechDudeRecordCollection {
    private static final int MAX_UNDETECTED_TARGET_TURNS = 20;
    protected static final String TechDude_BOT = "FlamingForest";
    private static EnemyFiredListener m_listener = null;
    private int MAX_STACK_SIZE;
    private TechDudeRecord[] allInformation;
    private int next;
    private int size;
    private FlamingForest m_owner;
    private Pattern m_movePattern;

    public void setPattern(Pattern in_newPattern) {
        this.m_movePattern = in_newPattern != null ? in_newPattern : PatternAnalyzer.DEFAULT;
    }

    public Pattern getPattern() {
        return this.m_movePattern;
    }

    public static void setEnemyFireListener(EnemyFiredListener in_listener) {
        m_listener = in_listener;
    }

    protected void fireEnemyFiredEvent() {
        if (m_listener != null) {
            m_listener.enemyFired(this.get(0));
        }
    }

    public void addTechDudeRecord(TechDudeRecord in_new) {
        TechDudeRecord lastTechDudeRecord = this.get(0);
        if (lastTechDudeRecord != null && lastTechDudeRecord.getLife() - in_new.getLife() <= (double)3 && lastTechDudeRecord.getLife() - in_new.getLife() >= 0.1) {
            this.fireEnemyFiredEvent();
        }
        this.size = this.size == this.MAX_STACK_SIZE ? this.size : this.size + 1;
        this.allInformation[this.next] = in_new;
        this.next = (this.next + 1) % this.MAX_STACK_SIZE;
    }

    public TechDudeRecord get(int in_index) {
        int index = this.next - in_index - 1;
        if (index < 0) {
            index += this.MAX_STACK_SIZE;
        }
        return this.allInformation[index];
    }

    protected TechDudeRecord[] toArray() {
        TechDudeRecord[] out_array = new TechDudeRecord[this.size];
        int iCounter = 0;
        while (iCounter < this.size) {
            out_array[iCounter] = this.get(iCounter);
            ++iCounter;
        }
        return out_array;
    }

    public void clear() {
        this.allInformation = new TechDudeRecord[this.MAX_STACK_SIZE];
        this.next = 0;
        this.size = 0;
    }

    public int getInformationCount() {
        return this.size;
    }

    public boolean notMovingForTerms(int in_numberOfTerms) {
        int iCounter = 0;
        while (iCounter < in_numberOfTerms) {
            if (this.get(iCounter) == null || this.get(iCounter).getVelocity() != 0.0) {
                return false;
            }
            ++iCounter;
        }
        return true;
    }

    public boolean isCurrent() {
        if (this.get(0) != null) {
            boolean bl = false;
            if (this.m_owner.getTime() - this.get(0).getTime() <= 20L && this.m_owner.getRoundNum() == this.get(0).getRoundNum()) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public boolean isTechDude() {
        return this.get(0) != null && this.get(0).getName().startsWith(TechDude_BOT);
    }

    public TechDudeRecord[] getLatestStrand() {
        if (this.isCurrent()) {
            ArrayList<TechDudeRecord> out_list = new ArrayList<TechDudeRecord>(this.MAX_STACK_SIZE);
            int currentIndex = -1;
            TechDudeRecord[] out_TechDudeRecord = null;
            do {
                out_list.add(this.get(++currentIndex));
            } while (currentIndex + 1 < this.MAX_STACK_SIZE && this.get(currentIndex + 1) != null && this.get(currentIndex).getTime() - this.get(currentIndex + 1).getTime() <= 20L && this.m_owner.getRoundNum() == this.get(currentIndex + 1).getRoundNum());
            out_TechDudeRecord = new TechDudeRecord[out_list.size()];
            int iCounter = 0;
            while (iCounter < out_list.size()) {
                out_TechDudeRecord[iCounter] = (TechDudeRecord)out_list.get(iCounter);
                ++iCounter;
            }
            return out_TechDudeRecord;
        }
        return null;
    }

    private final /* synthetic */ void this() {
        this.MAX_STACK_SIZE = 50;
        this.allInformation = new TechDudeRecord[this.MAX_STACK_SIZE];
        this.next = 0;
        this.size = 0;
        this.m_owner = null;
        this.m_movePattern = PatternAnalyzer.DEFAULT;
    }

    public TechDudeRecordCollection(FlamingForest in_owner) {
        this.this();
        this.m_owner = in_owner;
    }
}

