/*
 * Decompiled with CFR 0.152.
 */
package rampancy.util.weapon;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.util.Arrays;
import rampancy.standard.RDefaultSegmentTree;
import rampancy.util.RDrawableObject;
import rampancy.util.REnemyRobot;
import rampancy.util.RPoint;
import rampancy.util.RRobotState;
import rampancy.util.RUtil;
import rampancy.util.data.segmentTree.RSTNode;
import rampancy.util.wave.RBulletWave;
import rampancy.util.weapon.RFiringSolution;
import rampancy.util.weapon.RGun;
import robocode.util.Utils;

public class RGFGun
extends RGun {
    public static final String GF_GUN = "guess factor gun";
    private RDefaultSegmentTree segmentTree = new RDefaultSegmentTree();

    public RGFGun() {
        super(GF_GUN);
    }

    public RFiringSolution getFiringSolution(REnemyRobot enemy) {
        RRobotState enemyState = enemy.getCurrentState();
        RSTNode leaf = this.segmentTree.getSegmentForState(enemyState);
        int bestIndex = RUtil.indexOfLargest(leaf.getGuessFactors());
        double guessFactor = RUtil.getGuessFactorForIndex(bestIndex, leaf.getGuessFactors().length);
        double power = enemy.getCurrentState().distance < 100.0 ? 3.0 : (1.0 - enemy.getCurrentState().distance / 1500.0) * 3.0;
        power = RUtil.limit(0.1, power, 3.0);
        double offsetAngle = (double)enemyState.directionTraveling * guessFactor * RUtil.computeMaxEscapeAngle(RUtil.computeBulletVelocity(power));
        offsetAngle = Utils.normalRelativeAngle((double)offsetAngle);
        double maxPreciseEscapeAngle = RUtil.computePreciceMaxEscapeAngle(RUtil.computeBulletVelocity(power), enemy.getReference(), enemy, RUtil.nonZeroSign((double)enemyState.directionTraveling * guessFactor));
        double preciseOffsetAngle = (double)enemyState.directionTraveling * guessFactor * maxPreciseEscapeAngle;
        preciseOffsetAngle = Utils.normalRelativeAngle((double)preciseOffsetAngle);
        double gunBearingToTarget = enemyState.absoluteBearing - enemy.getReference().getGunHeadingRadians();
        gunBearingToTarget = Utils.normalRelativeAngle((double)gunBearingToTarget);
        GFDrawableObject drawableObject = new GFDrawableObject(leaf.getGuessFactors());
        return new RFiringSolution(null, power, gunBearingToTarget + preciseOffsetAngle, 0.0, guessFactor, Color.green, this, drawableObject);
    }

    public void update(RBulletWave wave) {
        super.update(wave);
        RSTNode leaf = this.segmentTree.getSegmentForState(wave.getTargetState());
        double desiredDirection = RUtil.computeAbsoluteBearing(wave.getOrigin(), wave.getTarget().getLastState().location);
        double angleOffset = Utils.normalRelativeAngle((double)(desiredDirection - wave.getTargetState().absoluteBearing));
        double guessFactor = Math.max(-1.0, Math.min(1.0, angleOffset / RUtil.computeMaxEscapeAngle(wave.getVelocity()))) * (double)wave.getTargetState().directionTraveling;
        int index = RUtil.computeBin(guessFactor, leaf.getGuessFactors().length);
        RSTNode.updateGuessFactors(leaf, index, 3.0, 2);
    }

    class GFDrawableObject
    implements RDrawableObject {
        public double[] guessFactors;
        public GeneralPath curve;
        public double max;
        public int max_index;

        public GFDrawableObject(double[] guessFactors) {
            this.guessFactors = Arrays.copyOf(guessFactors, guessFactors.length);
            this.max = 0.0;
            this.max_index = 0;
            int i = 0;
            while (i < guessFactors.length) {
                if (guessFactors[i] > this.max) {
                    this.max = guessFactors[i];
                    this.max_index = i;
                }
                ++i;
            }
            if (this.max != 0.0) {
                i = 0;
                while (i < guessFactors.length) {
                    this.guessFactors[i] = guessFactors[i] / this.max * 200.0;
                    ++i;
                }
            }
            this.curve = new GeneralPath(0, guessFactors.length);
            this.curve.moveTo(0.0f, 0.0f);
            i = 0;
            while (i < guessFactors.length) {
                this.curve.lineTo(i * 12 + 10, (int)Math.round(this.guessFactors[i]));
                ++i;
            }
        }

        public void draw(Graphics2D g) {
            Color lastColor = g.getColor();
            g.setColor(Color.white);
            g.draw(this.curve);
            g.setColor(Color.red);
            RUtil.drawOval(new RPoint(this.max_index * 12 + 10, this.guessFactors[this.max_index]), 3, g);
            g.setColor(lastColor);
        }
    }
}

