/*
 * Decompiled with CFR 0.152.
 */
package awl;

import awl.Wave;
import robocode.Robot;

class Enemy {
    boolean hitWall;
    Robot enemy;
    double age;
    double Av;
    double Ah;
    double X;
    double Y;
    double V;
    double Heading;
    double Energy;
    double aimOffset;
    double lastDodge;

    Enemy(Robot enemy) {
        this.enemy = enemy;
        this.aimOffset = 0.0;
        this.lastDodge = 0.0;
    }

    public void setPosition(double x, double y) {
        this.X = x;
        this.Y = y;
    }

    public void setPosition(double x, double y, double D, double bearing) {
        this.X = x + D * Math.sin(bearing);
        this.Y = y + D * Math.cos(bearing);
    }

    public void setVelocity(double v, double heading) {
        this.Av = (v - this.V) / this.age;
        this.V = v;
        this.Ah = (heading - this.Heading) / this.age;
        this.Heading = heading;
        this.age = 0.0;
        this.hitWall = Math.abs(this.Av) > 2.0;
    }

    public Wave setEnergy(double energy) {
        double denergy = this.Energy - energy;
        this.Energy = energy;
        if (denergy >= 0.1 && denergy <= 3.0 && !this.hitWall) {
            return new Wave(this.X, this.Y, denergy, Math.atan2(this.enemy.getX() - this.X, this.enemy.getY() - this.Y) + this.aimOffset, 0, true);
        }
        return new Wave();
    }

    public void setOffset(double delataOffset) {
        this.aimOffset = delataOffset;
    }

    public void setDodge(double dodge) {
        this.lastDodge = dodge;
    }

    public double getGunBearing(double power, int gun) {
        return Math.toDegrees(this.getGunBearingRadians(power, gun));
    }

    public double getGunBearingRadians(double power, int gun) {
        double t = this.getD() / (20.0 - 3.0 * power);
        t = this.getD(t, gun) / (20.0 - 3.0 * power);
        return Math.atan2(this.getX(t, gun) - this.enemy.getX(), this.getY(t, gun) - this.enemy.getY());
    }

    public double getBearing() {
        return Math.toDegrees(this.getBearingRadians());
    }

    public double getBearingRadians() {
        return Math.atan2(this.enemy.getX() - this.getX(1.0, 1), this.getY(1.0, 1) - this.enemy.getY());
    }

    public double getX() {
        return this.X;
    }

    public double getY() {
        return this.Y;
    }

    public double getX(double t, int gun) {
        double x;
        switch (gun) {
            case 0: {
                return this.X;
            }
            case 1: {
                x = this.X + this.V * Math.sin(this.Heading) * t;
                break;
            }
            case 2: {
                if (this.Ah != 0.0) {
                    x = this.X - ((Math.sin(this.Heading) - (1.0 + t) * Math.sin(t * this.Ah + this.Heading) + t * Math.sin((1.0 + t) * this.Ah + this.Heading)) * this.Av + (Math.sin(this.Heading) - Math.sin(this.Ah + this.Heading) - Math.sin(t * this.Ah + this.Heading) + Math.sin((1.0 + t) * this.Ah + this.Heading)) * this.V) / (4.0 * Math.pow(Math.sin(this.Ah / 2.0), 2.0));
                    break;
                }
                if (this.Av * this.V > 0.0 && Math.abs(this.Av * t + this.V) > 8.0) {
                    double v = Math.abs(this.V);
                    x = this.X + ((8.0 + v) * (9.0 - v) * Math.sin(this.Heading) / 2.0 + (t - (9.0 - v)) * 8.0 * Math.sin(this.Heading)) * (double)(this.V < 0.0 ? -1 : 1);
                    break;
                }
                if (this.Av * this.V <= 0.0 && (this.Av * t + this.V) * this.Av > 0.0) {
                    x = this.X + (this.V * (this.V + (double)(this.V > 0.0 ? 2 : -2)) * Math.sin(this.Heading) / 4.0 + (double)(this.V % 2.0 != 0.0 ? false : false)) * (double)(this.V < 0.0 ? -1 : 1);
                    break;
                }
                x = this.X + t * (this.Av + this.Av * t + 2.0 * this.V) * Math.sin(this.Heading) / 2.0;
                break;
            }
            case 3: {
                x = this.X + this.lastDodge * Math.sin(this.Heading);
                break;
            }
            default: {
                return -1.0;
            }
        }
        double width = this.enemy.getBattleFieldWidth() - 18.0;
        return x < 18.0 ? 18.0 : (x > width ? width : x);
    }

    public double getY(double t, int gun) {
        double y;
        switch (gun) {
            case 0: {
                return this.Y;
            }
            case 1: {
                y = this.Y + this.V * Math.cos(this.Heading) * t;
                break;
            }
            case 2: {
                if (this.Ah != 0.0) {
                    y = this.Y - ((Math.cos(this.Heading) - (1.0 + t) * Math.cos(t * this.Ah + this.Heading) + t * Math.cos((1.0 + t) * this.Ah + this.Heading)) * this.Av + (Math.cos(this.Heading) - Math.cos(this.Ah + this.Heading) - Math.cos(t * this.Ah + this.Heading) + Math.cos((1.0 + t) * this.Ah + this.Heading)) * this.V) / (4.0 * Math.pow(Math.sin(this.Ah / 2.0), 2.0));
                    break;
                }
                if (this.Av * this.V > 0.0 && Math.abs(this.Av * t + this.V) > 8.0) {
                    double v = Math.abs(this.V);
                    y = this.Y + ((8.0 + v) * (9.0 - v) * Math.cos(this.Heading) / 2.0 + (t - (9.0 - v)) * 8.0 * Math.cos(this.Heading)) * (double)(this.V < 0.0 ? -1 : 1);
                    break;
                }
                if (this.Av * this.V <= 0.0 && (this.Av * t + this.V) * this.Av > 0.0) {
                    y = this.Y + (this.V * (this.V + (double)(this.V > 0.0 ? 2 : -2)) * Math.cos(this.Heading) / 4.0 + (double)(this.V % 2.0 != 0.0 ? false : false)) * (double)(this.V < 0.0 ? -1 : 1);
                    break;
                }
                y = this.Y + t * (this.Av + this.Av * t + 2.0 * this.V) * Math.cos(this.Heading) / 2.0;
                break;
            }
            case 3: {
                y = this.Y + this.lastDodge * Math.cos(this.Heading);
                break;
            }
            default: {
                return -1.0;
            }
        }
        double height = this.enemy.getBattleFieldHeight() - 18.0;
        return y < 18.0 ? 18.0 : (y > height ? height : y);
    }

    public double getD() {
        return Math.sqrt(Math.pow(this.enemy.getX() - this.X, 2.0) + Math.pow(this.enemy.getY() - this.Y, 2.0));
    }

    public double getD(double t, int gun) {
        return Math.sqrt(Math.pow(this.enemy.getX() - this.getX(t, gun), 2.0) + Math.pow(this.enemy.getY() - this.getY(t, gun), 2.0));
    }

    public double getAh() {
        return this.Ah;
    }

    public double getEnergy() {
        return this.Energy;
    }

    public void tick() {
        this.age += 1.0;
    }
}

