/*
 * Decompiled with CFR 0.152.
 */
package awl;

import awl.Enemy;
import awl.Wave;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Locutus
extends AdvancedRobot {
    static final int GUNS = 4;
    static final int WIDTH = 36;
    static int[] hits;
    static int[] hits2;
    static int guessFactorSum;
    static int bulletts;
    int direction;
    int gun;
    Wave[] waves;
    Wave[][] virtual;
    int numwaves;
    int[] numvirtual;
    long time;
    int lock;
    Enemy enemy;

    public void run() {
        this.enemy = new Enemy((Robot)this);
        this.waves = new Wave[50];
        this.virtual = new Wave[4][200];
        this.numwaves = 0;
        this.direction = 0;
        this.numvirtual = new int[4];
        for (int i = 0; i < 4; ++i) {
            this.numvirtual[i] = 0;
        }
        this.lock = 2;
        this.setColors(Color.black, Color.lightGray, Color.black, Color.red, Color.red);
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            int i;
            this.time = this.getTime();
            this.enemy.tick();
            int offset = 0;
            for (int i2 = 0; i2 < this.numwaves; ++i2) {
                this.waves[i2].tick();
                Wave wave = this.waves[i2];
                if (wave.getRange() > Math.sqrt(Math.pow(wave.getOriginX() - this.getX(), 2.0) + Math.pow(wave.getOriginY() - this.getY(), 2.0))) {
                    --offset;
                    if (this.numwaves <= 1) continue;
                    this.setDirection(this.waves[i2 + 1]);
                    continue;
                }
                this.waves[i2 + offset] = this.waves[i2];
            }
            this.numwaves += offset;
            if (this.numwaves > 0) {
                Wave wave = this.waves[0];
                if (wave.doesHit(this.getX(), this.getY())) {
                    this.setAhead(8 * this.direction);
                }
            } else {
                this.setAhead(0.0);
            }
            double power = 2.0;
            int g = 0;
            while (g < 4) {
                offset = 0;
                if (this.lock < 2) {
                    this.virtual[g][this.numvirtual[g]] = new Wave(this.getX(), this.getY(), power, this.enemy.getGunBearingRadians(power, g), this.gun, this.getGunHeat() == 0.0);
                    int n = g;
                    this.numvirtual[n] = this.numvirtual[n] + 1;
                }
                for (i = 0; i < this.numvirtual[g]; ++i) {
                    this.virtual[g][i].tick();
                    Wave wave = this.virtual[g][i];
                    if (wave.getRange() > Math.sqrt(Math.pow(wave.getOriginX() - this.enemy.getX(), 2.0) + Math.pow(wave.getOriginY() - this.enemy.getY(), 2.0))) {
                        if (new Rectangle((int)Math.round(this.enemy.getX()) - 18, (int)Math.round(this.enemy.getY()) - 18, 36, 36).contains(wave.getX(), wave.getY())) {
                            int n = g;
                            hits[n] = hits[n] + 1;
                            if (wave.isReal()) {
                                int n2 = g;
                                hits2[n2] = hits2[n2] + 1;
                            }
                        }
                        if (wave.isReal() && wave.getGun() == g) {
                            this.enemy.setDodge(-this.virtual[0][i].getRay().ptLineDist(this.enemy.getX(), this.enemy.getY()) * (double)this.virtual[0][i].getRay().relativeCCW(this.enemy.getX(), this.enemy.getY()));
                        }
                        --offset;
                        continue;
                    }
                    this.virtual[g][i + offset] = this.virtual[g][i];
                }
                int n = g++;
                this.numvirtual[n] = this.numvirtual[n] + offset;
            }
            int record = -1;
            for (i = 0; i < 4; ++i) {
                if (hits[i] > record) {
                    record = hits[i];
                    this.gun = i;
                }
                this.out.print(hits[i]);
                this.out.print(" ");
            }
            this.out.println(this.gun);
            for (i = 0; i < 4; ++i) {
                this.out.print(hits2[i]);
                this.out.print(" ");
            }
            this.out.println();
            double radarTurn = Math.toDegrees(Utils.normalRelativeAngle((double)Math.toRadians(this.enemy.getBearing() + this.getRadarHeading())));
            double gunTurn = Math.toDegrees(Utils.normalRelativeAngle((double)Math.toRadians(this.enemy.getGunBearing(power, this.gun) - this.getGunHeading())));
            double robotTurn = Math.toDegrees(Utils.normalRelativeAngle((double)Math.toRadians(this.enemy.getBearing() + this.getHeading() + 90.0)));
            this.setTurnLeft(robotTurn);
            if (this.lock < 2) {
                this.setTurnRadarLeft(radarTurn);
                this.setFire(power);
            } else {
                this.setTurnRadarLeft(360.0);
            }
            this.setTurnGunRight(gunTurn);
            this.scan();
            ++this.lock;
        }
    }

    public void onPaint(Graphics2D g) {
        g.setColor(Color.orange);
        g.drawRect((int)Math.round(this.getX()) - 18, (int)Math.round(this.getY()) - 18, 36, 36);
        double width = this.getBattleFieldWidth();
        double height = this.getBattleFieldHeight();
        double x = this.getX();
        double y = this.getY();
        double heading = this.getHeadingRadians();
        g.drawLine((int)Math.round(x + 61.46 * Math.sin(heading)), (int)Math.round(y + 61.46 * Math.cos(heading)), (int)Math.round(x - 61.46 * Math.sin(heading)), (int)Math.round(y - 61.46 * Math.cos(heading)));
        g.setColor(Color.blue);
        for (int i = 0; i < this.numwaves; ++i) {
            Wave wave = this.waves[i];
            double range = wave.getRange();
            g.drawOval((int)Math.round(wave.getOriginX() - range), (int)Math.round(wave.getOriginY() - range), (int)Math.round(range * 2.0), (int)Math.round(range * 2.0));
            g.drawOval((int)Math.round(wave.getX()), (int)Math.round(wave.getY()), 4, 4);
            g.draw(wave.getRay());
        }
        for (int gun = 0; gun < 4; ++gun) {
            double t = this.enemy.getD() / 17.0;
            t = this.enemy.getD(t, gun) / 17.0;
            switch (gun) {
                case 0: {
                    g.setColor(Color.red);
                    break;
                }
                case 1: {
                    g.setColor(Color.green);
                    break;
                }
                case 2: {
                    g.setColor(Color.yellow);
                    break;
                }
                case 3: {
                    g.setColor(Color.magenta);
                }
            }
            g.drawRect((int)Math.round(this.enemy.getX(t, gun)) - 18, (int)Math.round(this.enemy.getY(t, gun)) - 18, 36, 36);
            for (int i = 0; i < this.numvirtual[gun]; ++i) {
                Wave wave = this.virtual[gun][i];
                g.drawOval((int)Math.round(wave.getX()), (int)Math.round(wave.getY()), 4, 4);
            }
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.lock = 0;
        double V = e.getVelocity();
        double D = e.getDistance();
        this.enemy.setPosition(this.getX(), this.getY(), D, Math.toRadians(e.getBearing() + this.getHeading()));
        this.enemy.setVelocity(V, Math.toRadians(e.getHeading()));
        Wave wave = this.enemy.setEnergy(e.getEnergy());
        if (wave.getPower() > 0.0) {
            this.waves[this.numwaves] = wave;
            if (this.numwaves == 0) {
                this.setDirection(wave);
            }
            ++this.numwaves;
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        double offset = 0.0;
        Bullet b = e.getBullet();
        if (this.numwaves < 1) {
            return;
        }
        Wave wave = this.waves[0];
        offset = b.getHeadingRadians() - wave.getHeadingRadians();
        if (offset != 0.0) {
            for (int i = 0; i < this.numwaves; ++i) {
                this.waves[i].setOffset(offset);
            }
            if (this.numwaves > 0) {
                this.setDirection(this.waves[0]);
            }
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        Bullet b = e.getHitBullet();
        int offset = 0;
        for (int i = 0; i < this.numwaves; ++i) {
            Wave wave = this.waves[i];
            if (Math.abs(wave.getRange() - Math.sqrt(Math.pow(wave.getOriginX() - b.getX(), 2.0) + Math.pow(wave.getOriginY() - b.getY(), 2.0))) < 1.0 + wave.getSpeed()) {
                --offset;
                continue;
            }
            this.waves[i + offset] = this.waves[i];
        }
        this.numwaves += offset;
    }

    public void onBulletHit(BulletHitEvent e) {
        this.enemy.setEnergy(e.getEnergy());
    }

    public void onRobotDeath(RobotDeathEvent e) {
        for (int i = 0; i < 4; ++i) {
            this.numvirtual[i] = 0;
        }
    }

    private void setDirection(Wave wave) {
        this.direction = 0;
        double width = this.getBattleFieldWidth();
        double height = this.getBattleFieldHeight();
        double x = this.getX();
        double y = this.getY();
        double heading = this.getHeadingRadians();
        if (Math.abs(x + 61.46 * Math.sin(heading) - width / 2.0) > width / 2.0 || Math.abs(y + 61.46 * Math.cos(heading) - height / 2.0) > height / 2.0) {
            this.direction = -1;
        } else if (Math.abs(x - 61.46 * Math.sin(heading) - width / 2.0) > width / 2.0 || Math.abs(y - 61.46 * Math.cos(heading) - height / 2.0) > height / 2.0) {
            this.direction = 1;
        }
        this.direction = wave.getDodge(x, y, this.direction);
    }

    static {
        guessFactorSum = 0;
        bulletts = 0;
        hits = new int[4];
        hits2 = new int[4];
        for (int i = 0; i < 4; ++i) {
            Locutus.hits[i] = 0;
            Locutus.hits2[i] = 0;
        }
    }
}

