/*
 * Decompiled with CFR 0.152.
 */
package Noran;

import Noran.GravPoint;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AGravEngine {
    protected Vector gravPoints;
    protected double wallForce;
    protected double width;
    protected double height;
    protected double xForce;
    protected double yForce;
    protected double pointDropoff;
    protected double wallDropoff;

    public void addPoint(GravPoint g) {
        this.gravPoints.add(g);
    }

    public void setWallForce(double wf) {
        this.wallForce = wf;
    }

    public void setPointDropoff(double pdf) {
        this.pointDropoff = pdf;
    }

    public void setWallDropoff(double wdf) {
        this.wallDropoff = wdf;
    }

    public void reset() {
        this.gravPoints = new Vector();
    }

    public void update(double curX, double curY, long time) {
        this.xForce = 0.0;
        this.yForce = 0.0;
        Vector<GravPoint> deadPoints = new Vector<GravPoint>();
        int i = 0;
        while (i < this.gravPoints.size()) {
            GravPoint g = (GravPoint)this.gravPoints.elementAt(i);
            if (g.update(time)) {
                deadPoints.add(g);
            } else {
                double force = g.strength / Math.pow(AGravEngine.dist(curX, curY, g.x, g.y), this.pointDropoff);
                double angle = AGravEngine.getBearing(curX, curY, g.x, g.y);
                this.xForce -= force * Math.sin(angle);
                this.yForce -= force * Math.cos(angle);
            }
            ++i;
        }
        this.xForce += this.wallForce / Math.pow(curX, this.wallDropoff);
        this.xForce -= this.wallForce / Math.pow(this.width - curX, this.wallDropoff);
        this.yForce -= this.wallForce / Math.pow(this.height - curY, this.wallDropoff);
        this.yForce += this.wallForce / Math.pow(curY, this.wallDropoff);
        i = 0;
        while (i < deadPoints.size()) {
            this.gravPoints.remove(deadPoints.elementAt(i));
            ++i;
        }
    }

    public double getXForce() {
        return this.xForce;
    }

    public double getYForce() {
        return this.yForce;
    }

    private static final double dist(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    private static final double getBearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        return Math.atan2(xo, yo);
    }

    private final /* synthetic */ void this() {
        this.gravPoints = new Vector();
        this.wallForce = 0.0;
        this.xForce = 0.0;
        this.yForce = 0.0;
        this.pointDropoff = 2;
        this.wallDropoff = 3;
    }

    public AGravEngine() {
        this(0.0, 0.0);
    }

    public AGravEngine(double width, double height) {
        this.this();
        this.width = width;
        this.height = height;
    }
}

