/*
 * Decompiled with CFR 0.152.
 */
package catcat20.atom.move.surf.plan;

import catcat20.atom.move.surf.path.Path;
import catcat20.atom.move.surf.path.PathPos;
import catcat20.atom.move.surf.plan.SurfPlan;
import catcat20.atom.rader.AtomRader;
import catcat20.atom.robot.Bot;
import catcat20.atom.robot.BotState;
import catcat20.atom.utils.HConstants;
import catcat20.atom.utils.HUtils;
import catcat20.atom.utils.MovementPredictor;
import catcat20.atom.utils.Wave;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import robocode.util.Utils;

public class TronPlan
implements SurfPlan {
    public static final int directions = 4;

    @Override
    public ArrayList<Path> generatePath(MovementPredictor.PredictionStatus status, Wave w) {
        ArrayList<Path> paths = new ArrayList<Path>();
        long genTime = 0L;
        long then = System.nanoTime();
        double division = 4.0;
        int start = 0;
        Bot en = AtomRader.getBot(w.enName);
        BotState enState = en.currentState;
        double enAngle = HUtils.absoluteBearing(status, enState.getPosition());
        for (int i = start; i < 360; i += (int)(360.0 / division)) {
            boolean isDangerAngle = true;
            if (!isDangerAngle || !HConstants.safeField.contains(HUtils.project(status, Math.toRadians(i), 140.0))) continue;
            MovementPredictor.PredictionStatus pos = (MovementPredictor.PredictionStatus)status.clone();
            paths.add(new Path(this.precisePredict(HConstants.safeField, w, 8.0, status, Math.toRadians(i))));
        }
        paths.add(new Path(this.precisePredict(HConstants.safeField, w, 0.0, status, status.heading)));
        long millis = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - then);
        genTime += millis;
        return paths;
    }

    public ArrayList<PathPos> precisePredict(Rectangle2D.Double fieldRect, Wave ew, double maxVelocity, MovementPredictor.PredictionStatus status, double heading) {
        ArrayList<PathPos> cachePoss = new ArrayList<PathPos>();
        int counter = 0;
        boolean intercepted = false;
        MovementPredictor.PredictionStatus predictedStatus = (MovementPredictor.PredictionStatus)status.clone();
        do {
            double diff;
            maxVelocity = (diff = Math.abs(Utils.normalRelativeAngle((double)(Math.toDegrees(heading) - Math.toDegrees(predictedStatus.heading))))) >= 1.5 ? 0.0 : 8.0;
            predictedStatus = MovementPredictor.predict(predictedStatus, heading, maxVelocity);
            PathPos cachePos = new PathPos(predictedStatus.x, predictedStatus.y);
            cachePos.status = predictedStatus;
            cachePos.maxVelocity = maxVelocity;
            cachePos.goHeading = heading;
            cachePos.pathColor = ew.color;
            cachePoss.add(cachePos);
            ++counter;
            if (predictedStatus.distance(ew) < ew.distanceTraveled + (double)counter * ew.bulletVelocity() + ew.bulletVelocity()) {
                intercepted = true;
            }
            if (fieldRect.contains(predictedStatus.x, predictedStatus.y)) continue;
            intercepted = true;
        } while (!intercepted && counter < 30);
        return cachePoss;
    }

    private double distanceScale(double oldDistance, double changeAngle) {
        return Math.abs(Math.cos(changeAngle)) * Math.min(20.0, oldDistance);
    }

    @Override
    public double eval(MovementPredictor.PredictionStatus status, Wave w) {
        return 0.0;
    }
}

