/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.Radar;

import rdt.Wraith.IRobot;
import rdt.Wraith.ISubsystemMode;
import rdt.Wraith.RobotSnapshots.RobotSnapshot;
import rdt.Wraith.Targeting.ITargeting;
import rdt.Wraith.Targeting.Target;
import robocode.util.Utils;

public class FocusTargetMode
implements ISubsystemMode {
    private ITargeting _targeting;
    private IRobot _robot;

    public FocusTargetMode(IRobot robot, ITargeting targeting) {
        this._robot = robot;
        this._targeting = targeting;
    }

    @Override
    public void UpdateHighestPriority() {
        Target currentTarget = this._targeting.GetCurrentTarget();
        RobotSnapshot snapshot = currentTarget.RobotSnapshots.Read(this._robot.getTime());
        double radarOffset = Utils.normalRelativeAngle((double)(snapshot.AbsoluteAngleFromOpponent - this._robot.getRadarHeadingRadians()));
        this._robot.setTurnRadarRightRadians(radarOffset * 2.0);
    }

    @Override
    public float GetPriority() {
        if (!this._targeting.HasValidTarget()) {
            return 0.0f;
        }
        Target currentTarget = this._targeting.GetCurrentTarget();
        if (this._robot.getTime() - currentTarget.LastUpdatedTick > 8L) {
            return 0.0f;
        }
        if (this._robot.getOthers() == 1) {
            return 1.0f;
        }
        return 0.0f;
    }

    @Override
    public void Update() {
    }
}

