/*
 * Decompiled with CFR 0.152.
 */
package amk;

import amk.guns.Aristocles;
import amk.guns.Circular;
import amk.guns.Linear;
import amk.guns.Segment;
import amk.motion.RandomGoTo;
import amk.util.Gun;
import amk.util.MyConstants;
import amk.util.Unit;
import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class ChumbaWumba
extends AdvancedRobot
implements MyConstants {
    String name = "ChumbaWumba";
    String version = "0.3";
    private int timeSinceLastScan = 10;
    static double enemyAbsoluteBearing;
    static double lastEnemyEnergy;
    Unit leader;
    Unit target;
    Gun lgun;
    Gun cgun;
    Gun agun;
    Gun sgun;
    RandomGoTo motion = new RandomGoTo(this);

    public void run() {
        this.setColors(Color.black, new Color(0, 50, 100), new Color(150, 150, 150));
        this.lgun = new Linear(this);
        this.cgun = new Circular(this);
        this.agun = new Aristocles(this);
        this.sgun = new Segment(this);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        while (true) {
            this.doScan();
            this.motion.move();
            this.doFire();
            this.execute();
        }
    }

    public void doScan() {
        ++this.timeSinceLastScan;
        double radarOffset = Double.POSITIVE_INFINITY;
        if (this.timeSinceLastScan < 3) {
            radarOffset = Utils.normalRelativeAngle((double)(this.getRadarHeadingRadians() - enemyAbsoluteBearing));
            radarOffset += (double)this.sign(radarOffset) * 0.02;
        }
        this.setTurnRadarLeftRadians(radarOffset);
    }

    void doFire() {
        if (this.target != null && this.getGunHeat() == 0.0) {
            this.setFire(3.0);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.motion.onScannedRobot(e);
        enemyAbsoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        this.timeSinceLastScan = 0;
        if (this.target == null) {
            this.target = new Unit(e, this);
        } else {
            this.target.update(e, this);
        }
        if (e.getEnergy() == 0.0 || e.getDistance() <= 20.0) {
            this.lgun.prepare(e);
        } else if (e.getName().startsWith("amk")) {
            this.agun.prepare(e);
        } else if (e.getName().startsWith("cjk")) {
            this.cgun.prepare(e);
        } else {
            this.sgun.prepare(e);
        }
        double delta = e.getEnergy() - lastEnemyEnergy;
        if (1.0 <= delta & delta <= 3.0) {
            this.setMaxVelocity(8.0);
            this.turnLeft(this.smallestToParallel(90.0 - e.getBearing()));
        }
        lastEnemyEnergy = e.getEnergy();
    }

    public void onHitWall(HitWallEvent e) {
        this.setTurnRight(115.0);
        this.setAhead(400.0);
        this.execute();
    }

    public void onHitByBullet(HitWallEvent e) {
        this.setTurnRight(115.0);
        this.ahead(400.0);
    }

    public void onHitByRobot(HitWallEvent e) {
        this.setTurnRight(115.0);
        this.setAhead(400.0);
        this.execute();
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (this.target != null && this.target.name == e.getName()) {
            this.target = null;
        }
    }

    public double smallestToParallel(double angle) {
        if (angle > -90.0 && angle <= 90.0) {
            return angle;
        }
        while (angle <= -90.0) {
            angle += 180.0;
        }
        while (angle > 90.0) {
            angle -= 180.0;
        }
        return angle;
    }

    int sign(double v) {
        return v > 0.0 ? 1 : -1;
    }
}

