/*
 * Decompiled with CFR 0.152.
 */
package rampancy.micro;

import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Epiphron
extends AdvancedRobot {
    private static StringBuffer history;
    private static double previousHeading;
    private static double moveDist;
    private static double lastEnergy;

    public void run() {
        this.setColors(new Color(7346833), new Color(5048425), new Color(5048425), Color.white, Color.red);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        if (history == null) {
            history = new StringBuffer();
        }
        while (this.getRadarTurnRemainingRadians() == 0.0) {
            this.setTurnRadarLeftRadians(Math.PI * 5);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double maxPower;
        double radarBearingOffset = Utils.normalRelativeAngle((double)(this.getRadarHeadingRadians() - (e.getBearingRadians() + this.getHeadingRadians())));
        double sign = 0.5235987755982988;
        if (radarBearingOffset < 0.0) {
            sign = -0.5235987755982988;
        }
        this.setTurnRadarLeftRadians(radarBearingOffset + sign);
        double heading = e.getHeadingRadians();
        char dh = this.toChar(Utils.normalRelativeAngle((double)(heading - previousHeading)));
        previousHeading = heading;
        char vel = this.toChar(e.getVelocity());
        history.append("A" + dh + "B" + vel);
        double absB = Utils.normalAbsoluteAngle((double)(e.getBearingRadians() + this.getHeadingRadians()));
        double x = this.getX();
        double y = this.getY();
        double targetX = this.projectX(x, absB, e.getDistance());
        double targetY = this.projectY(y, absB, e.getDistance());
        double power = e.getEnergy() == 0.0 ? 0.1 : (e.getDistance() < 30.0 ? 3.0 : -1.0);
        double d = maxPower = this.getEnergy() < 30.0 ? 0.5 : 2.0;
        if (history.length() > 320) {
            int ind = history.indexOf(history.substring(history.length() - 32, history.length()));
            if (e.getEnergy() > 0.0 && power != 3.0 && ind != -1 && ind < history.length() - 112) {
                String match = history.substring(ind, history.length() - 32);
                int i = 0;
                while (i < match.length()) {
                    double velocity;
                    double pow;
                    if ((pow = (20.0 - this.distance(x, y, targetX = this.projectX(targetX, heading += this.toDouble(match.charAt(i + 1)), velocity = this.toDouble(match.charAt(i + 3))), targetY = this.projectY(targetY, heading, velocity)) / (double)(i / 4 + 1)) / 3.0) > power) {
                        power = pow;
                    }
                    if (pow > maxPower) break;
                    i += 4;
                }
            }
            double angle = Utils.normalRelativeAngle((double)(Utils.normalAbsoluteAngle((double)Math.atan2(targetX - x, targetY - y)) - this.getGunHeadingRadians()));
            this.setTurnGunRightRadians(angle);
            if (power >= 0.1) {
                this.setFire(power);
            }
        }
        if (e.getEnergy() < lastEnergy) {
            moveDist = 100.0 + Math.random() * 100.0;
            if (Math.random() > 0.5) {
                moveDist = -moveDist;
            }
            this.setAhead(moveDist);
        }
        lastEnergy = e.getEnergy();
        this.setTurnRightRadians(Utils.normalRelativeAngle((double)(e.getBearingRadians() + 1.5707963267948966)));
    }

    public void onHitWall(HitWallEvent e) {
        moveDist = -moveDist;
        this.setAhead(moveDist);
    }

    public char toChar(double value) {
        return (char)(value * 1000.0 + 32767.0);
    }

    public double toDouble(char ch) {
        return (double)(ch - Short.MAX_VALUE) / 1000.0;
    }

    public double projectX(double sx, double angle, double dist) {
        return sx + Math.sin(angle) * dist;
    }

    public double projectY(double sy, double angle, double dist) {
        return sy + Math.cos(angle) * dist;
    }

    public double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x1 -= x2) * x1 + (y1 -= y2) * y1);
    }
}

