/*
 * Decompiled with CFR 0.152.
 */
package de._4geeks.robots.guns.VCS;

import de._4geeks.robots.guns.DC.EnemyFeature;
import de._4geeks.robots.guns.manager.Wave;
import de._4geeks.robots.utils.GuessFactorWindow;
import de._4geeks.robots.utils.SUtils;
import java.util.ArrayList;

public class StatsBuffer {
    protected ArrayList<EnemyFeature> features = new ArrayList();
    protected double[] stats;
    protected int[] slices;
    protected int bins;
    protected double nonFiringWeight = 0.0;
    protected int history;
    protected double weight;

    public StatsBuffer(int bins, int history, double w) {
        this.bins = bins;
        this.history = history;
        this.weight = w;
    }

    public StatsBuffer(int bins, int history) {
        this.bins = bins;
        this.history = history;
        this.weight = 1.0;
    }

    public void addFeature(EnemyFeature feat) {
        if (this.stats == null) {
            this.features.add(feat);
        }
    }

    public void initStats() {
        this.initStats(0.0);
    }

    public void initStats(double weight) {
        int statsSize = this.bins + 1;
        this.slices = new int[this.features.size() + 1];
        int i = 0;
        for (EnemyFeature feat : this.features) {
            statsSize *= feat.getSlices().length + 1;
            this.slices[i++] = feat.getSlices().length + 1;
        }
        this.slices[this.features.size()] = this.bins + 1;
        this.stats = new double[statsSize];
        this.nonFiringWeight = weight;
    }

    public void registerWave(Wave wave, GuessFactorWindow window) {
        int offset = 0;
        int i = 0;
        while (i < this.features.size()) {
            offset += this.features.get(i).index(wave);
            offset *= this.slices[i + 1];
            ++i;
        }
        if (wave.isFiringWave()) {
            this.updateBufferLinear(offset, this.stats, window, this.history, 1.0);
        } else if (this.nonFiringWeight > 0.0) {
            this.updateBufferLinear(offset, this.stats, window, this.history, this.nonFiringWeight);
        }
    }

    public void registerWaveNegativ(Wave wave, GuessFactorWindow window) {
        int offset = 0;
        int i = 0;
        while (i < this.features.size()) {
            offset += this.features.get(i).index(wave);
            offset *= this.slices[i + 1];
            ++i;
        }
        if (wave.isFiringWave()) {
            if (wave.isHit()) {
                this.updateBufferNegative(window, offset);
            } else {
                this.updateBufferLinear(offset, this.stats, window, this.history, 1.0);
            }
        } else if (this.nonFiringWeight > 0.0) {
            this.updateBufferLinear(offset, this.stats, window, this.history, this.nonFiringWeight);
        }
    }

    protected void updateBufferNegative(GuessFactorWindow window, int offset) {
        int i = 0;
        while (i < this.bins) {
            if (window.isIn(i, this.bins)) {
                this.stats[offset + i + 1] = SUtils.rollingAvg(this.stats[offset + i + 1], 0.0, this.history, 10.0 * this.weight);
            }
            ++i;
        }
    }

    protected void updateBuffer(int offset, double[] stats, GuessFactorWindow window, int history, double weight) {
        double binHistory = Math.min(stats[offset], (double)history);
        int n = offset++;
        stats[n] = stats[n] + weight;
        int i = 0;
        while (i < this.bins) {
            stats[offset + i] = window.isIn(i, this.bins) ? SUtils.rollingAvg(stats[offset + i], 1.0, binHistory, weight) : SUtils.rollingAvg(stats[offset + i], 0.0, binHistory, weight);
            ++i;
        }
    }

    protected void updateBufferLinear(int offset, double[] stats, GuessFactorWindow window, int history, double weight) {
        double binHistory = Math.min(stats[offset], (double)history);
        int n = offset++;
        stats[n] = stats[n] + weight;
        int i = 0;
        while (i < this.bins) {
            stats[offset + i] = SUtils.rollingAvg(stats[offset + i], window.getFactor(i, this.bins), binHistory, weight);
            ++i;
        }
    }

    public void setNonFiringWeight(double weight) {
        this.nonFiringWeight = weight;
    }

    public int getBestBin(Wave wave) {
        int b = this.getBestNonZeroBin(wave);
        if (b == -1) {
            return this.bins / 2;
        }
        return b;
    }

    public int getBestNonZeroBin(Wave wave) {
        int offset = 0;
        int i = 0;
        while (i < this.features.size()) {
            offset += this.features.get(i).index(wave);
            offset *= this.slices[i + 1];
            ++i;
        }
        double value = 0.0;
        int bestIndex = this.bins / 2;
        ++offset;
        int i2 = 0;
        while (i2 < this.bins) {
            if (this.stats[offset + i2] > value) {
                value = this.stats[offset + i2];
                bestIndex = i2;
            }
            ++i2;
        }
        if (value > 0.0) {
            return bestIndex;
        }
        return -1;
    }

    public void getBins(Wave wave, double[] storage) {
        int offset = 0;
        int i = 0;
        while (i < this.features.size()) {
            offset += this.features.get(i).index(wave);
            offset *= this.slices[i + 1];
            ++i;
        }
        ++offset;
        i = 0;
        while (i < this.bins) {
            int n = i;
            storage[n] = storage[n] + this.weight * this.stats[offset + i];
            ++i;
        }
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }
}

