/*
 * Decompiled with CFR 0.152.
 */
package wcsv.mega;

import java.awt.Graphics;
import robocode.BulletHitBulletEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import wcsv.mega.MyInfo;
import wcsv.mega.ScanInfo;
import wcsv.mega.ScanManager;
import wcsv.mega.Utils;

public abstract class Movement {
    public static final double SLOW_ANGLE = Math.toRadians(40.0);
    protected MyInfo me;
    protected ScanManager scans;

    public Movement(MyInfo me, ScanManager scans) {
        this.me = me;
        this.scans = scans;
    }

    public abstract void onScan(ScanInfo var1);

    public abstract void doMove(ScanInfo var1);

    public abstract void onBulletHitBullet(BulletHitBulletEvent var1);

    public abstract void onHitByBullet(HitByBulletEvent var1);

    public abstract void onHitRobot(HitRobotEvent var1);

    public abstract void onHitWall(HitWallEvent var1);

    public abstract void draw(Graphics var1);

    protected void moveBot(double distance, double angle) {
        if (Math.abs(angle = Utils.relAngle(angle - this.me.getHeadingRadians())) > 1.5707963267948966) {
            distance *= -1.0;
            angle = angle > 0.0 ? (angle -= Math.PI) : (angle += Math.PI);
        }
        this.me.setTurnRightRadians(angle);
        this.me.setMaxVelocity(Math.abs(angle) >= SLOW_ANGLE ? 0.0 : 8.0);
        this.me.setAhead(distance);
    }

    protected void reset(MyInfo newMe, ScanManager newScans) {
        this.me = newMe;
        this.scans = newScans;
    }
}

