/*
 * Decompiled with CFR 0.152.
 */
package cbot.cbot;

import cbot.cbot.Bot;
import cbot.cbot.CBot;
import cbot.cbot.Point;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CU {
    private static CBot robot;
    public static final boolean DEBUG = true;
    public static final double TURNVELOCITY = 20.0;
    public static final double ROBOTLENGTH = 20.0;
    public static double GAMEWIDTH;
    public static double GAMEHEIGHT;
    public static double DISTANCE_SHORT;
    public static double DISTANCE_MIDDLE;
    public static final int TOP_WALL = 1;
    public static final int RIGHT_WALL = 2;
    public static final int BOTTOM_WALL = 3;
    public static final int LEFT_WALL = 4;
    public static final int NO_WALL = -1;

    public static double normalRelativeAngle(double angle) {
        double mod = angle % 360.0;
        if (mod <= -180.0) {
            return 180.0 + mod % 180.0;
        }
        if (mod > 180.0) {
            return -180.0 + mod % 180.0;
        }
        return mod;
    }

    public static double normalRelativeRadians(double angle) {
        double mod = angle % (Math.PI * 2);
        if (mod <= -Math.PI) {
            return Math.PI + mod % Math.PI;
        }
        if (mod > Math.PI) {
            return -Math.PI + mod % Math.PI;
        }
        return mod;
    }

    public static int[] getCloseWalls(Point cordinate, int distance) {
        int CLOSE_TO_WALL = distance;
        double x = cordinate.getX();
        double y = cordinate.getY();
        HashMap<Integer, Double> walls = new HashMap<Integer, Double>(0);
        if (x < (double)CLOSE_TO_WALL) {
            walls.put(new Integer(4), new Double(x));
        }
        if (x > GAMEWIDTH - (double)CLOSE_TO_WALL) {
            walls.put(new Integer(2), new Double(GAMEWIDTH - x));
        }
        if (y < (double)CLOSE_TO_WALL) {
            walls.put(new Integer(3), new Double(y));
        }
        if (y > GAMEHEIGHT - (double)CLOSE_TO_WALL) {
            walls.put(new Integer(1), new Double(GAMEHEIGHT - y));
        }
        if (walls.size() > 0) {
            ArrayList listVersion = new ArrayList(walls.entrySet());
            Collections.sort(listVersion, new Comparator(){

                public final int compare(Object o1, Object o2) {
                    Double v1 = (Double)((Map.Entry)o1).getValue();
                    Double v2 = (Double)((Map.Entry)o2).getValue();
                    return v1.compareTo(v2);
                }
            });
            int count = 0;
            int[] sortedWalls = new int[walls.size()];
            Iterator itr = listVersion.iterator();
            while (itr.hasNext()) {
                Integer key = (Integer)itr.next().getKey();
                sortedWalls[count++] = key;
            }
            return sortedWalls;
        }
        int[] sortedWalls = new int[]{-1};
        return sortedWalls;
    }

    public static double getFirePower(Bot pray) {
        double maxPower = 3;
        if (robot.getEnergy() < (double)5) {
            maxPower = 0.5;
        }
        if (robot.getEnergy() < 1.0) {
            maxPower = 0.0;
        }
        double pow = 3;
        if (pray.getEnergy() <= 16.0) {
            pow = CU.getNecessaryFirePower(pray.getEnergy()) + 0.1;
        }
        if (pow > maxPower) {
            pow = maxPower;
        }
        return pow;
    }

    public static double getNecessaryFirePower(double energy) {
        double pow = energy / (double)4;
        if (pow > 1.0) {
            pow = (energy + (double)2) / 6.0;
        }
        return pow;
    }

    public static double getBulletVelocity(double firePower) {
        return 20.0 - (double)3 * firePower;
    }

    public static double sign(double num) {
        if (num < 0.0) {
            return -1.0;
        }
        return 1.0;
    }

    public static double getLostEnergyByBullet(double power) {
        double damage = (double)4 * power;
        if (power > 1.0) {
            damage += (double)2 * (power - 1.0);
        }
        return damage;
    }

    public static double getGainedEnergyByBullet(double power) {
        return power * (double)3;
    }

    public static int randSign() {
        return Math.random() >= 0.5 ? 1 : -1;
    }

    public static double diff(double d1, double d2) {
        if (d1 > 0.0 && d2 > 0.0) {
            return d1 - d2;
        }
        if (d1 > 0.0 && d2 < 0.0) {
            return d1 + d2;
        }
        return Math.abs(d2) + d1;
    }

    public static String formatNumber(double num, int maxMin) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(maxMin);
        nf.setMinimumFractionDigits(maxMin);
        return nf.format(num);
    }

    public static String formatNumber(double num) {
        return CU.formatNumber(num, 2);
    }

    public static void log(String str) {
    }

    public static void init(CBot r) {
        robot = r;
        GAMEWIDTH = r.getBattleFieldWidth();
        GAMEHEIGHT = r.getBattleFieldHeight();
    }

    static {
        DISTANCE_SHORT = 200.0;
        DISTANCE_MIDDLE = 400.0;
    }
}

