/*
 * Decompiled with CFR 0.152.
 */
package cbot.cbot.gun;

import cbot.cbot.Bot;
import cbot.cbot.CBot;
import cbot.cbot.CU;
import cbot.cbot.Point;
import cbot.cbot.gun.GunStrategy;
import cbot.cbot.gun.Move;

public class CircularGunStrategy
extends GunStrategy {
    protected double getBulletAngel(Bot robot, Bot pray, double firePower) {
        double bulletTravelTime;
        int MAXCOUNT = 30;
        double ACCURACY = 0.01;
        Move[] track = pray.getPattern().getArray();
        if (pray.getPattern().size() < 2) {
            return 0.0;
        }
        Point roboCord = robot.getCordinate();
        Point prayCord = pray.getCordinate();
        double orgBearing = roboCord.getAngle(prayCord);
        double travelTime = bulletTravelTime = pray.getDistance() / CU.getBulletVelocity(firePower);
        double angleVelocity = Math.toRadians(track[1].headingDelta) / (double)(track[1].time / track[0].time);
        angleVelocity = Math.max(0.01, Math.abs(angleVelocity)) * CU.sign(angleVelocity);
        double radius = pray.getVelocity() / angleVelocity;
        double heading = Math.toRadians(pray.getHeading());
        double bulletVelocity = CU.getBulletVelocity(firePower);
        Point newPrayCord = prayCord;
        int i = 0;
        while (i < MAXCOUNT) {
            double headingChange = angleVelocity * travelTime;
            newPrayCord.x += Math.cos(heading) * radius - Math.cos(heading + headingChange) * radius;
            newPrayCord.y += Math.sin(heading + headingChange) * radius - Math.sin(heading) * radius;
            double lastTime = travelTime;
            travelTime = roboCord.getDistance(newPrayCord) / bulletVelocity;
            if (CU.diff(travelTime, lastTime) < ACCURACY) break;
            ++i;
        }
        return CU.normalRelativeRadians(roboCord.getAngle(Point.putPointInValidArea(newPrayCord)) - orgBearing);
    }

    public boolean match(Bot pray) {
        double ACCURACY = 0.5;
        Move[] track = new Move[1];
        double lastHeadingDelta = track[0].headingDelta;
        int i = 1;
        while (i < 10) {
            double headingDelta = track[i].headingDelta;
            if (headingDelta < 0.01) {
                headingDelta = 0.01;
            }
            if (track[i - 1].velocity != track[i].velocity) {
                return false;
            }
            if (lastHeadingDelta - headingDelta > ACCURACY) {
                return false;
            }
            lastHeadingDelta = headingDelta;
            ++i;
        }
        return true;
    }

    protected String getGunSign() {
        return "o";
    }

    public CircularGunStrategy(CBot robot) {
        super(robot);
    }
}

