/*
 * Decompiled with CFR 0.152.
 */
package cbot.cbot.gun;

import cbot.cbot.Bot;
import cbot.cbot.CBot;
import cbot.cbot.CU;
import cbot.cbot.Point;
import cbot.cbot.gun.GunStrategy;
import cbot.cbot.gun.Move;

public class LinearGunStrategy
extends GunStrategy {
    protected double getBulletAngel(Bot robot, Bot pray, double firePower) {
        double orgDistance;
        double newDistance;
        int maxCount = 20;
        double accuracy = 5;
        Point roboCord = robot.getCordinate();
        Point prayCord = pray.getCordinate();
        double orgBearing = roboCord.getAngle(prayCord);
        double prayHeading = Math.toRadians(pray.getHeading());
        double deltaD = newDistance = (orgDistance = pray.getDistance());
        double oldDistance = 0.0;
        double bulletVelocity = CU.getBulletVelocity(firePower);
        double avgVelocity = 0.0;
        Move[] track = pray.getPattern().getArray();
        int size = pray.getPattern().size();
        if (track != null && size > 30) {
            int length = size;
            double totVelocity = 0.0;
            while (length-- > size - 6) {
                totVelocity += track[length].velocity;
            }
            avgVelocity = totVelocity / (double)length;
        } else {
            avgVelocity = pray.getVelocity();
        }
        while (deltaD > accuracy && maxCount-- > 0) {
            double distance = newDistance / bulletVelocity * avgVelocity;
            prayCord.move(distance, prayHeading);
            oldDistance = newDistance;
            newDistance = roboCord.getDistance(prayCord);
            deltaD = Math.abs(oldDistance - newDistance);
        }
        return roboCord.getAngle(prayCord) - orgBearing;
    }

    public boolean match(Bot pray) {
        return false;
    }

    protected String getGunSign() {
        return "-";
    }

    public LinearGunStrategy(CBot robot) {
        super(robot);
    }
}

