/*
 * Decompiled with CFR 0.152.
 */
package bts.mega;

import abc.wiki.DCGun_1on1;
import bts.gun.Gun;
import bts.util.Enemy;
import java.util.LinkedHashMap;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.StatusEvent;
import robocode.util.Utils;

public class Gnarly
extends AdvancedRobot {
    static boolean isMelee = false;
    static LinkedHashMap<String, Double> enemyHashMap;
    static double scanDir;
    static String sought;
    static double xForce;
    static double yForce;
    static double prevEnergy;
    static double direction;
    static Gun gun;
    private Enemy closest = new Enemy("x", Double.MAX_VALUE);

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        if (gun == null) {
            gun = new DCGun_1on1(this);
        }
        gun.initRound();
        if (this.getOthers() > 1) {
            isMelee = true;
            scanDir = 1.0;
            enemyHashMap = new LinkedHashMap(this.getOthers(), 2.0f, true);
            while (isMelee) {
                this.setTurnRadarRightRadians(scanDir * Double.POSITIVE_INFINITY);
                this.scan();
            }
        }
        while (true) {
            this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
            this.scan();
        }
    }

    public void onStatus(StatusEvent e) {
        if (gun != null) {
            gun.execute();
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (isMelee) {
            enemyHashMap.remove(e.getName());
            this.out.println(e.getName() + " has died...");
            sought = null;
            this.closest.setDistance(Double.MAX_VALUE);
            if (this.getOthers() == 1) {
                isMelee = false;
                System.out.println("1 remains");
            }
        }
        if (this.getOthers() == 0) {
            gun.cleanUpRound();
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        gun.update(e);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (isMelee) {
            String name = e.getName();
            LinkedHashMap<String, Double> ehm = enemyHashMap;
            ehm.put(name, this.getHeadingRadians() + e.getBearingRadians());
            if ((name.equals(sought) || sought == null) && ehm.size() == this.getOthers()) {
                scanDir = Utils.normalRelativeAngle((double)(ehm.values().iterator().next() - this.getRadarHeadingRadians()));
                sought = ehm.keySet().iterator().next();
            }
            double absoluteBearing = e.getBearingRadians() + this.getHeadingRadians();
            double distance = e.getDistance();
            xForce = xForce * 0.9 - Math.sin(absoluteBearing) / distance;
            yForce = yForce * 0.9 - Math.cos(absoluteBearing) / distance;
            this.setTurnRightRadians(Utils.normalRelativeAngle((double)(Math.atan2(xForce + 1.0 / this.getX() - 1.0 / (this.getBattleFieldWidth() - this.getX()), yForce + 1.0 / this.getY() - 1.0 / (this.getBattleFieldHeight() - this.getY())) - this.getHeadingRadians())));
            this.setAhead(120.0 - Math.abs(this.getTurnRemaining()));
            if (distance < this.closest.getDistance() || name.equals(this.closest.getName())) {
                if (!this.closest.getName().equals(name)) {
                    this.out.println("Targeting " + name);
                }
                gun.update(e);
                this.closest.setName(name);
                this.closest.setDistance(distance);
            }
        } else {
            double radarTurn = this.getHeadingRadians() + e.getBearingRadians() - this.getRadarHeadingRadians();
            this.setTurnRadarRightRadians(2.5 * Utils.normalRelativeAngle((double)radarTurn));
            this.setTurnRightRadians(Utils.normalRelativeAngle((double)(e.getBearingRadians() + 1.5707963267948966 + -0.3490658503988659 * direction)));
            if (this.getDistanceRemaining() == 0.0) {
                direction = -direction;
                this.setAhead(Math.random() * 144.0 * direction);
            }
            prevEnergy = e.getEnergy();
            gun.update(e);
        }
    }

    public void onDeath(DeathEvent event) {
        gun.cleanUpRound();
        this.out.println("Finished " + (this.getOthers() + 1));
    }

    static {
        prevEnergy = 0.0;
        direction = 1.0;
    }
}

