/*
 * Decompiled with CFR 0.152.
 */
package morbid;

import java.util.HashSet;
import morbid.IEventListener;
import morbid.IRobotController;
import robocode.AdvancedRobot;

abstract class BrokeredObject {
    protected final IRobotController m_controller;
    protected final AdvancedRobot m_robot;
    private final String m_type;
    private boolean m_isActive;
    private long m_activateTime;
    private long m_updateTime;
    private static final boolean DEBUG = false;

    public final String getType() {
        return this.m_type;
    }

    public String toString() {
        return this.getClass().getName() + '@' + this.m_robot.getTime();
    }

    public static Class[] mergeTypeArrays(Class[] a1, Class[] a2) {
        if (a1 == null || a1.length == 0) {
            return a2;
        }
        if (a2 == null || a2.length == 0) {
            return a1;
        }
        HashSet<Class> set = new HashSet<Class>();
        int c = 0;
        while (c < a1.length) {
            set.add(a1[c]);
            ++c;
        }
        int c2 = 0;
        while (c2 < a2.length) {
            set.add(a2[c2]);
            ++c2;
        }
        return set.toArray(new Class[set.size()]);
    }

    protected BrokeredObject(String type, IRobotController controller) {
        if (type == null) {
            throw new IllegalArgumentException("null input: type");
        }
        if (controller == null) {
            throw new IllegalArgumentException("null input: controller");
        }
        this.m_type = type;
        this.m_controller = controller;
        this.m_robot = controller.getRobot();
        this.m_updateTime = -1L;
    }

    protected void create() {
        if (this instanceof IEventListener) {
            this.m_controller.addEventListener((IEventListener)((Object)this));
        }
    }

    protected void activate() {
        this.m_isActive = true;
        this.m_activateTime = this.m_robot.getTime();
    }

    protected void passivate() {
        this.m_isActive = false;
    }

    protected long getActiveTime() {
        return this.m_isActive ? this.m_robot.getTime() - this.m_activateTime : 0L;
    }

    protected boolean isActive() {
        return this.m_isActive;
    }

    protected boolean isUpdated() {
        return this.m_updateTime >= this.m_robot.getTime();
    }

    protected void markAsUpdated() {
        this.m_updateTime = this.m_robot.getTime();
    }

    protected abstract double bid();
}

