/*
 * Decompiled with CFR 0.152.
 */
package morbid;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import morbid.FieldAwareObject;
import morbid.IObject;
import morbid.IRobotController;
import morbid.IRobotPositionManager;
import morbid.Utils;
import robocode.BulletHitEvent;
import robocode.CustomEvent;
import robocode.Event;
import robocode.HitRobotEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

class RobotPositionManager
extends FieldAwareObject
implements IRobotPositionManager {
    private final int m_max_timeseries_size;
    private int m_sweepMode;
    private int m_radarState;
    private double m_radarTurnDirection;
    private long m_sweepTime;
    private double m_arcPhi;
    private double m_arcSector;
    private final Map m_knownAliveObjects;
    private final Set m_knownDeadObjects;
    private TrackedRobot m_self;
    private final double[] m_radar_object_interpolation = new double[2];
    private final double[] m_radar_max_phi_gap = new double[2];
    private boolean AC;
    private static final double RIGHT = 1.0;
    private static final double LEFT = -1.0;
    private static final int SWEEP_MODE_SPIN = 0;
    private static final int SWEEP_MODE_ARC = 1;
    private static final int STOPPED = 0;
    private static final int TURNING_RIGHT = 1;
    private static final int TURNING_LEFT = -1;
    private static final long MAX_RADAR_INTERPOLATION_AGE = 10L;
    private static final long MAX_UPDATE_INTERPOLATION_AGE = 50L;
    private static final boolean INTERPOLATE_UNKNOWN = false;
    private static final IRobotPositionManager.IUpdatedRobot[] EMPTY_IUPDATEROBOT_ARRAY = new IRobotPositionManager.IUpdatedRobot[0];
    private static final boolean DEBUG = false;
    static /* synthetic */ Class class$robocode$RadarTurnCompleteCondition;

    public void update() {
        long time = this.m_robot.getTime();
        List eventQueue = this.m_controller.getEventQueue();
        this.updateScanned(time, eventQueue);
        this.updateDamaged(time, eventQueue);
        this.updateDead(time, eventQueue);
        this.updateUnknown(time);
        this.updateSelf(time);
        this.updateRadarState(time, eventQueue);
        this.updateRadarArc();
    }

    public void act() {
        this.actRadar();
    }

    public int getKnownAliveObjectCount() {
        return this.m_knownAliveObjects.size();
    }

    public IRobotPositionManager.ITrackedRobot[] getKnownAliveObjects() {
        return this.m_knownAliveObjects.values().toArray(new IRobotPositionManager.ITrackedRobot[this.m_knownAliveObjects.size()]);
    }

    public IRobotPositionManager.ITrackedRobot getKnownAliveObject(String ID) {
        return (IRobotPositionManager.ITrackedRobot)this.m_knownAliveObjects.get(ID);
    }

    public boolean isKnownAlive(String ID) {
        return this.m_knownAliveObjects.containsKey(ID);
    }

    public boolean isKnownDead(String ID) {
        return this.m_knownDeadObjects.contains(ID);
    }

    public IRobotPositionManager.ITrackedRobot getSelf() {
        return this.m_self;
    }

    RobotPositionManager(IRobotController controller) {
        super(controller);
        double diagonal = Utils.relativeDistance(0.0, 0.0, this.m_battleFieldWidth, this.m_battleFieldHeight);
        this.m_max_timeseries_size = (int)(diagonal / Utils.bulletPowerToVelocity(3.0));
        this.m_radarTurnDirection = 1.0;
        this.m_sweepMode = 0;
        this.m_radarState = 1;
        this.m_knownAliveObjects = new TreeMap();
        this.m_knownDeadObjects = new HashSet();
    }

    private void updateScanned(long time, List eventQueue) {
        int e = 0;
        int queueLength = eventQueue.size();
        while (e < queueLength) {
            Event _event = (Event)eventQueue.get(e);
            if (_event instanceof ScannedRobotEvent) {
                ScannedRobotEvent event = (ScannedRobotEvent)_event;
                String robotID = event.getName();
                TrackedRobot robot = (TrackedRobot)this.m_knownAliveObjects.get(robotID);
                double[] position = Utils.bearingAndDistanceToXY(this.m_robot.getX(), this.m_robot.getY(), this.m_robot.getHeadingRadians(), event.getBearingRadians(), event.getDistance());
                if (robot == null) {
                    this.m_knownAliveObjects.put(robotID, new TrackedRobot(this.m_max_timeseries_size, robotID, position[0], position[1], event.getHeadingRadians(), event.getVelocity(), event.getEnergy(), time));
                    this.m_controller.getStatsManager().addObjectID(robotID);
                } else {
                    robot.update(position[0], position[1], event.getHeadingRadians(), event.getVelocity(), event.getEnergy(), time);
                }
            }
            ++e;
        }
    }

    private void updateDamaged(long time, List eventQueue) {
        int e = 0;
        int queueLength = eventQueue.size();
        while (e < queueLength) {
            TrackedRobot robot;
            String robotID;
            BulletHitEvent event;
            Event _event = (Event)eventQueue.get(e);
            if (_event instanceof BulletHitEvent) {
                event = (BulletHitEvent)_event;
                robotID = event.getName();
                robot = (TrackedRobot)this.m_knownAliveObjects.get(robotID);
                if (robot != null) {
                    robot.addKnownDamage(time, Utils.bulletPowerToDamage(event.getBullet().getPower()));
                }
            } else if (_event instanceof HitRobotEvent && (robot = (TrackedRobot)this.m_knownAliveObjects.get(robotID = (event = (HitRobotEvent)_event).getName())) != null) {
                robot.addKnownDamage(time, 0.6);
            }
            ++e;
        }
    }

    private void updateDead(long time, List eventQueue) {
        int e = 0;
        int queueLength = eventQueue.size();
        while (e < queueLength) {
            RobotDeathEvent event;
            String robotID;
            IRobotPositionManager.ITrackedRobot robot;
            Event _event = (Event)eventQueue.get(e);
            if (_event instanceof RobotDeathEvent && (robot = (IRobotPositionManager.ITrackedRobot)this.m_knownAliveObjects.get(robotID = (event = (RobotDeathEvent)_event).getName())) != null) {
                this.m_knownAliveObjects.remove(robotID);
                this.m_knownDeadObjects.add(robotID);
            }
            ++e;
        }
    }

    private void updateUnknown(long time) {
        Iterator all = this.m_knownAliveObjects.values().iterator();
        while (all.hasNext()) {
            TrackedRobot robot = (TrackedRobot)all.next();
            long lastUpdateTime = robot.getUpdateTime();
            if (lastUpdateTime >= time || time - lastUpdateTime <= 50L) continue;
            all.remove();
        }
    }

    private void updateSelf(long time) {
        if (this.m_self == null) {
            this.m_self = new TrackedRobot(this.m_max_timeseries_size, this.m_robot.getName(), this.m_robot.getX(), this.m_robot.getY(), this.m_robot.getHeadingRadians(), this.m_robot.getVelocity(), this.m_robot.getEnergy(), time);
        } else {
            this.m_self.update(this.m_robot.getX(), this.m_robot.getY(), this.m_robot.getHeadingRadians(), this.m_robot.getVelocity(), this.m_robot.getEnergy(), time);
        }
    }

    private void updateRadarState(long time, List eventQueue) {
        int e = 0;
        int queueLength = eventQueue.size();
        while (e < queueLength) {
            Event _event = (Event)eventQueue.get(e);
            if (_event instanceof CustomEvent && ((CustomEvent)_event).getCondition().getClass() == (class$robocode$RadarTurnCompleteCondition == null ? RobotPositionManager.class$("robocode.RadarTurnCompleteCondition") : class$robocode$RadarTurnCompleteCondition)) {
                this.m_radarState = 0;
                this.m_sweepTime = time;
                break;
            }
            ++e;
        }
    }

    private void updateRadarArc() {
        int enemyCount = this.m_robot.getOthers();
        switch (enemyCount) {
            case 0: {
                this.setSweepArc(0.0, Math.PI * 2);
                break;
            }
            case 1: {
                IRobotPositionManager.ITrackedRobot[] enemies = this.getKnownAliveObjects();
                if (enemies.length < 1) {
                    this.setSweepArc(0.0, Math.PI * 2);
                    break;
                }
                IRobotPositionManager.ITrackedRobot enemy = enemies[0];
                if (this.m_robot.getTime() - enemy.getUpdateTime() > 10L) {
                    this.setSweepArc(0.0, Math.PI * 2);
                    break;
                }
                this.interpolateRobot(this.m_radar_object_interpolation, enemy);
                double interpolated_enemy_relative_heading = Utils.relativeHeading(this.m_robot.getX(), this.m_robot.getY(), this.m_radar_object_interpolation[0], this.m_radar_object_interpolation[1]);
                this.setSweepArc(interpolated_enemy_relative_heading, 0.39269908169872414);
                break;
            }
            default: {
                IRobotPositionManager.ITrackedRobot[] enemies = this.getKnownAliveObjects();
                if (enemies.length < enemyCount) {
                    this.setSweepArc(0.0, Math.PI * 2);
                    break;
                }
                double[] enemy_phis = new double[enemies.length];
                int e = 0;
                while (e < enemies.length) {
                    IRobotPositionManager.ITrackedRobot enemy = enemies[e];
                    this.interpolateRobot(this.m_radar_object_interpolation, enemy);
                    enemy_phis[e] = Utils.relativeHeading(this.m_robot.getX(), this.m_robot.getY(), this.m_radar_object_interpolation[0], this.m_radar_object_interpolation[1]);
                    ++e;
                }
                Utils.maxPhiGap(this.m_radar_max_phi_gap, enemy_phis);
                this.setSweepArc(this.m_radar_max_phi_gap[0], Math.min(this.m_radar_max_phi_gap[1] + 0.7853981633974483, Math.PI * 2));
            }
        }
    }

    private void actRadar() {
        block0 : switch (this.m_sweepMode) {
            default: {
                this.setTurnRadar(this.m_radarTurnDirection * (Math.PI * 2));
                break;
            }
            case 1: {
                switch (this.m_radarState) {
                    default: {
                        double radarphi = this.m_robot.getRadarHeadingRadians();
                        double deltaphiA = Utils.deltaPhi(Utils.normalizeMinus(this.m_arcPhi, this.m_arcSector / 2.0), radarphi);
                        double deltaphiB = Utils.deltaPhi(Utils.normalizePlus(this.m_arcPhi, this.m_arcSector / 2.0), radarphi);
                        if (Math.abs(deltaphiA) > Math.abs(deltaphiB)) {
                            double deltaphi2A = Utils.deltaPhi2(Utils.normalizeMinus(this.m_arcPhi, this.m_arcSector / 2.0), radarphi, -1.0);
                            this.setTurnRadar(deltaphi2A);
                            break block0;
                        }
                        double deltaphi2B = Utils.deltaPhi2(Utils.normalizePlus(this.m_arcPhi, this.m_arcSector / 2.0), radarphi, 1.0);
                        this.setTurnRadar(deltaphi2B);
                        break block0;
                    }
                    case 1: {
                        break block0;
                    }
                    case -1: 
                }
            }
        }
    }

    private void setSweepArc(double arcphi, double arcsector) {
        if (arcsector >= 5.497787143782138) {
            if (this.m_sweepMode != 0) {
                this.m_sweepMode = 0;
            }
        } else {
            this.m_arcPhi = arcphi;
            this.m_arcSector = arcsector;
            if (this.m_sweepMode != 1) {
                this.setTurnRadarGoTo(Utils.normalizeMinus(this.m_arcPhi, this.m_arcSector / 2.0));
                this.m_sweepMode = 1;
                this.m_sweepTime = this.m_robot.getTime();
            }
        }
    }

    private void setTurnRadar(double phi) {
        if (phi > 0.0) {
            this.m_radarState = 1;
            this.m_radarTurnDirection = 1.0;
            this.m_robot.setTurnRadarRightRadians(phi);
        } else if (phi < 0.0) {
            this.m_radarState = -1;
            this.m_radarTurnDirection = -1.0;
            this.m_robot.setTurnRadarLeftRadians(-phi);
        }
    }

    private void setTurnRadarGoTo(double phi) {
        double radarphi = Utils.normalizePhi(this.m_robot.getRadarHeadingRadians());
        double deltaphi = Utils.deltaPhi(phi, radarphi);
        this.setTurnRadar(deltaphi);
    }

    private void interpolateRobot(double[] out, IRobotPositionManager.ITrackedRobot robot) {
        Utils.interpolate(out, robot.getX(), robot.getY(), robot.getHeadingRadians(), robot.getVelocity(), 1.0);
        if (out[0] < 0.0) {
            out[0] = 0.0;
        } else if (out[0] > this.m_battleFieldWidth) {
            out[0] = this.m_battleFieldWidth;
        }
        if (out[1] < 0.0) {
            out[1] = 0.0;
        } else if (out[1] > this.m_battleFieldHeight) {
            out[1] = this.m_battleFieldHeight;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class TrackedRobot
    implements IRobotPositionManager.ITrackedRobot {
        private final String m_ID;
        private final TrackedRobotTimeSeries m_series;

        public final String getID() {
            return this.m_ID;
        }

        public final double getX() {
            return this.m_series.getRobotPoint(0).getX();
        }

        public final double getY() {
            return this.m_series.getRobotPoint(0).getY();
        }

        public final double[] getXY() {
            IObject.IUpdatedObject object = this.m_series.getPoint(0);
            return new double[]{object.getX(), object.getY()};
        }

        public final double getHeadingRadians() {
            return this.m_series.getRobotPoint(0).getHeadingRadians();
        }

        public final double getVelocity() {
            return this.m_series.getRobotPoint(0).getVelocity();
        }

        public final long getUpdateTime() {
            return this.m_series.getRobotPoint(0).getUpdateTime();
        }

        public final double getEnergy() {
            return this.m_series.getRobotPoint(0).getEnergy();
        }

        public final double getKnownDamage() {
            return this.m_series.getRobotPoint(0).getKnownDamage();
        }

        public final IObject.ITrackedObjectTimeSeries getTimeSeries() {
            return this.m_series;
        }

        public final IRobotPositionManager.ITrackedRobotTimeSeries getRobotTimeSeries() {
            return this.m_series;
        }

        public String toString() {
            StringBuffer s = new StringBuffer(0);
            s.append('{');
            s.append(this.m_ID);
            s.append(": ");
            s.append(this.m_series.getPoint(0));
            s.append('}');
            return s.toString();
        }

        TrackedRobot(int max_timeseries_size, String ID, double x, double y, double heading, double velocity, double energy, long time) {
            this.m_ID = ID;
            this.m_series = new TrackedRobotTimeSeries(max_timeseries_size, ID, x, y, heading, velocity, energy, time);
        }

        void update(double x, double y, double heading, double velocity, double energy, long time) {
            this.m_series.addPoint(this.m_ID, x, y, heading, velocity, energy, time);
        }

        void addKnownDamage(long time, double knownDamage) {
            this.m_series.addKnownDamage(time, knownDamage);
        }
    }

    private static final class UpdatedRobot
    extends IObject.NamedMovingObject
    implements IRobotPositionManager.IUpdatedRobot {
        private long m_updateTime;
        private double m_energy;
        private double m_knownDamage;

        public long getUpdateTime() {
            return this.m_updateTime;
        }

        public double getEnergy() {
            return this.m_energy;
        }

        public double getKnownDamage() {
            return this.m_knownDamage;
        }

        public String toString() {
            StringBuffer s = new StringBuffer(0);
            s.append('{');
            s.append(Utils.printDouble(this.getX()));
            s.append('/');
            s.append(Utils.printDouble(this.getY()));
            s.append(", H ");
            s.append(Utils.printPhi(this.getHeadingRadians()));
            s.append(", V ");
            s.append(Utils.printDouble(this.getVelocity()));
            s.append(", E ");
            s.append(Utils.printDouble(this.m_energy));
            if (this.m_knownDamage > 0.0) {
                s.append(", KD ");
                s.append(Utils.printDouble(this.m_knownDamage));
            }
            s.append(", UT ");
            s.append(this.m_updateTime);
            s.append('}');
            return s.toString();
        }

        private UpdatedRobot(String ID, double x, double y, double heading, double velocity, double energy, long time) {
            super(ID, x, y, heading, velocity);
            this.m_updateTime = time;
            this.m_energy = energy;
        }

        private void set(double x, double y, double heading, double velocity, double energy) {
            this.setXY(x, y);
            this.setHeadingRadians(heading);
            this.setVelocity(velocity);
            this.m_energy = energy;
        }

        private void addKnownDamage(double knownDamage) {
            this.m_knownDamage += knownDamage;
        }
    }

    private static final class TrackedRobotTimeSeries
    implements IRobotPositionManager.ITrackedRobotTimeSeries {
        private UpdatedRobot[] m_series;
        private int m_size;
        private int m_index;
        private boolean AC;

        public int maxsize() {
            return this.m_series.length;
        }

        public int size() {
            return this.m_size;
        }

        public IObject.IUpdatedObject getPoint(int index) {
            return this.getRobotPoint(index);
        }

        public IObject.IUpdatedObject getEarliestPoint() {
            return this.getEarliestRobotPoint();
        }

        public IObject.IUpdatedObject getPointByTime(long time) {
            return this.getRobotPointByTime(time);
        }

        public IRobotPositionManager.IUpdatedRobot getRobotPoint(int index) {
            if ((index = this.m_index - index) < 0) {
                index += this.m_series.length;
            }
            return this.m_series[index];
        }

        public IRobotPositionManager.IUpdatedRobot getEarliestRobotPoint() {
            int index = this.m_index - this.m_size + 1;
            if (index < 0) {
                index += this.m_series.length;
            }
            return this.m_series[index];
        }

        public IRobotPositionManager.IUpdatedRobot getRobotPointByTime(long time) {
            UpdatedRobot result = null;
            UpdatedRobot _result = null;
            int lo = 0;
            int hi = this.m_size - 1;
            while (lo <= hi) {
                int m = (lo + hi) / 2;
                _result = this.getRobotPoint2(m);
                if (_result.m_updateTime > time) {
                    lo = m + 1;
                    continue;
                }
                if (_result.m_updateTime == time) {
                    result = _result;
                    break;
                }
                hi = m - 1;
            }
            if (result == null) {
                result = this.getRobotPoint2(hi < 0 ? 0 : hi);
            }
            return result;
        }

        public void trim(int size) {
            if (size > this.m_size) {
                this.m_size = size;
            }
        }

        public String toString() {
            StringBuffer s = new StringBuffer(0);
            int p = 0;
            while (p < this.size()) {
                s.append(this.getRobotPoint(p));
                s.append(Utils.EOL);
                ++p;
            }
            s.append("------END--------");
            s.append(Utils.EOL);
            return s.toString();
        }

        TrackedRobotTimeSeries(int maxsize, String ID, double x, double y, double heading, double velocity, double energy, long time) {
            this.m_series = new UpdatedRobot[maxsize];
            this.m_index = 0;
            this.m_series[this.m_index] = new UpdatedRobot(ID, x, y, heading, velocity, energy, time);
            this.m_size = 1;
        }

        IObject.IUpdatedObject addPoint(String ID, double x, double y, double heading, double velocity, double energy, long time) {
            int p = 0;
            while (p < this.m_size) {
                UpdatedRobot robot = (UpdatedRobot)this.getRobotPoint(p);
                if (robot.getUpdateTime() == time) {
                    robot.set(x, y, heading, velocity, energy);
                    return robot;
                }
                ++p;
            }
            this.m_index = (this.m_index + 1) % this.m_series.length;
            this.m_series[this.m_index] = new UpdatedRobot(ID, x, y, heading, velocity, energy, time);
            if (this.m_size < this.m_series.length) {
                ++this.m_size;
            }
            return this.m_series[this.m_index];
        }

        void addKnownDamage(long time, double knownDamage) {
            UpdatedRobot robot = (UpdatedRobot)this.getRobotPointByTime(time);
            robot.addKnownDamage(knownDamage);
        }

        private UpdatedRobot getRobotPoint2(int index) {
            if ((index = this.m_index - index) < 0) {
                index += this.m_series.length;
            }
            return this.m_series[index];
        }
    }
}

