/*
 * Decompiled with CFR 0.152.
 */
package jdw.hurricane;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jdw.hurricane.GlobalData;
import jdw.hurricane.gun.EnemyData;
import jdw.hurricane.gun.LinkedRobotState;
import jdw.util.KdTree;

public class Enemy
extends GlobalData
implements Comparable<Enemy> {
    public final int id;
    public boolean alive;
    public boolean active;
    public int scan_ticks;
    public LinkedRobotState scan;
    public int first_add_ticks;
    public LinkedRobotState last_added_state;
    public double x;
    public double y;
    public double x_vel;
    public double y_vel;
    public double x_off;
    public double y_off;
    public double last_dist;
    public double last_energy;
    public double last_heading;
    public double last_vel;
    public Enemy closest_robot;
    public double closest_robot_dist_sq;
    public double[][] gun_heat;
    public EnemyData data;
    public double[] data_weights;
    public double damage = 0.0;
    public double danger = 0.0;
    private final int num_offsets = 50;
    private final int num_freq_offsets = 50;
    private Offset[][][] offsets = new Offset[10][50][50];
    private Offset[][] freq_offsets = new Offset[10][50];

    public Enemy(int _id) {
        this.id = _id;
        this.data = new EnemyData(this, 9);
    }

    public void init_round() {
        this.alive = true;
        this.active = false;
        this.scan = null;
        this.last_added_state = null;
        this.x_vel = 1.0E-6;
        this.y_vel = 1.0E-6;
        this.last_energy = 100.0;
        this.damage = 0.0;
    }

    public void tick(double deactivate_ticks) {
        this.x += this.x_vel;
        this.y += this.y_vel;
        if ((double)this.scan_ticks < deactivate_ticks) {
            this.active = false;
        }
        if (this.last_added_state != null && ticks > this.first_add_ticks) {
            double[] point = this.get_add_point();
            this.last_added_state.point = point;
            this.data.addPoint(point, this.last_added_state);
            this.last_added_state = this.last_added_state.next;
        }
    }

    @Override
    public int compareTo(Enemy e) {
        if (this.active && !e.active) {
            return -1;
        }
        if (!this.active && e.active) {
            return 1;
        }
        return (int)(this.last_dist - e.last_dist);
    }

    public double[] get_pos_at(int _ticks) {
        if (_ticks > this.scan_ticks) {
            int ticks_left = _ticks - this.scan_ticks;
            return new double[]{this.scan.x + this.x_vel * (double)ticks_left, this.scan.y + this.y_vel * (double)ticks_left};
        }
        int ticks_prev = this.scan_ticks - _ticks;
        LinkedRobotState cursor = this.scan;
        while (ticks_prev-- != 0) {
            cursor = cursor.prev;
        }
        return new double[]{cursor.x, cursor.y};
    }

    public void calc_closest_enemy() {
    }

    public void update(double new_x, double new_y, double dist, double energy, double heading, double velocity) {
        if (!this.alive) {
            System.out.println("What just happened? I just scanned a dead robot!!!");
        }
        if (velocity < 1.0E-6) {
            velocity = 1.0E-6;
        }
        double sinr = Math.sin(heading);
        double cosr = Math.cos(heading);
        double new_x_vel = sinr * velocity;
        double new_y_vel = cosr * velocity;
        int time_diff = ticks - this.scan_ticks;
        if (this.active) {
            if (Math.abs(this.scan.x - new_x - this.x_off) < 1.0E-6 && Math.abs(this.scan.y - new_y - this.y_off) < 1.0E-6) {
                this.x_off += new_x_vel;
                this.y_off += new_y_vel;
            } else {
                this.x_off = 0.0;
                this.y_off = 0.0;
            }
            this.scan = this.scan.interpolate_to(time_diff, this.x_vel, this.y_vel, new_x + this.x_off, new_y + this.y_off, new_x_vel, new_y_vel);
        } else {
            this.scan = new LinkedRobotState(null, new_x, new_y);
            this.active = true;
            this.first_add_ticks = ticks + 100;
            this.last_added_state = this.scan;
            this.x_off = 0.0;
            this.y_off = 0.0;
        }
        this.scan_ticks = ticks;
        boolean send_wave = energy - this.last_energy < -0.05;
        this.x = new_x;
        this.y = new_y;
        this.x_vel = new_x_vel;
        this.y_vel = new_y_vel;
        this.last_dist = dist;
        this.last_energy = energy;
        this.last_heading = heading;
        this.last_vel = velocity;
        this.closest_robot_dist_sq = 1.0E9;
        int i = 0;
        while (i < num_enemies_alive) {
            double ry;
            double rx;
            double d;
            Enemy e = sorted_enemies[i];
            if (e.active && (d = (rx = e.x - new_x) * rx + (ry = e.y - new_y) * ry) < this.closest_robot_dist_sq) {
                this.closest_robot = e;
                this.closest_robot_dist_sq = d;
            }
            ++i;
        }
        double rx = pos_x - new_x;
        double ry = pos_y - new_y;
        double d = rx * rx + ry * ry;
        if (d < this.closest_robot_dist_sq) {
            this.closest_robot = null;
            this.closest_robot_dist_sq = d;
        }
    }

    public double[] get_immediate_dims(LinkedRobotState state) {
        double add_x = state.x;
        double add_y = state.y;
        double wall_dist = Math.min(Math.min(add_x - out_min_x_y, add_y - out_min_x_y), Math.min(out_max_x - add_x, out_max_y - add_y)) / max_wall_dist;
        double center_rx = add_x - center_x;
        double center_ry = add_y - center_y;
        double center_dist = Math.sqrt(center_rx * center_rx + center_ry * center_ry) / max_center_dist;
        double vel = 0.0;
        if (this.last_added_state.prev != null) {
            double add_x_vel = this.last_added_state.prev.x - add_x;
            double add_y_vel = this.last_added_state.prev.y - add_y;
            vel = Math.sqrt(add_x_vel * add_x_vel + add_y_vel * add_y_vel) / 8.0;
        }
        return new double[]{this.last_energy / 100.0, 0.0, 0.0, vel, (double)num_enemies_alive / 10.0, wall_dist, center_dist, add_x / out_max_x, add_y / out_max_y};
    }

    public double[] get_cur_point() {
        if (ticks > this.first_add_ticks) {
            return this.get_add_point();
        }
        return new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    }

    public double[] get_add_point() {
        double ry;
        double rx;
        double add_x = this.last_added_state.x;
        double add_y = this.last_added_state.y;
        double antigrav = 0.0;
        double rel_antigrav = 0.0;
        int i = 0;
        while (i < num_enemies_found) {
            if (Enemy.enemies[i].last_added_state != null && enemies[i] != this) {
                rx = Enemy.enemies[i].last_added_state.x - add_x;
                ry = Enemy.enemies[i].last_added_state.y - add_y;
                antigrav += 1000000.0 / (rx * rx + ry * ry);
            }
            ++i;
        }
        rx = pos_x - add_x;
        ry = pos_y - add_y;
        antigrav += 1000000.0 / (rx * rx + ry * ry);
        double wall_dist = Math.min(Math.min(add_x - out_min_x_y, add_y - out_min_x_y), Math.min(out_max_x - add_x, out_max_y - add_y)) / max_wall_dist;
        double center_rx = add_x - center_x;
        double center_ry = add_y - center_y;
        double center_dist = Math.sqrt(center_rx * center_rx + center_ry * center_ry) / max_center_dist;
        double vel = 0.0;
        if (this.last_added_state.prev != null) {
            double add_x_vel = this.last_added_state.prev.x - add_x;
            double add_y_vel = this.last_added_state.prev.y - add_y;
            vel = Math.sqrt(add_x_vel * add_x_vel + add_y_vel * add_y_vel) / 8.0;
        }
        return new double[]{this.last_energy / 100.0, antigrav, rel_antigrav, vel, (double)num_enemies_alive / 10.0, wall_dist, center_dist, add_x / out_max_x, add_y / out_max_y};
    }

    public double get_profit() {
        if (this.last_energy < 16.0) {
            return this.last_energy + (this.damage + this.last_energy) * 0.2 + 1.0 + this.danger * 2.0;
        }
        return 16.0 + this.danger * 2.0;
    }

    public List<double[]> get_targets(int _gun_fire_ticks, double vel, double fire_x, double fire_y) {
        ArrayList<double[]> targets = new ArrayList<double[]>();
        if (this.last_energy < 0.05) {
            return targets;
        }
        List states = this.data.nearestNeighbor(this.get_cur_point(), 16, false);
        double weight_sum = 0.0;
        int c = states.size();
        for (KdTree.Entry entry : states) {
            double[] pos = ((LinkedRobotState)entry.value).get_fire_pos(fire_x, fire_y, _gun_fire_ticks, vel, this);
            if (pos == null) continue;
            double weight = entry.distance;
            Iterator i2 = this.data.nearestNeighbor(((LinkedRobotState)entry.value).point, 4, false).iterator();
            while (i2.hasNext()) {
                weight += i2.next().distance;
            }
            weight = 1.0 / weight;
            weight_sum += weight;
            double[] target = new double[]{pos[0], pos[1], weight};
            targets.add(target);
        }
        double hot_weight = c == 0 ? 0.5 : weight_sum / (double)c;
        double[] target = new double[]{this.x, this.y, hot_weight};
        targets.add(target);
        return targets;
    }

    private class Offset {
        int x;
        int y;
        int occurence;

        private Offset() {
        }
    }
}

