/*
 * Decompiled with CFR 0.152.
 */
package jcs;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.Condition;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class Decepticon
extends AdvancedRobot {
    static final double MAX_VELOCITY = 8.0;
    static final double MAX_WALL_SMOOTH_TRIES = 150.0;
    static final double PI = Math.PI;
    static final int SEARCH_DEPTH = 30;
    static final int MOVEMENT_LENGTH = 150;
    static final int BULLET_SPEED = 11;
    static final int MAX_RANGE = 900;
    static final int SEARCH_END_BUFFER = 111;
    static final int DISTANCE_BINS = 5;
    static final int VELOCITY_BINS = 5;
    static final int WALL_INDEXES = 4;
    static final int VCHANGE_TIME_INDEXES = 6;
    static final int FACTORS = 31;
    static final int MIDDLE_FACTOR = 15;
    static int[][][][][][] gunFactors = new int[5][5][5][6][4][31];
    static int[][][][] moveFactors = new int[5][5][5][31];
    static int[] locationBins = new int[31];
    static double[] penalty = new double[5];
    static double[] benefit = new double[5];
    static double dangerForward;
    static double dangerReverse;
    static EnemyBulletBin currentShot;
    static int enemyShots;
    static int myShots;
    static Enemy target;
    static double fieldWidth;
    static double fieldHeight;
    static double tWidth;
    static Rectangle2D fieldRectangle;
    static Point2D robotLocation;
    static Point2D enemyLocation;
    static double enemyAbsoluteBearing;
    static double enemyDistance;
    static int distanceIndex;
    static int velocityIndex;
    static int enemyTimeSinceVChange;
    static double enemyBearingDirection;
    static double firePower;
    static double maxPower;
    static int lastRobotVelocityIndex;
    static double robotVelocity;
    static int enemyHits;
    static double[] arcLength;
    static int historyIndex;
    static StringBuffer patternMatcher;

    public void run() {
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        target = new Enemy();
        Decepticon.target.distance = 100000.0;
        fieldWidth = this.getBattleFieldWidth();
        fieldHeight = this.getBattleFieldHeight();
        fieldRectangle = new Rectangle2D.Double(tWidth, tWidth, fieldWidth - tWidth * 2.0, fieldHeight - tWidth * 2.0);
        this.setColors(Color.red, Color.orange, Color.yellow);
        currentShot = null;
        this.turnRadarRightRadians(Math.PI * 2);
        while (true) {
            this.doFirePower();
            this.doScanner();
            this.execute();
        }
    }

    void doFirePower() {
        firePower = Decepticon.target.distance < 200.0 ? 3.0 : 1.9;
        firePower = Math.min(this.getEnergy() / 4.0, firePower);
        maxPower = firePower = Math.min(Decepticon.target.energy, firePower);
    }

    void doScanner() {
        double radarOffset;
        if (this.getTime() - Decepticon.target.ctime > 4L) {
            radarOffset = Math.PI * 4;
        } else {
            radarOffset = this.getRadarHeadingRadians() - (1.5707963267948966 - Math.atan2(Decepticon.target.y - this.getY(), Decepticon.target.x - this.getX()));
            radarOffset = (radarOffset = this.NormaliseBearing(radarOffset)) < 0.0 ? (radarOffset -= 0.15707963267948966) : (radarOffset += 0.15707963267948966);
        }
        this.setTurnRadarLeftRadians(radarOffset);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        double power = e.getPower();
        EnemyBulletBin wave = currentShot;
        if (wave != null) {
            wave.registerVisits(++enemyHits);
        }
        Decepticon.target.energy += power * 3.0;
        int n = distanceIndex;
        penalty[n] = penalty[n] + Math.max(power * 7.0, power * 9.0 - 2.0);
    }

    public void onBulletHit(BulletHitEvent e) {
        double power = e.getBullet().getPower();
        double damage = Math.max(4.0 * power, 6.0 * power - 2.0);
        Decepticon.target.energy -= damage;
    }

    public void onWin(WinEvent e) {
    }

    public void onDeath(DeathEvent e) {
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double absbearing_rad = (this.getHeadingRadians() + e.getBearingRadians()) % (Math.PI * 2);
        Decepticon.target.name = e.getName();
        Decepticon.target.ctime = this.getTime();
        Decepticon.target.distance = e.getDistance();
        Decepticon.target.deltaEnergy = Decepticon.target.energy - e.getEnergy();
        Decepticon.target.energy = e.getEnergy();
        Decepticon.target.speedDelta = Decepticon.target.speed - e.getVelocity();
        Decepticon.target.speed = e.getVelocity();
        Decepticon.target.x = this.getX() + Math.sin(absbearing_rad) * Decepticon.target.distance;
        Decepticon.target.y = this.getY() + Math.cos(absbearing_rad) * Decepticon.target.distance;
        BulletBin wave = new BulletBin();
        EnemyBulletBin ew = new EnemyBulletBin();
        ew.gunLocation = new Point2D.Double(enemyLocation.getX(), enemyLocation.getY());
        ew.startBearing = ew.gunBearing(robotLocation);
        if (Decepticon.target.deltaEnergy > 0.0 && Decepticon.target.deltaEnergy <= 3.0) {
            Decepticon.target.firePower = Decepticon.target.deltaEnergy;
            ew.dodgeThisScan = true;
            int n = distanceIndex;
            benefit[n] = benefit[n] + Decepticon.target.deltaEnergy;
            ++enemyShots;
        }
        ew.bulletVelocity = 20.0 - 3.0 * Decepticon.target.firePower;
        double direction = this.robotBearingDirection(ew.startBearing);
        ew.bearingDirection = Math.asin(8.0 / ew.bulletVelocity) * direction / 15.0;
        distanceIndex = (int)Math.min(4.0, enemyDistance / 180.0);
        int[][] nArray = moveFactors[distanceIndex][lastRobotVelocityIndex];
        lastRobotVelocityIndex = (int)Math.abs(robotVelocity / 2.0);
        ew.visits = nArray[lastRobotVelocityIndex];
        robotVelocity = this.getVelocity();
        ew.targetLocation = robotLocation;
        robotLocation.setLocation(new Point2D.Double(this.getX(), this.getY()));
        enemyAbsoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        wave.gunLocation = new Point2D.Double(this.getX(), this.getY());
        enemyLocation.setLocation(Decepticon.project(wave.gunLocation, enemyAbsoluteBearing, enemyDistance));
        wave.targetLocation = enemyLocation;
        enemyDistance = e.getDistance();
        ew.advance(2);
        this.addCustomEvent(ew);
        if (Decepticon.target.speedDelta != 0.0) {
            enemyTimeSinceVChange = 0;
        }
        wave.bulletVelocity = 20.0 - 3.0 * firePower;
        if (Decepticon.target.speed != 0.0) {
            enemyBearingDirection = 0.7 * (double)Decepticon.sign(Decepticon.target.speed * Math.sin(e.getHeadingRadians() - enemyAbsoluteBearing));
        }
        wave.bearingDirection = enemyBearingDirection / 15.0;
        wave.startBearing = enemyAbsoluteBearing;
        int wallIndex = 0;
        while (++wallIndex < 4 && fieldRectangle.contains(Decepticon.project(wave.gunLocation, wave.startBearing + wave.bearingDirection * ((double)wallIndex * 5.5), enemyDistance))) {
        }
        int[][][][] nArray2 = gunFactors[distanceIndex][velocityIndex];
        velocityIndex = (int)Math.abs(Decepticon.target.speed / 2.0);
        wave.visits = nArray2[velocityIndex][(int)Decepticon.minMax(Math.pow(enemyTimeSinceVChange++, 0.45) - 1.0, 0.0, 5.0)][--wallIndex];
        if (historyIndex > 99000) {
            patternMatcher.setLength(121);
        }
        historyIndex = patternMatcher.length();
        double targetBearing = e.getBearingRadians() + this.getHeadingRadians();
        double arcMovement = e.getVelocity() * Math.sin(e.getHeadingRadians() - targetBearing);
        Decepticon.arcLength[Decepticon.historyIndex + 1] = arcLength[historyIndex] + arcMovement;
        patternMatcher.append((char)arcMovement);
        int searchDepth = 30;
        int matchIndex = 0;
        double bspeed = 20.0 - 3.0 * maxPower;
        while ((matchIndex = patternMatcher.lastIndexOf(patternMatcher.substring(historyIndex - --searchDepth), historyIndex - 111)) < 0 && searchDepth > 15) {
        }
        matchIndex += searchDepth;
        if (searchDepth > 20) {
            this.setTurnGunRightRadians(Math.sin((arcLength[matchIndex + (int)(e.getDistance() / bspeed)] - arcLength[matchIndex]) / e.getDistance() + targetBearing - this.getGunHeadingRadians()));
            firePower = maxPower;
        } else {
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(enemyAbsoluteBearing - this.getGunHeadingRadians() + wave.bearingDirection * (double)(wave.mostVisited() - 15))));
        }
        this.addCustomEvent(wave);
        if (this.getEnergy() >= firePower && this.getGunHeat() == 0.0 && Math.abs(this.getGunTurnRemainingRadians()) < Math.atan2(tWidth, enemyDistance)) {
            this.setFire(firePower);
            int n = distanceIndex;
            penalty[n] = penalty[n] + firePower;
            ++myShots;
        }
        if (dangerReverse < dangerForward) {
            direction = -direction;
        }
        dangerReverse = 0.0;
        dangerForward = 0.0;
        double angle = wave.gunBearing(Decepticon.wallSmoothedDestination(robotLocation, direction)) - this.getHeadingRadians();
        this.setAhead(Math.cos(angle) * 100.0);
        this.setTurnRightRadians(Math.tan(angle));
    }

    public double getrange(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        return h;
    }

    static Point2D wallSmoothedDestination(Point2D location, double direction) {
        Point2D destination;
        double smoothing;
        int i = 1;
        do {
            for (smoothing = 0.0; !fieldRectangle.contains(destination = Decepticon.project(location, Decepticon.absoluteBearing(location, enemyLocation) - direction * ((1.25 - smoothing / 100.0) * Math.PI / 2.0), 135.0)) && smoothing < 150.0; smoothing += 1.0) {
            }
            direction = -direction;
        } while (i-- > 0 && distanceIndex < 1 && smoothing > 27.0);
        return destination;
    }

    void updateDirectionStats(EnemyBulletBin wave) {
        dangerReverse += wave.danger(this.waveImpactLocation(wave, -1.0, 5.0));
        dangerForward += wave.danger(this.waveImpactLocation(wave, 1.0, 0.0));
    }

    Point2D waveImpactLocation(EnemyBulletBin wave, double direction, double timeOffset) {
        Point2D impactLocation = new Point2D.Double(this.getX(), this.getY());
        double time = timeOffset;
        while (wave.distanceFromTarget(impactLocation = Decepticon.project(impactLocation, Decepticon.absoluteBearing(impactLocation, Decepticon.wallSmoothedDestination(impactLocation, direction * this.robotBearingDirection(wave.gunBearing(robotLocation)))), 8.0), (int)(time += 1.0)) > -10.0) {
        }
        return impactLocation;
    }

    double robotBearingDirection(double enemyBearing) {
        return Decepticon.sign(this.getVelocity() * Math.sin(this.getHeadingRadians() - enemyBearing));
    }

    static Point2D project(Point2D sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length, sourceLocation.getY() + Math.cos(angle) * length);
    }

    static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    static int sign(double v) {
        return v < 0.0 ? -1 : 1;
    }

    double NormaliseBearing(double ang) {
        if (ang > Math.PI) {
            ang -= Math.PI * 2;
        }
        if (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    static double minMax(double v, double min, double max) {
        return Math.max(min, Math.min(max, v));
    }

    public double findBenefit(int index) {
        if (Math.abs(benefit[index] + penalty[index]) < 1.0E-4) {
            return 0.0;
        }
        return (benefit[index] - penalty[index]) / (benefit[index] + penalty[index]);
    }

    static {
        enemyShots = 0;
        myShots = 0;
        tWidth = 18.5;
        robotLocation = new Point2D.Double();
        enemyLocation = new Point2D.Double();
        enemyHits = 100;
        arcLength = new double[100000];
        historyIndex = 0;
        patternMatcher = new StringBuffer("\u0000\u0003\u0006\u0001\u0004\u0007\u0002\u0005\b\uffff\ufffc\ufff9\ufffe\ufffb\ufff8\ufffd\ufffaThis space filler for end buffer.The numbers up top assure a 1 length match every time.  This string must be longer than SEARCH_END_BUFFER. Given my adjustments it is a bit longer than before.");
    }

    class EnemyBulletBin
    extends BulletBin {
        boolean dodgeThisScan;

        EnemyBulletBin() {
        }

        public boolean test() {
            this.advance(1);
            if (this.passed(-18.0)) {
                this.dodgeThisScan = false;
                currentShot = this;
            }
            if (this.passed(18.0)) {
                Decepticon.this.removeCustomEvent(this);
            }
            if (this.dodgeThisScan) {
                Decepticon.this.updateDirectionStats(this);
            }
            return false;
        }

        double danger(Point2D destination) {
            double smoothed = 0.0;
            int i = 0;
            do {
                smoothed += ((double)locationBins[i] + (double)this.visits[i] * 200.0) / Math.sqrt((double)Math.abs(this.visitingIndex(destination) - i) + 1.0);
            } while (++i < 31);
            return smoothed / Math.sqrt(Math.abs(this.distanceFromTarget(this.targetLocation, 0)) / this.bulletVelocity);
        }
    }

    class BulletBin
    extends Condition {
        double bulletVelocity;
        Point2D gunLocation;
        Point2D targetLocation;
        double startBearing;
        double bearingDirection;
        int[] visits;
        double distanceFromGun;

        BulletBin() {
        }

        public boolean test() {
            this.advance(1);
            if (this.passed(-18.0)) {
                if (Decepticon.this.getOthers() > 0) {
                    this.registerVisits(1);
                }
                Decepticon.this.removeCustomEvent(this);
            }
            return false;
        }

        public boolean passed(double distanceOffset) {
            return this.distanceFromGun > this.gunLocation.distance(this.targetLocation) + distanceOffset;
        }

        void advance(int ticks) {
            this.distanceFromGun += (double)ticks * this.bulletVelocity;
        }

        int visitingIndex(Point2D target) {
            return (int)Decepticon.minMax(Math.round(Utils.normalRelativeAngle((double)(this.gunBearing(target) - this.startBearing)) / this.bearingDirection + 15.0), 0.0, 30.0);
        }

        void registerVisits(int count) {
            int index;
            int n = index = this.visitingIndex(this.targetLocation);
            this.visits[n] = this.visits[n] + count;
            int n2 = index;
            locationBins[n2] = locationBins[n2] + count;
        }

        double gunBearing(Point2D target) {
            return Decepticon.absoluteBearing(this.gunLocation, target);
        }

        double distanceFromTarget(Point2D location, int timeOffset) {
            return this.gunLocation.distance(location) - this.distanceFromGun - (double)timeOffset * this.bulletVelocity;
        }

        int mostVisited() {
            int mostVisited = 15;
            int i = 30;
            do {
                if (this.visits[--i] <= this.visits[mostVisited]) continue;
                mostVisited = i;
            } while (i > 0);
            return mostVisited;
        }
    }

    class Enemy {
        String name;
        public long ctime;
        public double distance;
        public double energy;
        public double deltaEnergy;
        public double x;
        public double y;
        public double firePower;
        public double speed;
        public double speedDelta;

        Enemy() {
        }
    }
}

