/*
 * Decompiled with CFR 0.152.
 */
package starpkg;

import starpkg.Position;

public class EnemyMoveAnlyData {
    public Position fromPos = new Position();
    public long fromPosStopTime;
    public long fromPosStartMoveTime;
    public Position toPos = new Position();
    public long toPosStartStopTime;
    public double heading;
    public double speed;
    public double distance;

    public EnemyMoveAnlyData() {
        this.Reset();
    }

    public void Update(Position cFromPos, long cFromStopTime, long cFromStartTime, Position cToPos, long cToStartTime) {
        this.fromPos = new Position(cFromPos);
        this.fromPosStopTime = cFromStopTime;
        this.fromPosStartMoveTime = cFromStartTime;
        this.toPos = new Position(cToPos);
        this.toPosStartStopTime = cToStartTime;
        this.heading = this.fromPos.DegreeTo(this.toPos);
        if (this.heading < 0.0) {
            this.heading += 360.0;
        }
        this.distance = this.fromPos.Distance(this.toPos);
        this.speed = this.distance / (double)(this.toPosStartStopTime - this.fromPosStartMoveTime);
    }

    public void Update(EnemyMoveAnlyData e) {
        this.Update(e.fromPos, e.fromPosStopTime, e.fromPosStartMoveTime, e.toPos, e.toPosStartStopTime);
    }

    public void Reset() {
        this.fromPos.X = -1000.0;
        this.fromPos.Y = -1000.0;
        this.toPos.X = -1000.0;
        this.toPos.Y = -1000.0;
        this.fromPosStopTime = 0L;
        this.fromPosStartMoveTime = 0L;
        this.toPosStartStopTime = 0L;
        this.heading = -1000.0;
        this.speed = -1000.0;
        this.distance = -1000.0;
    }
}

