/*
 * Decompiled with CFR 0.152.
 */
package starpkg;

import starpkg.EnemyData;
import starpkg.EnemyMoveAnalyser;
import starpkg.EnemyType;
import starpkg.HelperTools;
import starpkg.Position;
import starpkg.StarViewerZ;

public class TargetPredict {
    StarViewerZ robot = null;
    EnemyData enemy = null;
    EnemyMoveAnalyser enemyAnalyser = null;
    HelperTools tools = null;
    EnemyType type = new EnemyType();
    public int enemyType = 0;
    public int predictFireCounter = 0;
    public long enemyStopTime = 0L;
    public long linearConfirmTime = 0L;
    public double usingSpeed = 0.0;
    public long circularConfirmTime = 0L;
    Position[] RAngleGuessPos = new Position[2];
    public int rAngleFireCounter = 0;
    Position[] JiggGuessPos = new Position[4];
    public int jiggFireCounter = 0;
    public double jiggDist = 0.0;

    public TargetPredict(StarViewerZ getRobot) {
        this.robot = getRobot;
        this.enemyAnalyser = this.robot.enemyAnalyser;
        this.enemy = this.robot.enemy.enemyMain;
        this.tools = this.robot.tools;
    }

    public void OnFire() {
        ++this.predictFireCounter;
        if (this.enemyType == 128) {
            ++this.rAngleFireCounter;
        } else if (this.enemyType == 4) {
            ++this.jiggFireCounter;
        }
    }

    public Position GetNextPos(long nowTime, double firePower) {
        if (this.enemy.distance > 80.0 && this.enemy.life >= 0.1) {
            if (this.enemyType == 4) {
                if (this.enemy.distance > 300.0) {
                    return this.GetEnemyJigNextPos(nowTime, firePower);
                }
                if (this.jiggDist > 140.0) {
                    return this.GetEnemyLinNextPos(nowTime, firePower);
                }
                return this.GetEnemyJigNextPos(nowTime, firePower);
            }
            if (this.enemyType == 1) {
                if (this.robot.status.totalEnemy > 2) {
                    if (this.enemy.distance > 650.0) {
                        return this.enemy.pos;
                    }
                    return this.GetEnemyLinNextPos(nowTime, firePower);
                }
                return this.GetEnemyLinNextPos(nowTime, firePower);
            }
            if (this.enemyType == 2) {
                if (this.robot.status.totalEnemy > 2) {
                    if (this.enemy.distance > 650.0) {
                        return this.enemy.pos;
                    }
                    return this.GetEnemyCirNextPos(nowTime, firePower);
                }
                return this.GetEnemyCirNextPos(nowTime, firePower);
            }
            if (this.enemyType == 8) {
                return this.GetEnemyLinNextPos(nowTime, firePower);
            }
            if (this.enemyType == 128) {
                if (this.enemy.distance < 300.0) {
                    this.usingSpeed = this.enemy.realSpeed;
                    return this.GetEnemyLinNextPos(nowTime, firePower);
                }
                if (this.predictFireCounter % 3 == 0) {
                    return this.GetRightAngleNextPos();
                }
                this.usingSpeed = this.enemy.averageSpeed;
                return this.GetEnemyLinNextPos(nowTime, firePower);
            }
            return this.enemy.pos;
        }
        return this.enemy.pos;
    }

    public double GetFirePower() {
        double energy = this.robot.getEnergy();
        if (energy > 4.0) {
            if (this.robot.status.totalEnemy > 1) {
                return this.GetFirePowerMore();
            }
            return this.GetFirePowerOne();
        }
        double firePower = this.GetFirePowerMore();
        if (this.enemy.velocity > 0.0) {
            this.enemyStopTime = this.robot.getTime();
        }
        if (energy > 2.0) {
            if (firePower > 0.1) {
                return firePower / 2.0;
            }
            return 0.0;
        }
        if (energy > 0.3) {
            if (energy - firePower < 0.3) {
                return 0.1;
            }
            return firePower;
        }
        if (this.robot.getTime() - this.enemyStopTime > 30L && this.enemy.life <= 0.0) {
            return 0.1;
        }
        return 0.0;
    }

    public double GetFirePowerOne() {
        if (this.enemy.life > 14.0) {
            if (this.enemyType == 4) {
                return this.GetJigFirePower();
            }
            if (this.enemyType == 1) {
                if (this.enemy.distance > 150.0 && this.enemy.distance <= 500.0) {
                    return 2.0;
                }
                if (this.enemy.distance <= 150.0) {
                    return 3.0;
                }
                return 300.0 / this.enemy.distance;
            }
            if (this.enemyType == 2) {
                if (this.enemy.distance > 150.0 && this.enemy.distance <= 500.0) {
                    return 2.0;
                }
                if (this.enemy.distance <= 150.0) {
                    return 3.0;
                }
                return 300.0 / this.enemy.distance;
            }
            if (this.enemyType == 8) {
                if (this.enemy.distance > 150.0 && this.enemy.distance <= 500.0) {
                    return 2.0;
                }
                if (this.enemy.distance <= 150.0) {
                    return 3.0;
                }
                return 300.0 / this.enemy.distance;
            }
            if (this.enemyType == 128) {
                if (this.enemy.distance > 100.0 && this.enemy.distance <= 500.0) {
                    return 2.0;
                }
                if (this.enemy.distance <= 100.0) {
                    return 3.0;
                }
                return 300.0 / this.enemy.distance;
            }
            if (this.enemy.distance < 100.0) {
                return 3.0;
            }
            return 300.0 / this.enemy.distance;
        }
        if (this.enemyType != 256) {
            if (this.enemy.life <= 0.0) {
                return this.GetPowerFromDamage(this.enemy.life);
            }
            if (this.enemy.distance < 500.0) {
                return this.GetPowerFromDamage(this.enemy.life) + 0.2;
            }
            return 200.0 / this.enemy.distance;
        }
        if (this.enemy.distance < 300.0) {
            return this.GetPowerFromDamage(this.enemy.life);
        }
        return 200.0 / this.enemy.distance;
    }

    public double GetFirePowerMore() {
        if (this.enemy.life > 14.0) {
            if (this.enemyType == 4) {
                return 3.0;
            }
            if (this.enemyType == 1) {
                if (this.enemy.distance > 150.0 && this.enemy.distance <= 650.0) {
                    return 2.0;
                }
                if (this.enemy.distance <= 150.0 || this.enemy.distance > 650.0) {
                    return 2.0;
                }
                return 1.0;
            }
            if (this.enemyType == 2) {
                return 3.0;
            }
            if (this.enemyType == 8) {
                if (this.enemy.distance > 100.0 && this.enemy.distance <= 600.0) {
                    return 2.0;
                }
                if (this.enemy.distance <= 100.0 || this.enemy.distance > 600.0) {
                    return 3.0;
                }
                return 1.0;
            }
            if (this.enemyType == 128) {
                if (this.enemy.distance > 100.0 && this.enemy.distance <= 600.0) {
                    return 2.0;
                }
                if (this.enemy.distance <= 100.0) {
                    return 3.0;
                }
                return 1.0;
            }
            if (this.robot.status.totalEnemy > 2) {
                if (this.enemy.distance < 200.0) {
                    return 3.0;
                }
                if (this.robot.battleArea.screenArea.pos1.Y >= 900.0) {
                    if (this.predictFireCounter % 2 == 0) {
                        return 2.0;
                    }
                    return 3.0;
                }
                if (this.predictFireCounter % 2 == 0) {
                    return 2.0;
                }
                return 1.0;
            }
            if (this.enemy.distance < 150.0) {
                return 3.0;
            }
            return 300.0 / this.enemy.distance;
        }
        if (this.enemy.life <= 0.0) {
            return this.GetPowerFromDamage(this.enemy.life);
        }
        return this.GetPowerFromDamage(this.enemy.life) + 0.3;
    }

    public double GetPowerFromDamage(double damage) {
        double fire = damage <= 4.0 ? damage / 4.0 : (damage + 2.0) / 6.0;
        if (fire <= 0.05) {
            return 0.1;
        }
        return fire;
    }

    public void Update() {
        this.enemy = this.robot.enemy.enemyMain;
        this.enemyAnalyser = this.robot.enemyAnalyser;
        this.enemyAnalyser.Update();
        this.enemyType = this.enemyAnalyser.enemyMoveType;
        if (this.enemyType == 4) {
            this.JigglingPredictUpdate();
        } else if (this.enemyType == 1) {
            this.LinearPredictUpdate();
        } else if (this.enemyType == 2) {
            this.CircularPredictUpdate();
        } else if (this.enemyType == 8) {
            this.JiggingForwardPredictUpdate();
        } else if (this.enemyType == 128) {
            this.RightAnglePredictUpdate();
        }
        if (this.enemyType != 1) {
            this.linearConfirmTime = this.robot.getTime();
        }
        if (this.enemyType != 2) {
            this.circularConfirmTime = this.robot.getTime();
        }
    }

    public void Reset() {
        this.robot.enemyAnalyser.Reset();
        this.circularConfirmTime = this.robot.getTime();
        this.linearConfirmTime = this.robot.getTime();
        this.jiggDist = 0.0;
    }

    public void JiggingForwardPredictUpdate() {
        this.usingSpeed = this.robot.status.totalEnemy > 1 ? this.enemy.averageSpeed : this.enemy.averageSpeed;
    }

    public void LinearPredictUpdate() {
        long ct = 0L;
        if (this.robot.getOthers() > 2) {
            ct = this.enemy.type.linear_gf_PreTime;
        } else {
            ct = this.enemy.type.linear_1v1_PreTime;
            if (this.robot.status.totalEnemy <= 1) {
                if (this.enemy.type.hitPer_1v1_Direct_o > this.enemy.type.hitPer_1v1_Linear_o && this.enemy.type.hitPer_1v1_Direct_o > 20) {
                    ++ct;
                }
                if (this.enemy.type.hitPer_1v1_Jiggling_o > this.enemy.type.hitPer_1v1_Linear_o && this.enemy.type.hitPer_1v1_Jiggling_o > 20) {
                    ++ct;
                }
            }
        }
        if (this.enemyType == 1) {
            if (this.robot.getTime() - this.linearConfirmTime < ct) {
                this.enemyType = this.enemy.type.hitPer_1v1_JigglingForward_o > 20 ? 8 : 256;
            } else {
                this.usingSpeed = this.robot.status.totalEnemy > 1 ? this.enemy.averageSpeed : this.enemy.averageRealSpeed;
            }
        } else {
            this.linearConfirmTime = this.robot.getTime();
        }
    }

    public void CircularPredictUpdate() {
        long ct = 0L;
        ct = this.robot.getOthers() > 1 ? this.enemy.type.circular_gf_PreTime : this.enemy.type.circular_1v1_PreTime;
        if (this.enemyType == 2) {
            if (this.robot.getTime() - this.circularConfirmTime < ct) {
                this.enemyType = 256;
            }
        } else {
            this.circularConfirmTime = this.robot.getTime();
        }
    }

    public void RightAnglePredictUpdate() {
        double dist = 130.0;
        double head = this.enemy.heading_deg;
        double negHead = head + 180.0;
        if (negHead > 360.0) {
            negHead -= 360.0;
        }
        double gX = this.enemy.pos.X + Math.sin(negHead) * (dist / 2.0);
        double gY = this.enemy.pos.Y + Math.cos(negHead) * (dist / 2.0);
        Position tmpPos = this.fixPosition(new Position(gX, gY));
        this.RAngleGuessPos[0] = new Position(tmpPos);
        gX = this.enemy.pos.X + Math.sin(head) * (dist / 2.0);
        gY = this.enemy.pos.Y + Math.cos(head) * (dist / 2.0);
        tmpPos = this.fixPosition(new Position(gX, gY));
        this.RAngleGuessPos[1] = new Position(tmpPos);
    }

    public Position GetRightAngleNextPos() {
        if (this.rAngleFireCounter > 1) {
            this.rAngleFireCounter = 0;
        }
        if (this.rAngleFireCounter == 0) {
            return this.RAngleGuessPos[0];
        }
        return this.RAngleGuessPos[1];
    }

    public void JigglingPredictUpdate() {
        double negHeading;
        int prePtr;
        Position[] twoPos = new Position[2];
        double guessHeading = 0.0;
        double guessSpeed = 0.0;
        double guessDistance = 0.0;
        long stopTime = 0L;
        int curPtr = this.enemyAnalyser.movePtr - 1;
        if (curPtr < 0) {
            curPtr = 3 - 1;
        }
        if ((prePtr = curPtr - 1) < 0) {
            prePtr = 3 - 1;
        }
        int getPtr = 0;
        double angleDiff = this.tools.GetAngleDifferent(this.enemy.heading_deg, this.enemyAnalyser.eMoveData[curPtr].heading);
        getPtr = angleDiff < 90.0 ? curPtr : prePtr;
        twoPos[0] = this.enemyAnalyser.eMoveData[getPtr].fromPos;
        twoPos[1] = this.enemyAnalyser.eMoveData[getPtr].toPos;
        guessHeading = this.enemyAnalyser.eMoveData[getPtr].heading;
        guessSpeed = this.enemyAnalyser.eMoveData[getPtr].speed;
        stopTime = this.enemyAnalyser.eMoveData[getPtr].fromPosStopTime;
        this.jiggDist = guessDistance = this.enemyAnalyser.eMoveData[getPtr].distance;
        this.JiggGuessPos[0] = new Position(twoPos[0]);
        this.JiggGuessPos[1] = new Position(twoPos[1]);
        if (guessDistance < 25.0) {
            guessDistance = 25.0;
        }
        if ((negHeading = guessHeading + 180.0) > 360.0) {
            negHeading -= 360.0;
        }
        double gX = this.enemy.pos.X + Math.sin(negHeading) * (guessDistance / 2.0);
        double gY = this.enemy.pos.Y + Math.cos(negHeading) * (guessDistance / 2.0);
        Position tmpPos = this.fixPosition(new Position(gX, gY));
        this.JiggGuessPos[3] = new Position(tmpPos);
        if (this.JiggGuessPos[0].X < 0.0) {
            this.JiggGuessPos[0] = new Position(tmpPos);
        }
        gX = this.enemy.pos.X + Math.sin(guessHeading) * (guessDistance / 2.0);
        gY = this.enemy.pos.Y + Math.cos(guessHeading) * (guessDistance / 2.0);
        tmpPos = this.fixPosition(new Position(gX, gY));
        this.JiggGuessPos[2] = new Position(tmpPos);
        if (this.JiggGuessPos[1].X < 0.0) {
            this.JiggGuessPos[1] = new Position(tmpPos);
        }
        if (this.robot.status.totalEnemy <= 1 && this.enemy.type.hitPer_1v1_JigglingForward_o > this.enemy.type.hitPer_1v1_Jiggling_o && this.enemy.type.hitPer_1v1_JigglingForward_o > 10) {
            this.usingSpeed = this.enemy.averageSpeed;
            this.enemyType = 8;
        }
    }

    public double GetJigFirePower() {
        if (this.jiggFireCounter == 0) {
            return 3.0;
        }
        if (this.jiggFireCounter == 1) {
            return 2.8;
        }
        return 2.6;
    }

    public Position GetEnemyJigNextPos(long nowTime, double firePower) {
        if (this.jiggFireCounter >= 4) {
            this.jiggFireCounter = 0;
        }
        if (this.jiggFireCounter == 0) {
            return this.JiggGuessPos[0];
        }
        if (this.jiggFireCounter == 1) {
            return this.JiggGuessPos[1];
        }
        if (this.jiggFireCounter == 2) {
            return this.JiggGuessPos[2];
        }
        return this.JiggGuessPos[3];
    }

    public Position fixPosition(Position gPos) {
        if (!this.robot.battleArea.maxArea.PointInside(gPos)) {
            if (gPos.X < this.robot.battleArea.maxArea.pos1.X) {
                gPos.X = this.robot.battleArea.maxArea.pos1.X + 40.0;
            } else if (gPos.X > this.robot.battleArea.maxArea.pos2.X) {
                gPos.X = this.robot.battleArea.maxArea.pos2.X - 40.0;
            }
            if (gPos.Y < this.robot.battleArea.maxArea.pos1.Y) {
                gPos.Y = this.robot.battleArea.maxArea.pos1.Y + 40.0;
            } else if (gPos.Y > this.robot.battleArea.maxArea.pos2.Y) {
                gPos.Y = this.robot.battleArea.maxArea.pos2.Y - 40.0;
            }
        }
        return gPos;
    }

    public Position JigLinNextPos(long preTime, long lastEnemyTime, double jHeading, double jSpeed) {
        double heading_rad = Math.toRadians(jHeading);
        long diffTime = preTime - lastEnemyTime;
        double gX = this.enemy.pos.X + Math.sin(heading_rad) * jSpeed * (double)diffTime;
        double gY = this.enemy.pos.Y + Math.cos(heading_rad) * jSpeed * (double)diffTime;
        return new Position(gX, gY);
    }

    public Position GuessEnemyLinNextPos(long preTime, double speed) {
        double heading_rad = Math.toRadians(this.enemy.heading_deg);
        long diffTime = preTime - this.enemy.lastTime;
        double gX = this.enemy.pos.X + Math.sin(heading_rad) * speed * (double)diffTime;
        double gY = this.enemy.pos.Y + Math.cos(heading_rad) * speed * (double)diffTime;
        return new Position(gX, gY);
    }

    public Position GetEnemyLinNextPos(long nowTime, double firePower) {
        long gTime;
        Position nextPos;
        if (this.enemy.distance > 350.0) {
            nextPos = this.GuessEnemyLinNextPos(nowTime + 30L, this.usingSpeed);
            gTime = nowTime + (long)(new Position(this.robot.getX(), this.robot.getY()).Distance(nextPos) / (20.0 - 3.0 * firePower));
        } else if (this.enemy.distance < 100.0) {
            nextPos = this.GuessEnemyLinNextPos(nowTime - 10L, this.usingSpeed);
            gTime = nowTime + (long)(new Position(this.robot.getX(), this.robot.getY()).Distance(nextPos) / (20.0 - 3.0 * firePower));
        } else {
            gTime = nowTime + (long)(this.enemy.distance / (20.0 - 3.0 * firePower));
        }
        nextPos = this.GuessEnemyLinNextPos(gTime, this.usingSpeed);
        if (!this.robot.battleArea.maxArea.PointInside(nextPos)) {
            if (nextPos.X < this.robot.battleArea.maxArea.pos1.X) {
                nextPos.X = this.robot.battleArea.maxArea.pos1.X + 30.0;
            } else if (nextPos.X > this.robot.battleArea.maxArea.pos2.X) {
                nextPos.X = this.robot.battleArea.maxArea.pos2.X - 30.0;
            }
            if (nextPos.Y < this.robot.battleArea.maxArea.pos1.Y) {
                nextPos.Y = this.robot.battleArea.maxArea.pos1.Y + 30.0;
            } else if (nextPos.Y > this.robot.battleArea.maxArea.pos2.Y) {
                nextPos.Y = this.robot.battleArea.maxArea.pos2.Y - 30.0;
            }
        }
        return nextPos;
    }

    public Position GuessEnemyCirNextPos(long preTime) {
        double headingR = this.enemy.heading_rad;
        long diffTime = preTime - this.enemy.lastTime;
        if (Math.abs(this.enemy.headingTurnSpeed) > 1.0E-5) {
            double radius = this.enemy.velocity / this.enemy.headingTurnSpeed;
            double turnHead = (double)diffTime * this.enemy.headingTurnSpeed;
            double gX = this.enemy.pos.X + Math.cos(headingR) * radius - Math.cos(headingR + turnHead) * radius;
            double gY = this.enemy.pos.Y + Math.sin(headingR + turnHead) * radius - Math.sin(headingR) * radius;
            return new Position(gX, gY);
        }
        return this.GuessEnemyLinNextPos(preTime, this.usingSpeed);
    }

    public Position GetEnemyCirNextPos(long nowTime, double firePower) {
        Position myPos = new Position(this.robot.getX(), this.robot.getY());
        Position nextPos = this.enemy.pos;
        nowTime += 5L;
        int i = 0;
        while (i < 10) {
            long nextTime = (int)Math.round(myPos.Distance(nextPos) / (20.0 - 3.0 * this.robot.status.curFirePower));
            long gTime = nowTime + nextTime;
            nextPos = this.GuessEnemyCirNextPos(gTime);
            ++i;
        }
        if (!this.robot.battleArea.maxArea.PointInside(nextPos)) {
            nextPos = this.enemy.pos;
        }
        return nextPos;
    }
}

